

kernel/drivers/gpu/drm/drm_edid.c

```diff
diff --git a/kernel/drivers/gpu/drm/drm_edid.c b/kernel/drivers/gpu/drm/drm_edid.c
index 258b01e2f..9eb962056 100644
--- a/kernel/drivers/gpu/drm/drm_edid.c
+++ b/kernel/drivers/gpu/drm/drm_edid.c
@@ -221,6 +221,7 @@ static const struct edid_quirk {
  * Autogenerated from the DMT spec.
  * This table is copied from xfree86/modes/xf86EdidModes.c.
  */
+// rpdzkj
 static const struct drm_display_mode drm_dmt_modes[] = {
        /* 0x01 - 640x350@85Hz */
        { DRM_MODE("640x350", DRM_MODE_TYPE_DRIVER, 31500, 640, 672,
@@ -238,6 +239,14 @@ static const struct drm_display_mode drm_dmt_modes[] = {
        { DRM_MODE("640x480", DRM_MODE_TYPE_DRIVER, 25175, 640, 656,
                   752, 800, 0, 480, 490, 492, 525, 0,
                   DRM_MODE_FLAG_NHSYNC | DRM_MODE_FLAG_NVSYNC) },
+
+        /* 0x04 - 640x480@60Hz */
+       { DRM_MODE("480x640", DRM_MODE_TYPE_DRIVER, 25175, 480, 526,
+              530, 570, 0, 640, 656, 658, 692, 0,
+              DRM_MODE_FLAG_PHSYNC | DRM_MODE_FLAG_PVSYNC) },
+
        /* 0x05 - 640x480@72Hz */
        { DRM_MODE("640x480", DRM_MODE_TYPE_DRIVER, 31500, 640, 664,
                   704, 832, 0, 480, 489, 492, 520, 0,
```



kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi-qp.c

```diff
diff --git a/kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi-qp.c b/kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi-qp.c
index 0d5da7b95..313ef2077 100644
--- a/kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi-qp.c
+++ b/kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi-qp.c
@@ -4,6 +4,7 @@
  * Author:
  *      Algea Cao <algea.cao@rock-chips.com>
  */
+#define DEBUG
 #include <linux/clk.h>
 #include <linux/delay.h>
 #include <linux/dma-mapping.h>
@@ -125,6 +126,7 @@ static const struct dw_hdmi_audio_tmds_n common_tmds_n_table[] = {
 };
 
 static const struct drm_display_mode dw_hdmi_default_modes[] = {
+#if 0
        /* 16 - 1920x1080@60Hz 16:9 */
        { DRM_MODE("1920x1080", DRM_MODE_TYPE_DRIVER, 148500, 1920, 2008,
                   2052, 2200, 0, 1080, 1084, 1089, 1125, 0,
@@ -135,6 +137,15 @@ static const struct drm_display_mode dw_hdmi_default_modes[] = {
                   798, 858, 0, 480, 489, 495, 525, 0,
                   DRM_MODE_FLAG_NHSYNC | DRM_MODE_FLAG_NVSYNC),
          .picture_aspect_ratio = HDMI_PICTURE_ASPECT_4_3, },
+
+#endif
+       /* 127 - 480x640@60Hz 4:3 */
+       { DRM_MODE("480x640", DRM_MODE_TYPE_DRIVER, 25175, 480, 526,
+              530, 570, 0, 640, 656, 658, 692, 0,
+              DRM_MODE_FLAG_PHSYNC | DRM_MODE_FLAG_PVSYNC),
+        .picture_aspect_ratio = HDMI_PICTURE_ASPECT_NONE, },
+
+#if 0
        /* 4 - 1280x720@60Hz 16:9 */
        { DRM_MODE("1280x720", DRM_MODE_TYPE_DRIVER, 74250, 1280, 1390,
                   1430, 1650, 0, 720, 725, 730, 750, 0,
@@ -160,6 +171,7 @@ static const struct drm_display_mode dw_hdmi_default_modes[] = {
                   798, 858, 0, 480, 489, 495, 525, 0,
                   DRM_MODE_FLAG_NHSYNC | DRM_MODE_FLAG_NVSYNC),
          .picture_aspect_ratio = HDMI_PICTURE_ASPECT_4_3, },
+#endif
 };
 
 enum frl_mask {
@@ -2114,7 +2126,8 @@ static int dw_hdmi_connector_get_modes(struct drm_connector *connector)
                return 0;
 
        memset(metedata, 0, sizeof(*metedata));
-       edid = drm_get_edid(connector, hdmi->ddc);
+       edid = NULL;
+       //edid = drm_get_edid(connector, hdmi->ddc);
        if (edid) {
                dev_dbg(hdmi->dev, "got edid: width[%d] x height[%d]\n",
                        edid->width_cm, edid->height_cm);
@@ -2288,7 +2301,8 @@ static void dw_hdmi_attach_properties(struct dw_hdmi_qp *hdmi)
                if (hdmi->plat_data->get_grf_color_fmt)
                        color = hdmi->plat_data->get_grf_color_fmt(data);
 
-               val = (hdmi_readl(hdmi, PKT_VSI_CONTENTS1) >> 8) & 0xffffff;
+               val = HDMI_FORUM_OUI;
+               //val = (hdmi_readl(hdmi, PKT_VSI_CONTENTS1) >> 8) & 0xffffff;
                if (val == HDMI_FORUM_OUI)
                        hdmi->allm_enable = true;
                else
```



kernel/arch/arm64/boot/dts/rockchip/rk3588/rd-rk3588.dts，这里以rd-rk3588版型为例，其他版型添加到对应的主dts文件中。

```diff
diff --git a/kernel/arch/arm64/boot/dts/rockchip/rk3588/rd-rk3588.dts b/kernel/arch/arm64/boot/dts/rockchip/rk3588/rd-rk3588.dts
index 41b3aab3b..dadb47e56 100644
--- a/kernel/arch/arm64/boot/dts/rockchip/rk3588/rd-rk3588.dts
+++ b/kernel/arch/arm64/boot/dts/rockchip/rk3588/rd-rk3588.dts
@@ -60,14 +60,14 @@
 //#include "rp-camera-dphy0-imx415.dtsi"
 /******************************************/
 
-//#include "rp-lcd-hdmi0.dtsi"        //batch ignore
+#include "rp-lcd-hdmi0.dtsi"        //batch ignore
 //#include "rp-lcd-hdmi1.dtsi"        //batch ignore
 //#include "rp-lcd-typec-dp0.dtsi"    //usb edp0,must be enable rp-usb-typec.dtsi, batch ignore
 //#include "rp-lcd-multi-hdmi0-hdmi1-dp0.dtsi" 
 
 /* lcd */
 //#include "rp-lcd-mipi0-5-720-1280-v2-boxTP.dtsi"
-#include "rp-lcd-mipi0-7-720-1280.dtsi"
+//#include "rp-lcd-mipi0-7-720-1280.dtsi"
 //#include "rp-lcd-mipi0-8-800-1280-v3.dtsi"
 //#include "rp-lcd-mipi0-8-1200-1920.dtsi"
 //#include "rp-lcd-mipi0-10-800-1280-v3.dtsi"
@@ -257,6 +257,21 @@
     //vmmc-supply = <&vccio_sd_s0>;
 };
+
+&display_subsystem {
+clocks = <&hdptxphy_hdmi_clk0>, <&hdptxphy_hdmi_clk1>;
+clock-names = "hdmi0_phy_pll", "hdmi1_phy_pll";
+};
+
+&hdptxphy_hdmi_clk0 {
+            status = "okay";
+};
+
+&hdptxphy_hdmi_clk1 {
+            status = "okay";
+};
+
 &fiq_debugger {
     rockchip,baudrate = <115200>;
 };
```

