package android.rk.RockVideoPlayer.ui;

import java.util.Random;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;

public class DeleteFrame extends SurfaceView {

    private final static int STEP = 30;
    private final static int DUE = 0;

    Paint mPaint = null;
    private Bitmap mBitmap = null;
    private Bitmap mBitmapbk = null;
    private Bitmap mDirBitmap = null;
    private Bitmap mBitmap_1 = null;
    private Bitmap mBitmap_2 = null;
    private Bitmap mBitmap_3 = null;
    private Bitmap mBitmap_4 = null;
    private int current_x;
    private int current_y;
    private int target_x;
    private int target_y;
    private int step_x;
    private int step_y;

    private int dir_x = 0;
    private int dir_y = 0;
    private int dir_w = 0;
    private int dir_h = 0;
    private int per_dir_w = 0;

    private float ratation1 = 0.0f;
    private float ratation2 = 0.0f;
    private float ratation3 = 0.0f;
    private float ratation4 = 0.0f;

    private SurfaceHolder mSurfaceHolder;
    private Handler mHandler = null;
    private static Random random = new Random(50);
    private boolean isfinishanimation = true;

    public DeleteFrame(Context context, AttributeSet attrs) {
        super(context, attrs);
        mPaint = new Paint();
        mPaint.setColor(Color.GREEN);
        mSurfaceHolder = getHolder();
        setZOrderOnTop(true);
        mSurfaceHolder.setFormat(PixelFormat.TRANSLUCENT);
        mThread.start();
    }

    private void onMyDraw(Canvas canvas) {
//		Log.d("DeleteFrame", " -------------->  current_x = " + current_x + "    current_y = " + current_y);
        canvas.drawBitmap(mDirBitmap, dir_x, dir_y, mPaint);
        canvas.save(Canvas.ALL_SAVE_FLAG);
        canvas.rotate(ratation1, current_x + mBitmap_1.getWidth() / 2, current_y + mBitmap_1.getHeight() / 2);
        canvas.drawBitmap(mBitmap_1, current_x, current_y, mPaint);
        canvas.restore();
        canvas.save(Canvas.ALL_SAVE_FLAG);
        canvas.rotate(ratation2, current_x + mBitmap_1.getWidth() + mBitmap_2.getWidth() / 2, current_y + mBitmap_2.getHeight() / 2);
        canvas.drawBitmap(mBitmap_2, current_x + mBitmap_1.getWidth(), current_y, mPaint);
        canvas.restore();
        canvas.save(Canvas.ALL_SAVE_FLAG);
        canvas.rotate(ratation3, current_x + mBitmap_3.getWidth() / 2, current_y + mBitmap_1.getHeight() + mBitmap_3.getHeight() / 2);
        canvas.drawBitmap(mBitmap_3, current_x, current_y + mBitmap_1.getHeight(), mPaint);
        canvas.restore();
        canvas.save(Canvas.ALL_SAVE_FLAG);
        canvas.rotate(ratation4, current_x + mBitmap_3.getWidth() + mBitmap_4.getWidth() / 2, current_y + mBitmap_2.getHeight() + mBitmap_4.getHeight() / 2);
        canvas.drawBitmap(mBitmap_4, current_x + mBitmap_3.getWidth(), current_y + mBitmap_2.getHeight(), mPaint);
        canvas.restore();
    }

    public void setMove(int x1, int y1, int x2, int y2, Bitmap bitmap, Bitmap bitmapbk) {
        setVisibility(View.VISIBLE);
        if (!isfinishanimation) {
            return;
        }
        isfinishanimation = false;
        current_x = x1;
        current_y = y1;
        target_x = x2;
        target_y = y2;
        step_x = (x2 - x1) / STEP;
        step_y = (y2 - y1 - SLOW_STEP_PER * SLOW_STEP) / STEP;
        ratation1 = 0.0f;
        ratation2 = 0.0f;
        ratation3 = 0.0f;
        ratation4 = 0.0f;
        per_dir_w = (int) Math.sqrt(bitmap.getWidth() * bitmap.getWidth() + bitmap.getHeight() * bitmap.getHeight()) + 2;
        if (mBitmap != null) {
            mBitmap.recycle();
        }
        mBitmap = bitmap;
        if (mBitmapbk != null) {
            mBitmapbk.recycle();
        }
        mBitmapbk = bitmapbk;
        int x, y, w, h;
        if (mBitmap_1 != null) {
            mBitmap_1.recycle();
        }
        x = 0;
        y = 0;
        w = mBitmap.getWidth() * 2 / 3;
        h = mBitmap.getHeight() / 2;
        mBitmap_1 = Bitmap.createBitmap(mBitmap, x, y, w, h);

        if (mBitmap_2 != null) {
            mBitmap_2.recycle();
        }
        x = mBitmap.getWidth() * 2 / 3;
        y = 0;
        w = mBitmap.getWidth() - x;
        h = mBitmap.getHeight() / 2;
        mBitmap_2 = Bitmap.createBitmap(mBitmap, x, y, w, h);

        if (mBitmap_3 != null) {
            mBitmap_3.recycle();
        }
        x = 0;
        y = mBitmap.getHeight() / 2;
        w = mBitmap.getWidth() / 3;
        h = mBitmap.getHeight() - y;
        mBitmap_3 = Bitmap.createBitmap(mBitmap, x, y, w, h);

        if (mBitmap_4 != null) {
            mBitmap_4.recycle();
        }
        x = mBitmap.getWidth() / 3;
        y = mBitmap.getHeight() / 2;
        w = mBitmap.getWidth() - x;
        h = mBitmap.getHeight() - y;
        mBitmap_4 = Bitmap.createBitmap(mBitmap, x, y, w, h);
        mHandler.sendEmptyMessageDelayed(0, 100);
        currentstep = 0;
    }

    private int currentstep = 0;
    private final static int SLOW_STEP = 15;
    private final static int SLOW_STEP_PER = 1;
    private Thread mThread = new Thread() {
        public void run() {
            Looper.prepare();
            mHandler = new Handler() {
                public void dispatchMessage(android.os.Message msg) {
                    if (currentstep < SLOW_STEP) {
                        current_x = current_x;
                        current_y += SLOW_STEP_PER;
                    } else {
                        current_x += step_x;
                        current_y += step_y;
                    }
                    currentstep++;
//					invalidate();
                    if (mDirBitmap != null) {
                        mDirBitmap.recycle();
                    }
                    dir_x = (current_x + mBitmap.getWidth() / 2 - per_dir_w / 2) - 2 * step_x;
                    dir_y = (current_y + mBitmap.getHeight() / 2 - per_dir_w / 2) - 2 * step_y;
                    if (dir_x < 0)
                        dir_x = 0;
                    if (dir_y < 0)
                        dir_y = 0;
                    if (dir_x + per_dir_w + 2 * step_x > getWidth()) {
                        dir_w = getWidth() - dir_x;
                    } else {
                        dir_w = per_dir_w + 2 * step_x;
                    }
                    if (dir_y + per_dir_w + 2 * step_y > getHeight()) {
                        dir_h = getHeight() - dir_y;
                    } else {
                        dir_h = per_dir_w + 2 * step_y;
                    }
                    mDirBitmap = Bitmap.createBitmap(mBitmapbk, dir_x, dir_y, dir_w, dir_h);
                    ratation1 -= random.nextFloat() * 3;
                    ratation2 += random.nextFloat() * 3;
                    ratation3 += random.nextFloat() * 3;
                    ratation4 -= random.nextFloat() * 3;
                    Canvas c = null;
                    try {
//		            	Rect mRect = new Rect(current_x - step_x, current_y - step_y, current_x + mBitmap.getWidth(), current_y + mBitmap.getHeight());
                        Rect mRect = new Rect(0, 0, getWidth(), getHeight());
                        c = mSurfaceHolder.lockCanvas(mRect);
                        synchronized (mSurfaceHolder) {
                            if (c != null) {
                                onMyDraw(c);
                            }
                        }
                    } finally {
                        if (c != null) {
                            mSurfaceHolder.unlockCanvasAndPost(c);
                        }
                    }


                    if (current_y <= target_y && current_x <= target_x) {
                        if (currentstep < SLOW_STEP) {
                            mBitmap_1 = bitmapRoom(mBitmap_1, 0.99f);
                            mBitmap_2 = bitmapRoom(mBitmap_2, 0.99f);
                            mBitmap_3 = bitmapRoom(mBitmap_3, 0.99f);
                            mBitmap_4 = bitmapRoom(mBitmap_4, 0.99f);
                        } else {
                            mBitmap_1 = bitmapRoom(mBitmap_1, 0.97f);
                            mBitmap_2 = bitmapRoom(mBitmap_2, 0.98f);
                            mBitmap_3 = bitmapRoom(mBitmap_3, 0.97f);
                            mBitmap_4 = bitmapRoom(mBitmap_4, 0.98f);
                        }
                        sendEmptyMessageDelayed(0, DUE);
                    } else {
                        mUIHandler.sendEmptyMessageDelayed(0, 0);
                    }
                }

                ;
            };
            Looper.loop();
        }

        ;
    };
    private Handler mUIHandler = new Handler() {
        public void dispatchMessage(android.os.Message msg) {
            setVisibility(View.GONE);
            isfinishanimation = true;
        }

        ;
    };

    private Bitmap bitmapRoom(Bitmap srcBitmap, float scale) {
        int srcWidth = srcBitmap.getWidth();
        int srcHeight = srcBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizedBitmap = Bitmap.createBitmap(srcBitmap, 0, 0, srcWidth,
                srcHeight, matrix, true);
        if (resizedBitmap != null) {
            srcBitmap.recycle();
            return resizedBitmap;
        }
        return srcBitmap;
    }
}