package android.rk.RockVideoPlayer.armFreq.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

public class Utils {

    private static final String TAG = "Utils";

    private static File frequenciesFile = new File("/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies");
    private static File cur_freqFile = new File("/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq");
    private static File governor_freqFile = new File("/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor");
    private static File setspeed_freqFile = new File("/sys/devices/system/cpu/cpu0/cpufreq/scaling_setspeed");
    public static final String USERSPACE_MODE = "userspace";
    public static final String INTERACTIVE_MODE = "interactive";

    public static void setGovernorMode(String mode) throws FileNotFoundException, IOException {
//		if(governor_freqFile.exists()){
//			try {
        PMwriteFile(governor_freqFile, mode);
//			} catch (Exception re) {
//				re.printStackTrace();
//				Log.e(TAG, "IO Exception");
//			}
//		}
    }

    public static void setSpeedFreq(int value) throws FileNotFoundException, IOException {
//		if(setspeed_freqFile.exists()){
//			try {
        PMwriteFile(setspeed_freqFile, String.valueOf(value));
//			} catch (Exception re) {
//				re.printStackTrace();
//				Log.e(TAG, "IO Exception");
//			}
//		}
    }

    private static boolean PMwriteFile(File file, String message) throws FileNotFoundException, IOException {
        //Log.i(TAG, "PMwriteFile:" + Path + "\nMSG:" + message);
//		try {
//			File file = new File(Path);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (file.canWrite()) {
            FileOutputStream fout = new FileOutputStream(file);
            byte[] bytes = message.getBytes();
            fout.write(bytes);
            fout.close();
        } else {
            Log.e(TAG, file.toString() + "can not write");
            IOException io = new IOException();
            throw io;
        }
//		} catch (Exception e) {
//			e.printStackTrace();
//			return false;
//		}
        return true;

    }

    public static List<String> getAvailableFrequencies() {
        List<String> result = new ArrayList<String>();
        if (frequenciesFile.exists()) {
            try {
                FileReader fread = new FileReader(frequenciesFile);
                BufferedReader buffer = new BufferedReader(fread);
                String str = null;
                StringBuilder sb = new StringBuilder();
                while ((str = buffer.readLine()) != null) {
                    sb.append(str);
                }
                String temp[] = sb.toString().split(" ");
                if (temp != null && temp.length > 0) {
                    for (int i = 0; i < temp.length; i++) {
                        result.add(Integer.valueOf(temp[i]) / 1000 + "M");
                    }
                }
            } catch (IOException e) {
                Log.e(TAG, "IO Exception");
            }
        }

        return result;
    }

    public static Integer getCurFrequencies() {
        Integer result = 0;
        if (cur_freqFile.exists()) {
            try {
                FileReader fread = new FileReader(cur_freqFile);
                BufferedReader buffer = new BufferedReader(fread);
                String str = null;
                StringBuilder sb = new StringBuilder();
                while ((str = buffer.readLine()) != null) {
                    sb.append(str);
                }
                result = Integer.valueOf(sb.toString());
            } catch (IOException e) {
                Log.e(TAG, "IO Exception");
            }
        }

        return result;
    }

}
