/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.rk.RockVideoPlayer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory.Options;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.provider.MediaStore;
import android.provider.MediaStore.Video;
import android.rk.RockVideoPlayer.ImageCache.ImageCacheService;
import android.rk.RockVideoPlayer.ImageCache.ImageCacheService.ImageData;
import android.rk.RockVideoPlayer.RockVideoPlayer.COL_IND;
import android.rk.RockVideoPlayer.ui.DeleteImage;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AlphabetIndexer;
import android.widget.CursorAdapter;
import android.widget.FrameLayout;
import android.widget.FrameLayout.LayoutParams;
import android.widget.ImageView;
import android.widget.SectionIndexer;
import android.widget.TextView;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import android.os.Build;


class VideoListAdapter extends CursorAdapter /*implements SectionIndexer*/ {
    int resource;
    //private final LayoutInflater mInflater;
    private static final String TAG = "VideoListAdapter";
    //	 private static final boolean DEBUG = true;
    private static final boolean DEBUG = false;

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        }
    }

    private RockVideoPlayer mActivity = null;
    private final LayoutInflater mInflater;
    private Handler mUiThreadHandler;
    private RefreshUiRunnable mRefreshUi = new RefreshUiRunnable();
    private Handler mDecodeThumbHandler;
    private HandlerThread mDecodeThumbThread;
    private LruCache<String, Thumbnail> mCache = new LruCache<String, Thumbnail>(100);
    private static Bitmap mDefCapture = null;
    private static int mThumbnailWidth = 0;
    private static int mThumbnailHeight = 0;

	/* */

    /**
     * @see AlphabetIndexer.
     *//*
     private AlphabetIndexer mIndexer;
	 //private AsyncQueryHandler mQueryHandler;
	 private int id;
	 int nameIdx;
	 Uri    uriIdx;
	 int    idIdx;
	// int mimetypeIdx;
	// int    bookmarkIdx;
	// int    durationIdx;
	// int sizeIdx;
	// int pahtIdx;
	// private String mConstraint = null;
	// private boolean mConstraintIsValid = false;
	// private Context mContext;
	// private Uri selecturi = null;
	// private SurfaceHolder videoHolder = null;
	 //private int surfacewidth = -1;
	// private int surfaceheight = -1;
	// private int surfacewidthselect = -1;
	// private int surfaceheightselect = -1;
*/
    private class Thumbnail {
        Bitmap mBitmap;

        public Thumbnail(Bitmap bitmap) {
            this.mBitmap = bitmap;

        }
    }

    /**
     * @param path
     */
	/*package*/
    public void setCacheItemInvalid(String path) {

        Thumbnail thumb = mCache.get(path);
        LOG("setcacheItemInvalid thumb" + (thumb == null));
        if (thumb != null) {
            // thumb.needUpdate = true;
        }
    }

    /*package*/
    public void cleanCache() {
        LOG("<--------------cleanCache---------->");
        mCache.clear();
    }

    private List<Long> decodeIdList = new ArrayList<Long>();

    public VideoListAdapter(RockVideoPlayer context, Cursor cursor, boolean autoQuery) {
        super(context, cursor, false);
        mActivity = context;
        //getColumnIndices(cursor);
        //  mQueryHandler = new QueryHandler(context.getContentResolver());     /* ����ת��. */
        mInflater = LayoutInflater.from(context);
        //LOG("Built mQueryHandler = " + mQueryHandler);
        mFormatBuilder = new StringBuilder();
        mFormatter = new Formatter(mFormatBuilder, Locale.getDefault());
        Resources mResources = context.getResources();
        mDefCapture = BitmapFactory.decodeResource(mResources, R.drawable.app_icon);
        mThumbnailWidth = (int) mResources.getDimension(R.dimen.surfacewidth);
        mThumbnailHeight = (int) mResources.getDimension(R.dimen.surfaceheight);
		/*surfacewidthselect = (int) mResources.getDimension(R.dimen.surfacewidthselect);
		surfaceheightselect = (int) mResources.getDimension(R.dimen.surfaceheightselect);*/
        mUiThreadHandler = new Handler();
        LOG("start the decode_thread");

        decodeIdList.clear();
        decodeThumbThreadClear();
        mDecodeThumbThread = new HandlerThread("decode_thread", Process.THREAD_PRIORITY_LOWEST);
        mDecodeThumbThread.start();
        mDecodeThumbHandler = new Handler(mDecodeThumbThread.getLooper());
        //LOG(" ---> VideoAdapter(),  surfacewidth = " + surfacewidth + "  surfaceheight = " + surfaceheight + "  surfacewidthselect = " + surfacewidthselect + "  surfaceheightselect = " + surfaceheightselect);
		/*mThread.start();
		while(mUpdataBitmapHandler == null){
			
		}*/
    }

    public void decodeThumbThreadClear() {
        if (mDecodeThumbThread != null) {
            mDecodeThumbThread.getLooper().quit();
        }
    }

    class ViewHolder {
        ImageView video_icon;
        TextView video_name;
        TextView video_time;
        TextView video_type;
        TextView video_size;
        TextView video_path;
    }
    /**
     * ���Ƶ� AsyncQueryHandler ����.
     * @see AsyncQueryHandler.
     * *//*
	class QueryHandler extends AsyncQueryHandler {
		  *//** Ctor. *//*
	    QueryHandler(ContentResolver res) {
	        super(res);
	    }
		  @Override
	    protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
			//LOG("@@@ query complete: " + cursor.getCount() + "   ");
	         ��ʼ�� ��ǰ activity. 
			  mActivity.initVideoCursor(cursor);
	    }           
	}
    public AsyncQueryHandler getQueryHandler() {
  	  return mQueryHandler;
    }*/

    /**
     * ��ȡָͬ�� Cursor ʵ����ص� �ض��� column �� index, �������� "this"(��ǰ����ʵ��) ��.
     * �������� �����и�.
     */
/*    private void getColumnIndices(Cursor cur) {
    	LOG("Enter getColumnIndices() and cur = " + cur);
    	Uri uri = MediaStore.Video.Media.getContentUri("external");
    	if (cur!= null) {
    		cur.moveToFirst();
    		id = cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID);
    		nameIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media.DISPLAY_NAME);
    		uriIdx = ContentUris.withAppendedId(uri,cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID));
    	    idIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID);
    		mimetypeIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media.MIME_TYPE);
    		bookmarkIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media.BOOKMARK);
    		durationIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media.DURATION);
    		sizeIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media.SIZE);
    		pahtIdx = cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA);   	
    	}
    }*/
    private class RefreshUiRunnable implements Runnable {
        @Override
        public void run() {
            //LOG("<----------------------refreshUiRunnable----------------------- ");
            // TODO Auto-generated method stub
            notifyDataSetChanged();
        }
    }

    private Object mLock = new Object();

    private class DecodeRunnable implements Runnable {
        private String path;
        private long id;
        private int duration;

        public DecodeRunnable(long id, String path, int duration) {
            this.path = path;
            this.id = id;
            this.duration = duration;
        }

        @Override
        public void run() {
            // TODO Auto-generated method stub
            Bitmap mBitmap = null;
            if (ConfigUtil.IS_THUMB_IMAGE_CACHE) {
                if (mImageCacheService == null) {
                    mImageCacheService = new ImageCacheService(mActivity);
                }
                ImageData data = mImageCacheService.getImageData(path,
                        TYPE_THUMBNAIL);
                if (data != null) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                    mBitmap = requestDecode(data.mData, data.mOffset,
                            data.mData.length - data.mOffset, options);
                } else {
                    mBitmap = createVideoThumbnail(path, duration);
                    if (mBitmap != null) {
                        float scaleX = mBitmap.getWidth() / (float) mThumbnailWidth;
                        float scaleY = mBitmap.getHeight() / (float) mThumbnailHeight;
                        float mScale = scaleX > scaleY ? scaleX : scaleY;
                        mBitmap = Bitmap.createScaledBitmap(mBitmap,
                                (int) (mBitmap.getWidth() / mScale), (int) (mBitmap.getHeight() / mScale), false);
                        byte[] array = compressBitmap(mBitmap);
                        mImageCacheService.putImageData(path, TYPE_THUMBNAIL,
                                array);
                    } else {
                        mBitmap = mDefCapture;
                    }
                }
            } else {
                if (decodeIdList.contains(id)) {
                    return;
                }
                decodeIdList.add(id);
                mBitmap = createVideoThumbnail(path, duration);
                if (mBitmap != null) {
                    mBitmap = Bitmap.createScaledBitmap(mBitmap,
                            mThumbnailWidth, mThumbnailHeight, false);
                } else {
                    mBitmap = mDefCapture;
                }
            }

            Thumbnail thumnail = new Thumbnail(mBitmap);
            synchronized (mLock) {
                mCache.put(path, thumnail);
            }
            mUiThreadHandler.removeCallbacks(mRefreshUi);
            mUiThreadHandler.post(mRefreshUi);

        }

    }

    private static byte[] compressBitmap(Bitmap bitmap) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG,
                90, os);
        return os.toByteArray();
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        //LOG("<----------------newView------------->");
        View v = null;
        v = mInflater.inflate(R.layout.video_item_land, null);
        ViewHolder vh = new ViewHolder();
        vh.video_icon = (ImageView) v.findViewById(R.id.video_image);
        vh.video_name = (TextView) v.findViewById(R.id.video_name);
        vh.video_time = (TextView) v.findViewById(R.id.time_info);
        vh.video_type = (TextView) v.findViewById(R.id.type_info);
        vh.video_size = (TextView) v.findViewById(R.id.size_info);
        vh.video_path = (TextView) v.findViewById(R.id.path_info);
        v.setTag(vh);
        return v;
    }


    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ViewHolder vh = (ViewHolder) view.getTag();
        String videoPath = cursor.getString(COL_IND.DATA.getIndex());
        String name = cursor.getString(COL_IND.DISPLAY_NAME.getIndex());
        String time = makeTimeString(cursor.getInt(COL_IND.BOOKMARK.getIndex()), cursor.getInt(COL_IND.DURATION.getIndex()));
        String type = cursor.getString(COL_IND.MIME_TYPE.getIndex());
        String size = makeSizeString(cursor.getLong(COL_IND.SIZE.getIndex()));
        vh.video_name.setText(name);
        if (mActivity.getDisplayMode() == RockVideoPlayer.LIST_MODE) {
            vh.video_time.setText(time);
            vh.video_type.setText(type);
            vh.video_size.setText(size);
            vh.video_path.setText(videoPath);
        }
        vh.video_icon.setImageBitmap(mDefCapture);
        Thumbnail tn = null;
        synchronized (mLock) {
            tn = mCache.get(videoPath);
        }
        if (tn == null) {
            vh.video_icon.setImageBitmap(mDefCapture);
            long orginId = cursor.getLong(COL_IND.ID.getIndex());

            mDecodeThumbHandler.postAtFrontOfQueue(new DecodeRunnable(orginId, videoPath, cursor.getInt(COL_IND.DURATION.getIndex())));
        } else {
            vh.video_icon.setImageBitmap(tn.mBitmap);
        }

    }

    private static Bitmap requestDecode(byte[] bytes, int offset,
                                        int length, Options options) {
        if (options == null) options = new Options();
        return ensureGLCompatibleBitmap(
                BitmapFactory.decodeByteArray(bytes, offset, length, options));
    }

    private static Bitmap ensureGLCompatibleBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.getConfig() != null) return bitmap;
        Bitmap newBitmap = bitmap.copy(Config.ARGB_8888, false);
        bitmap.recycle();
        return newBitmap;
    }

    private ImageCacheService mImageCacheService;
    public static final int TYPE_THUMBNAIL = 1;
    static StringBuilder mFormatBuilder;
    static Formatter mFormatter;

    public String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = (totalSeconds / 60) % 60;
        int hours = totalSeconds / 3600;
        mFormatBuilder.setLength(0);
        if (hours > 0) {
            try {
                return mFormatter.format("%02d:%02d:%02d", hours, minutes, seconds).toString();
            } catch (Exception e) {
                e.printStackTrace();
                return "00:00:00";
            }
        } else {
            try {
                return mFormatter.format("%02d:%02d", minutes, seconds).toString();
            } catch (Exception e) {
                e.printStackTrace();
                return "00:00";
            }
        }
    }

    public String makeTimeString(int time1, int time2) {
        StringBuilder time = new StringBuilder();
        time.append(stringForTime(time1) + '/' + stringForTime(time2));
        return time.toString();
    }

    public String makeSizeString(long size) {
        StringBuilder sizeBuilder = new StringBuilder();
        if (size <= 0) {
            sizeBuilder.append("0 K");
            return sizeBuilder.toString();
        }
        long sizeK = size / 1024;
        long sizeM = sizeK / 1024;
        float sizeG = (float) sizeM / 1024;
        if (0 < sizeK && sizeK < 1024) {
            sizeBuilder.append(sizeK);
            sizeBuilder.append(" K");
            return sizeBuilder.toString();
        } else if (0 < sizeM && sizeM < 1024) {
            sizeBuilder.append(sizeM);
            sizeBuilder.append(" M");
            return sizeBuilder.toString();
        } else {
            sizeBuilder.append(new DecimalFormat("#.##").format(sizeG));
            sizeBuilder.append(" G");
            return sizeBuilder.toString();
        }
    }
	 /*public int getSectionForPosition(int position) {
         return 0;
     }   

	 public int getPositionForSection(int section) {
   	  int pos = mIndexer.getPositionForSection(section);
         return pos;
     }

	public Object[] getSections() {
		if (mIndexer != null) { 
            return mIndexer.getSections();
        } else {
            return null;
        }
	}
	

    public boolean setSelectUri(Uri uri){
    	boolean ret = false;
		LOG(" ----> clearSelectUri() 0 selecturi = " + selecturi);
    	if(!uri.equals(selecturi)){
    		this.selecturi = uri;
    		ret = true;
    	}else{
    		this.selecturi = null;
    	}
		LOG(" ----> clearSelectUri() 1 selecturi = " + selecturi + "   ret = " + ret);
    	return ret;
    }
	public Uri getSelectUri(){
//		LOG(" -> getSelectUri()  selecturi = " + selecturi);
		return this.selecturi;
	}
	public void clearSelectUri(){
		LOG(" ----> clearSelectUri()  selecturi = " + selecturi);
		this.selecturi = null;
		notifyDataSetChanged();
	}
	
	public int getsurfaceheightselect(){
		return this.surfaceheightselect;
	}
	
	public SurfaceHolder getVideoHolder(){
		return videoHolder;
	}	*/
	/*private final static int MAX_BITMAP_CASH = 20;
	private final static int MAX_RECENT_BITMAP_CASH = 16;
	private final static int MAX_MSG = 100;
	private final static int MAX_MSG_NUM = MAX_RECENT_BITMAP_CASH;
	private ArrayList<VideoCapture> mVideoCaptures = new ArrayList<VideoCapture>();
	private ArrayList<VideoCapture> mRecentVideoCaptures = new ArrayList<VideoCapture>();
	private int msgpoint = 1;
	private 
	class VideoCapture{
		Bitmap bitmap;
		int hascode;
		String videopath;
	}
	
	class MsgStruct{
		long id;
		Bitmap bitmap;
		int hascode;
		String videopath;
		boolean direction = true; // true : dowm;  false : up;
	}
	Thread mThread = new Thread(){
		public void run() {
			Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND);
			Looper.prepare();
			mUpdataBitmapHandler = new Handler(){
				public void dispatchMessage(android.os.Message msg) {
					if(false){
						Message tmpmsg = obtainMessage(msg.what, msg.obj);
						sendMessageDelayed(tmpmsg, 10);
					}else{
					if(ConfigUtil.IS_ENABLE_BOOKMARK_CAPTURE){						
						MsgStruct mMsgStruct = (MsgStruct)msg.obj;
						String videoPath = mMsgStruct.videopath;
			        	Bitmap retVal = null;
			        	int msgwhat = 0;
			        	if(new File(ConfigUtil.CAPTURE_DIR + mMsgStruct.hascode + ".jpg").exists()){
			        		try {
			        			retVal = BitmapFactory.decodeFile(ConfigUtil.CAPTURE_DIR + mMsgStruct.hascode + ".jpg");
//								if(retVal.getWidth() != 0 && retVal.getHeight() != 0){
//									retVal.recycle();
//									retVal = null;
//									mMsgStruct.video_icon.setImageURI(Uri.parse(ConfigUtil.CAPTURE_DIR + mMsgStruct.videoPath.hashCode() + ".jpg"));
//									Drawable tmp = mMsgStruct.video_icon.getDrawable();
//									retVal = ((BitmapDrawable)tmp).getBitmap();
//								}
							} catch (Exception e) {
							}
			        	}else{		
			        		mActivity.cancelThumbnailId = mMsgStruct.id;
			        		//retVal = MediaStore.Video.Thumbnails.getThumbnail(mContext.getContentResolver(), mMsgStruct.id,
			                      //  MediaStore.Video.Thumbnails.MICRO_KIND, null);	
			        		mActivity.cancelThumbnailId = Long.MIN_VALUE;
							 if(retVal == null){
							 }else{
//								 mMsgStruct.video_icon.setImageBitmap(retVal);
							 }
			        	}
			        	mMsgStruct.bitmap = retVal;
			        	Message tmpms = mUiHandler.obtainMessage(0, (Object)mMsgStruct);
			        	mUiHandler.sendMessage(tmpms);
			        }
					}
				};
			};
			Looper.loop();
		};
	};
	Handler mUpdataBitmapHandler = null;
	Handler mUiHandler = new Handler(){
		public void dispatchMessage(Message msg) {
			MsgStruct mMsgStruct = (MsgStruct)msg.obj;
        	VideoCapture mVideoCapture = new VideoCapture();
        	mVideoCapture.bitmap = mMsgStruct.bitmap;
        	mVideoCapture.hascode = mMsgStruct.hascode;
        	mVideoCapture.videopath = mMsgStruct.videopath;
        	if(mVideoCaptures.size() > MAX_BITMAP_CASH){
        		if(mMsgStruct.direction){
        			for(int i = 0; i < mVideoCaptures.size(); i ++){
        				if(!mRecentVideoCaptures.contains(mVideoCaptures.get(i))){
                			mVideoCaptures.remove(i);
        					break;
        				}
        			}
//        			mVideoCaptures.remove(0);
        		}
        		else{
        			for(int i = mVideoCaptures.size() - 1; i >= 0; i --){
        				if(!mRecentVideoCaptures.contains(mVideoCaptures.get(i))){
                			mVideoCaptures.remove(i);
        					break;
        				}
        			}
//        			mVideoCaptures.remove(mVideoCaptures.size() - 1);
        		}
        	}
        	if(mMsgStruct.direction){
	        	mVideoCaptures.add(mVideoCapture);
        	}else{
	        	mVideoCaptures.add(0, mVideoCapture);	    
        	}
        	if(mRecentVideoCaptures.size() > MAX_RECENT_BITMAP_CASH){
        		mRecentVideoCaptures.remove(0);
        	}
        	mRecentVideoCaptures.add(mVideoCapture);
        	notifyDataSetChanged();
		};
	};
	
	public void setDeleteVideoPath(String videopath){
		for(VideoCapture tmp : mRecentVideoCaptures){
			if(tmp.hascode == videopath.hashCode()){
				mRecentVideoCaptures.remove(tmp);
				break;
			}
		}
		for(VideoCapture tmp : mVideoCaptures){
			if(tmp.hascode == videopath.hashCode()){
				mVideoCaptures.remove(tmp);
				break;
			}
		}
	}
	
	public void updateBookmarkVideo(ArrayList<String> bookmarkvideo){		
		for(String tmpvideopath : bookmarkvideo){
			for(VideoCapture tmp : mRecentVideoCaptures){
				if(tmp.hascode == tmpvideopath.hashCode()){
					mRecentVideoCaptures.remove(tmp);
					break;
				}
			}
			for(VideoCapture tmp : mVideoCaptures){
				if(tmp.hascode == tmpvideopath.hashCode()){
					mVideoCaptures.remove(tmp);
					break;
				}
			}
		}
	}*/

    public static Bitmap createVideoThumbnail(String filePath, int duration) {
        // MediaMetadataRetriever is available on API Level 8
        // but is hidden until API Level 10
        Log.v(TAG, "---------------------filePath:" + filePath);
        Class<?> clazz = null;
        Object instance = null;
        try {
            clazz = Class.forName("android.media.MediaMetadataRetriever");
            instance = clazz.newInstance();

            Method method = clazz.getMethod("setDataSource", String.class);
            method.invoke(instance, filePath);

            // The method name changes between API Level 9 and 10.
            if (Build.VERSION.SDK_INT <= 9) {
                return (Bitmap) clazz.getMethod("captureFrame").invoke(instance);
            } else {
//                byte[] data = (byte[]) clazz.getMethod("getEmbeddedPicture").invoke(instance);
//                if (data != null) {
//                    Bitmap bitmap = BitmapFactory.decodeByteArray(data, 0, data.length);
//                    if (bitmap != null) return bitmap;
//                }
                Method method1 = clazz.getMethod("getFrameAtTime", long.class);
                long time = (long) (Math.random() * duration) * 1000L + 6000000L;
                if (duration * 1000L < time) {
                    time = duration * 1000L;
                }
                if (time < 0) {
                    time = 0;
                }
                return (Bitmap) method1.invoke(instance, time);
//                return (Bitmap) clazz.getMethod("getFrameAtTime").invoke(instance);
            }
        } catch (IllegalArgumentException ex) {
            // Assume this is a corrupt video file
        } catch (RuntimeException ex) {
            // Assume this is a corrupt video file.
        } catch (InstantiationException e) {
            Log.e(TAG, "createVideoThumbnail", e);
        } catch (InvocationTargetException e) {
            Log.e(TAG, "createVideoThumbnail", e);
        } catch (ClassNotFoundException e) {
            Log.e(TAG, "createVideoThumbnail", e);
        } catch (NoSuchMethodException e) {
            Log.e(TAG, "createVideoThumbnail", e);
        } catch (IllegalAccessException e) {
            Log.e(TAG, "createVideoThumbnail", e);
        } finally {
            try {
                if (instance != null) {
                    clazz.getMethod("release").invoke(instance);
                }
            } catch (Exception ignored) {
            }
        }
        return null;
    }
}

