/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.rk.RockVideoPlayer;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;

public class TopBar extends RelativeLayout {
    //	private final boolean DEBUG = true;
    private final boolean DEBUG = false;
    private final String TAG = "TopBar";

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        } else {
            if (DebugUtil.isDebugFileExist())
                Log.d(TAG, msg);
        }
    }

    private Context mContext;
    private TopBarControl mPlayer;
    private int mChildCnt = 0;
    private boolean mShow;
    final static int BAR_DEFAULT_HEIGHT = 40;
    final static int ICON_DEFAULT_HEIGHT = BAR_DEFAULT_HEIGHT;
    final static int ICON_DEFAULT_WIDTH = 25;
    final static int USR_ALIGN_LEFT = 0;
    final static int USR_ALIGN_RIGHT = 1;
    final static int CHILD_ID_BASE = 2000;
    private final static String TOPBAR_HOME = "home";
    private final static String TOPBAR_RETURN = "return";
    private final static String TOPBAR_VOLUMEPLUS = "volumeplus";
    private final static String TOPBAR_VOLUMEMINUS = "volumeminus";
    private final static String TOPBAR_PRE = "pre";
    private final static String TOPBAR_NEXT = "next";
    private final static String TOPBAR_PAUSE = "pause";
    boolean is_down = false;    //��־�����¼��Ƿ��а��µı�־
    private final int ADJUST_VOLUME_DELAY = 200;
    private final int ADJUST_TIME_DELAY = 300;
    private final int VOLUMEPLUS = 1;
    private final int VOLUMEMINUS = -1;

    public interface TopBarControl {
        void TopBar_next(int count, int delay);

        void TopBar_prev(int count, int delay);

        void TopBar_return();

        void TopBar_home();

        void TopBar_pause();

        void TopBar_volume(int mode);
    }

    public TopBar(Context context) {
        super(context);
        mContext = context;
        initTopBar();
    }

    public TopBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        initTopBar();
    }

    private void initTopBar() {
        this.setBackgroundResource(R.drawable.statusbar_background);
        this.setGravity(Gravity.TOP);
        addChild(TOPBAR_HOME, null, R.drawable.home_btn, 65, 40, USR_ALIGN_LEFT, true, mHomeListener, null);
        addChild(TOPBAR_VOLUMEPLUS, null, R.drawable.add_normal, 65, 40, USR_ALIGN_LEFT, true, null, mVolumePlusTouchListener);
        addChild(TOPBAR_VOLUMEMINUS, null, R.drawable.sub_normal, 65, 40, USR_ALIGN_LEFT, true, null, mVolumeMinusTouchListener);
        addChild(TOPBAR_PRE, null, R.drawable.pre_btn, 65, 40, USR_ALIGN_LEFT, true, null, mPreListener);
        addChild(TOPBAR_PAUSE, null, R.drawable.video_button_play, 65, 40, USR_ALIGN_LEFT, true, mPauseListener, null);
        addChild(TOPBAR_NEXT, null, R.drawable.next_btn, 65, 40, USR_ALIGN_LEFT, true, null, mNextListener);
        addChild(TOPBAR_RETURN, null, R.drawable.back_btn, 65, 40, USR_ALIGN_LEFT, true, mReturnListener, null);
    }

    View.OnClickListener mHomeListener = new View.OnClickListener() {

        public void onClick(View v) {
            mPlayer.TopBar_home();
        }
    };

    View.OnClickListener mPauseListener = new View.OnClickListener() {

        public void onClick(View v) {
            mPlayer.TopBar_pause();
        }
    };

    View.OnClickListener mReturnListener = new View.OnClickListener() {

        public void onClick(View v) {
            mPlayer.TopBar_return();
        }

    };

    View.OnTouchListener mVolumePlusTouchListener = new View.OnTouchListener() {

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                is_down = true;
                mPlayer.TopBar_volume(VOLUMEPLUS);
                getButton(TOPBAR_VOLUMEPLUS).setBackgroundResource(R.drawable.add_pressed);
                maddHandler.postDelayed(maddRun, ADJUST_VOLUME_DELAY);
            } else if (event.getAction() == MotionEvent.ACTION_UP) {
                is_down = false;
                maddHandler.removeCallbacks(maddRun);
                getButton(TOPBAR_VOLUMEPLUS).setBackgroundResource(R.drawable.add_normal);
            }
            return true;
        }

    };

    private Handler maddHandler = new Handler();
    private Runnable maddRun = new Runnable() {
        public void run() {
            maddHandler.removeCallbacks(maddRun);
            if (is_down) {
                mPlayer.TopBar_volume(VOLUMEPLUS);
                maddHandler.postDelayed(maddRun, ADJUST_VOLUME_DELAY);
            }
        }
    };

    View.OnTouchListener mVolumeMinusTouchListener = new View.OnTouchListener() {

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                is_down = true;
                mPlayer.TopBar_volume(VOLUMEMINUS);
                getButton(TOPBAR_VOLUMEMINUS).setBackgroundResource(R.drawable.sub_pressed);

            } else if (event.getAction() == MotionEvent.ACTION_UP) {
                is_down = false;
                msubHandler.removeCallbacks(msubRun);
                getButton(TOPBAR_VOLUMEMINUS).setBackgroundResource(R.drawable.sub_normal);
            }
            return true;
        }

    };

    private Handler msubHandler = new Handler();
    private Runnable msubRun = new Runnable() {
        public void run() {
            msubHandler.removeCallbacks(msubRun);
            if (is_down) {
                mPlayer.TopBar_volume(VOLUMEMINUS);
                msubHandler.postDelayed(msubRun, ADJUST_VOLUME_DELAY);
            }
        }
    };

    View.OnTouchListener mPreListener = new View.OnTouchListener() {

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                is_down = true;
                mPlayer.TopBar_prev(1, ADJUST_TIME_DELAY);
                mpreHandler.postDelayed(mpreRun, ADJUST_TIME_DELAY);
            } else if (event.getAction() == MotionEvent.ACTION_UP) {
                is_down = false;
                mpreHandler.removeCallbacks(mpreRun);
            }
            return true;
        }
    };

    private Handler mpreHandler = new Handler();
    private Runnable mpreRun = new Runnable() {
        int count = 1;

        public void run() {
            count++;
            mpreHandler.removeCallbacks(mpreRun);
            if (is_down) {
                mPlayer.TopBar_prev(count, count * ADJUST_TIME_DELAY);
                mpreHandler.postDelayed(mpreRun, ADJUST_TIME_DELAY);
            }
        }
    };

    View.OnTouchListener mNextListener = new View.OnTouchListener() {
        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                is_down = true;
                mPlayer.TopBar_next(1, ADJUST_TIME_DELAY);
                mnextHandler.postDelayed(mnextRun, ADJUST_TIME_DELAY);
            } else if (event.getAction() == MotionEvent.ACTION_UP) {
                is_down = false;
                mnextHandler.removeCallbacks(mnextRun);
            }
            return true;
        }
    };

    private Handler mnextHandler = new Handler();
    private Runnable mnextRun = new Runnable() {
        int count = 1;

        public void run() {
            count++;
            mnextHandler.removeCallbacks(mnextRun);
            if (is_down) {
                mPlayer.TopBar_next(count, count * ADJUST_TIME_DELAY);
                mnextHandler.postDelayed(mnextRun, ADJUST_TIME_DELAY);
            }
        }
    };

    static class TopBarButton extends Button {
        public int mAlign;
        public String mName;
        public boolean enable;

        public TopBarButton(Context context, int align, String name) {
            super(context);
            mAlign = align;
            mName = new String(name);
            enable = true;
        }
    }

    public int addChild(String name, CharSequence text, int iconid, int width, int height, int align, boolean clickable, View.OnClickListener l, View.OnTouchListener n) {
        int id = mChildCnt;
        int relativeviewid = -1;
        while (id > 0 && mChildCnt > 0) {
            TopBarButton child = (TopBarButton) getChildAt(id - 1);
            if (child.mAlign == align && child.getId() > relativeviewid)
                relativeviewid = child.getId();
            id--;
        }
        TopBarButton child = new TopBarButton(getContext(), align, name);
        width = width == 0 ? ICON_DEFAULT_WIDTH : width;
        height = height == 0 ? ICON_DEFAULT_HEIGHT : height;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                width,
                height);
        if (relativeviewid == -1) {
            if (align == USR_ALIGN_LEFT)
                params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
            else
                params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        } else {
            if (align == USR_ALIGN_LEFT)
                params.addRule(RelativeLayout.RIGHT_OF, relativeviewid);
            else
                params.addRule(RelativeLayout.LEFT_OF, relativeviewid);
        }
        params.addRule(RelativeLayout.CENTER_VERTICAL);
        child.setGravity(Gravity.CENTER_VERTICAL);
        child.setLayoutParams(params);
        child.setBackgroundResource(iconid);
        child.setText(text);
        child.setClickable(clickable);
        if (clickable) child.setOnClickListener(l);
        if (clickable) child.setOnTouchListener(n);
        id = mChildCnt++;
        child.setId(id + CHILD_ID_BASE);
        addView(child);
        return id + CHILD_ID_BASE;
    }

    public int removeChild(int id) {
        int index = 0;
        TopBarButton child;
        int align = -1;
        while (index++ < mChildCnt) {
            child = (TopBarButton) getChildAt(index - 1);
            if (child.getId() == id) {
                align = child.mAlign;
                removeView(child);
                break;
            }
        }
        index = --mChildCnt;
        while (index-- >= 0) {
            child = (TopBarButton) getChildAt(index);
            if (child == null) break;
            int tmpid = child.getId();
            if (tmpid > id)
                child.setId(tmpid - 1);
        }
        logChildId();
        for (index = 1; index <= mChildCnt; index++) {
            child = (TopBarButton) getChildAt(index - 1);
            align = child.mAlign;
            int relativeviewid = getRelativeViewId(child.getId(), align);
            int width = child.getLayoutParams().width;
            int height = child.getLayoutParams().height;
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                    width,
                    height);
            if (relativeviewid == -1) {
                if (align == USR_ALIGN_LEFT)
                    params.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                else
                    params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
            } else {
                if (align == USR_ALIGN_LEFT)
                    params.addRule(RelativeLayout.RIGHT_OF, relativeviewid);
                else
                    params.addRule(RelativeLayout.LEFT_OF, relativeviewid);
            }
            LOG(child.mName + "    id = " + child.getId() + "    align=" + child.mAlign + "    relid = " + relativeviewid);
            params.addRule(RelativeLayout.CENTER_VERTICAL);
            child.setLayoutParams(params);
        }
        return id;
    }

    public void removeChildByName(String name) {
        TopBarButton child = getButton(name);
        if (child != null)
            removeChild(child.getId());
    }

    public TopBarButton getButton(String name) {
        TopBarButton button = null;
        int index = 0;
        do {
            button = (TopBarButton) (getChildAt(index++));
            if (button == null)
                break;
            if (button.mName.equals(name))
                break;

        } while (true);
        return button;
    }

    static boolean LOG_LOCAL_SWITCH = false;

    private void logChildId() {
        TopBarButton child;
        if (!LOG_LOCAL_SWITCH)
            return;
        for (int index = 0; ; index++) {
            child = (TopBarButton) getChildAt(index);
            if (child == null)
                break;
            LOG("child id = " + child.getId() + "    align = " + child.mAlign);
        }
        LOG("log end");
    }

    private int getRelativeViewId(int id, int align) {
        TopBarButton child;
        int index = 0;
        int ret = -1;
        for (; index < id - CHILD_ID_BASE; index++) {
            child = (TopBarButton) getChildAt(index);
            if (child.mAlign == align) {
                ret = child.getId();
                //break;
            }
        }
        return ret;
    }

    public void setTopBarPlayer(TopBarControl player) {
        mPlayer = player;
        LOG(">>>>>>>>>>>>>>>>>>>> TopControl  player= <<<<<<<<<<<<<<" + mPlayer);
    }

    public boolean isShowing() {
        return mShow;
    }

    public void show() {
        this.setVisibility(View.VISIBLE);
        mShow = true;
    }

    public void hide() {
        this.setVisibility(View.INVISIBLE);
        mShow = false;
    }
}
