/**
 *
 */
package android.rk.RockVideoPlayer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import android.rk.RockVideoPlayer.subTitle.AliasUtil;
import android.rk.RockVideoPlayer.subTitle.AssDecoder;
import android.rk.RockVideoPlayer.subTitle.SmiDecoder;
import android.rk.RockVideoPlayer.subTitle.SrtDecoder;
import android.rk.RockVideoPlayer.subTitle.SubDecoder;
import android.rk.RockVideoPlayer.subTitle.SubTitleContent;
import android.rk.RockVideoPlayer.subTitle.autodetect.AutoDetectUtil;
import android.util.Log;

/**
 * @author hm
 */
@DebugAnno(isEnableDebug = false)
public class SubContentUtil {
    public static enum SubTitleType {
        srt,
        smi,
        ass,
        ssa,
        sub
    }

    ;
    //	public final static String[] SUBTITLETYPESTR = new String[]{".srt", ".smi", ".ass", ".ssa", ".idx"};
    public final static String[] SUBTITLETYPESTR = new String[]{".srt", ".smi", ".ass", ".ssa"};
    public static int lastSubtitleIndex = -1;
    public static boolean stopDecodeFlag = false;

    public static String removeHtmlTag(String input) {
        String str = input.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        str = str.replaceAll("[(/>)<]", "");
        return str;
    }

    public static String getSubTitleFile(Context context, Uri uri) {
        String scheme = uri.getScheme();

        Log.v("+++", "*****************scheme=" + scheme);
        String videoFullPath = null;
        if ("content".equals(scheme)) {
            Cursor cur = DBUtils.getCurrentCursor(context, uri);
            if (cur == null)
                return null;
            videoFullPath = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
            cur.close();
        } else if ("file".equals(scheme)) {
            videoFullPath = uri.getPath();
        } else if ("http".equals(scheme)) {
            return null;
        }

        if (videoFullPath == null)
            return null;

        int lastDotPos = videoFullPath.lastIndexOf(".");
        if (lastDotPos == -1) {
            lastDotPos = videoFullPath.length();
        }
        String videoPathPrefix = videoFullPath.substring(0, lastDotPos);
        String subTitlePath = null;
        File subTitleFile = null;
        for (String suffix : SUBTITLETYPESTR) {
            subTitlePath = videoPathPrefix + suffix;
            subTitleFile = new File(subTitlePath);
            if (subTitleFile.exists() && subTitleFile.isFile() && subTitleFile.canRead()) {
                LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>get subtitle path:" + subTitlePath);
                return subTitlePath;
            }
        }

        return null;
    }

    public static Map<String, List<SubTitleContent>> decodeSubtitle(String subTitlePath) {
        LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>decodeSubtitle:" + subTitlePath);
        if (subTitlePath.toLowerCase().endsWith(".srt")) {
            LogUtil.LOG("++++++++++++++++++++++++++++srt file");
            try {
                return new SrtDecoder().decodeSubTitle(subTitlePath, null);
            } catch (Exception e) {
                try {
                    return new SrtDecoder().decodeSubTitle(subTitlePath, "ISO-8859-1");
                } catch (Exception e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        } else if (subTitlePath.toLowerCase().endsWith(".ass") || subTitlePath.toLowerCase().endsWith(".ssa")) {
            LogUtil.LOG("++++++++++++++++++++++++++++ass/ssa file");
            try {
                return new AssDecoder().decodeSubTitle(subTitlePath, null);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        } else if (subTitlePath.toLowerCase().endsWith(".smi")) {
            LogUtil.LOG("++++++++++++++++++++++++++++smi file");
            try {
                return new SmiDecoder().decodeSubTitle(subTitlePath, null);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        } else if (subTitlePath.toLowerCase().endsWith(".idx")) {
            LogUtil.LOG("++++++++++++++++++++++++++++idx file");
            try {
                return new SubDecoder().decodeSubTitle(subTitlePath, null);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        return null;
    }

    public synchronized static SubTitleContent getCurrentSubTitle(int pos, final Map<String, List<SubTitleContent>> subtitleList) {
        LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>begin getCurrentSubTitle, pos:" + pos);
        StringBuffer sb = null;
        Iterator<String> keyIt = subtitleList.keySet().iterator();
        String keyStr = null;
        List<SubTitleContent> contentList = null;
        SubTitleContent tmpcontent = null;
        SubTitleContent content = null;
        int searchIndex = 0;
        int searchStartIndex = 0;
        int searchEndIndex = 0;
        int loopCount = -1;

        while (keyIt.hasNext()) {
            loopCount++;
            tmpcontent = null;
            keyStr = keyIt.next();
            contentList = subtitleList.get(keyStr);
//			Log.v("+++", "++++++++++++++++++++let me search :" + keyStr);
            if (contentList == null || contentList.size() == 0) {
                continue;
            }

            if (sb != null && loopCount != 0) {
//				sb.append("\n");
                lastSubtitleIndex = -1;

                searchIndex = 0;
                searchStartIndex = 0;
                searchEndIndex = 0;
            }

            //1.use last index to search
            try {
                tmpcontent = contentList.get(lastSubtitleIndex + 1);
//				Log.v("+++", "++++++++++++++++++++++++++++++++contentList[" + (lastSubtitleIndex + 1) + "]:" + tmpcontent.getmSubTitleLine());
            } catch (Exception e) {
                // TODO Auto-generated catch block
                tmpcontent = contentList.get(0);
//				Log.v("+++", "++++++++++++++++++++++++++++++++content:" + tmpcontent.getmSubTitleLine());
            }

            int guessStarttime = tmpcontent.getmSubTitleStartTime();
            int guessEndtime = tmpcontent.getmSubTitleEndTime();

//			Log.v("+++", ")))))))))))))))))))guessStarttime:" + guessStarttime + " guessEndtime:" + guessEndtime);

            if (pos >= guessStarttime && pos <= guessEndtime) {
                if (sb == null)
                    sb = new StringBuffer("");
                else
                    sb.append("<br>");
                LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>append once1 index:" + (lastSubtitleIndex + 1) + " pos:" + pos + " start:" + tmpcontent.getmSubTitleStartTime() + " end:" + tmpcontent.getmSubTitleEndTime());
                if (tmpcontent.getmSubTitleLine() == null) {
                    tmpcontent.setmSubTitleBmp(BitmapFactory.decodeFile("/flash/" + tmpcontent.hashCode() + ".png"));
                } else {
                    sb.append(tmpcontent.getmSubTitleLine());
                }

                content = tmpcontent.getSimpleCopy();
                lastSubtitleIndex++;
                int tryCount = 1;
                int lastIndex = 0;
                //scan forward
                while (true) {
                    try {
                        tmpcontent = contentList.get(lastSubtitleIndex - tryCount);
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        break;
                    }
                    LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>search forward searchIndex=" + (lastSubtitleIndex - tryCount) + " pos=" + pos + " start=" + tmpcontent.getmSubTitleStartTime() + " end=" + tmpcontent.getmSubTitleEndTime());
                    if (tmpcontent.getmSubTitleStartTime() <= pos && tmpcontent.getmSubTitleEndTime() >= pos) {
//						Log.v("+++", "Append :" + tmpcontent.getmSubTitleLine());
                        sb.insert(0, tmpcontent.getmSubTitleLine() + "<br>");
//						sb.append("<br>" + tmpcontent.getmSubTitleLine());
                    }

                    tryCount++;
                }

                lastIndex = lastSubtitleIndex;
                lastSubtitleIndex = lastSubtitleIndex - tryCount + 1;

                tryCount = 1;
                //scan backward
                while (true) {
                    try {
                        tmpcontent = contentList.get(lastIndex + tryCount);
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        break;
                    }
                    LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>search next searchIndex=" + (lastSubtitleIndex + tryCount) + " pos=" + pos + " start=" + tmpcontent.getmSubTitleStartTime() + " end=" + tmpcontent.getmSubTitleEndTime());
                    if (tmpcontent.getmSubTitleStartTime() <= pos && tmpcontent.getmSubTitleEndTime() >= pos) {
//						Log.v("+++", "Append :" + tmpcontent.getmSubTitleLine());
                        sb.append("<br>" + tmpcontent.getmSubTitleLine());
                    } else if (pos < tmpcontent.getmSubTitleStartTime()) {
                        break;
                    }

                    tryCount++;
                }

                lastSubtitleIndex = lastIndex + tryCount - 1;
                continue;
            }//2.guess fail
            else {
                searchStartIndex = 0;
                searchEndIndex = contentList.size() - 1;
                while (true) {
                    searchIndex = (searchStartIndex + searchEndIndex) / 2;
//					Log.v("+++", ">>>>>>>>>>>>>>>>>>>>searchIndex:" + searchIndex + " searchStartIndex:" + searchStartIndex + " searchEndIndex:" + searchEndIndex);
                    if (searchEndIndex - searchStartIndex == 1) {
                        if (contentList.get(searchStartIndex).getmSubTitleStartTime() <= pos && contentList.get(searchStartIndex).getmSubTitleEndTime() >= pos)
                            searchIndex = searchStartIndex;
                        else if (contentList.get(searchEndIndex).getmSubTitleStartTime() <= pos && contentList.get(searchEndIndex).getmSubTitleEndTime() >= pos)
                            searchIndex = searchEndIndex;
                        else
                            break;
                    } else if (searchIndex == 0 && searchStartIndex == 0 && searchEndIndex == 0) {
                        if (contentList.get(0).getmSubTitleStartTime() <= pos && contentList.get(0).getmSubTitleEndTime() >= pos)
                            searchIndex = 0;
                        else
                            break;
                    }

                    tmpcontent = null;
                    try {
                        tmpcontent = contentList.get(searchIndex);
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        tmpcontent = null;
                        break;
                    }
//					if(contentList.get(searchStartIndex).getmSubTitleEndTime() < pos && contentList.get(searchEndIndex).getmSubTitleStartTime() > pos && (searchStartIndex - searchEndIndex) == 1)
//						break;

                    if (tmpcontent.getmSubTitleEndTime() < pos) {
                        searchStartIndex = searchIndex;
                        continue;
                    } else if (tmpcontent.getmSubTitleStartTime() > pos) {
                        searchEndIndex = searchIndex;
                        continue;
                    } else if (tmpcontent.getmSubTitleStartTime() <= pos && tmpcontent.getmSubTitleEndTime() >= pos) {
                        if (sb == null)
                            sb = new StringBuffer("");
                        else
                            sb.append("<br>");
                        LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>append once2 index:" + searchIndex + " pos:" + pos + " start:" + tmpcontent.getmSubTitleStartTime() + " end:" + tmpcontent.getmSubTitleEndTime());
//						sb.append(content.getmSubTitleLine());
                        if (tmpcontent.getmSubTitleLine() == null) {
                            tmpcontent.setmSubTitleBmp(BitmapFactory.decodeFile("/flash/" + tmpcontent.hashCode() + ".png"));
                        } else {
                            sb.append(tmpcontent.getmSubTitleLine());
                        }

                        content = tmpcontent.getSimpleCopy();
                        int tryCount = 1;
                        int lastIndex = 0;
                        //scan forward
                        while (true) {
                            try {
                                tmpcontent = contentList.get(searchIndex - tryCount);
                            } catch (Exception e) {
                                // TODO Auto-generated catch block
                                break;
                            }
                            LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>search pre searchIndex=" + (searchIndex - tryCount) + " pos=" + pos + " start=" + tmpcontent.getmSubTitleStartTime() + " end=" + tmpcontent.getmSubTitleEndTime());
                            if (tmpcontent.getmSubTitleStartTime() <= pos && tmpcontent.getmSubTitleEndTime() >= pos) {
//								Log.v("+++", "Append :" + tmpcontent.getmSubTitleLine());
                                sb.insert(0, tmpcontent.getmSubTitleLine() + "<br>");
//								sb.append("<br>" + tmpcontent.getmSubTitleLine());
                            }

                            tryCount++;
                        }

                        lastSubtitleIndex = searchIndex - tryCount + 1;

                        tryCount = 1;
                        //scan backward
                        while (true) {
                            try {
                                tmpcontent = contentList.get(searchIndex + tryCount);
                            } catch (Exception e) {
                                // TODO Auto-generated catch block
                                break;
                            }
                            LogUtil.LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>search next2 searchIndex=" + (searchIndex + tryCount) + " pos=" + pos + " start=" + tmpcontent.getmSubTitleStartTime() + " end=" + tmpcontent.getmSubTitleEndTime());
                            if (tmpcontent.getmSubTitleStartTime() <= pos && tmpcontent.getmSubTitleEndTime() >= pos) {
//								Log.v("+++", "Append :" + tmpcontent.getmSubTitleLine());
                                sb.append("<br>" + tmpcontent.getmSubTitleLine());
                            } else if (pos < tmpcontent.getmSubTitleStartTime()) {
                                break;
                            }

                            tryCount++;
                        }

                        lastSubtitleIndex = searchIndex + tryCount - 1;
                        break;
                    }
                }
            }
        }

//		Log.v("+++", ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>end getCurrentSubTitle:sb=" + sb);
        if (sb != null) {
            content.setmSubTitleLine(sb.toString());
            return content;
        } else
            return null;
    }

    public static String encodeType = null;

    /**
     * detect encode type
     *
     * @param subTitlePath
     * @return InputStreamReader with encode deal
     * @throws FileNotFoundException
     * @throws UnsupportedEncodingException
     */
    public static BufferedReader getEncodeType(String subTitlePath) throws FileNotFoundException, UnsupportedEncodingException {
        InputStream encodeinput = new FileInputStream(subTitlePath);
        BufferedInputStream encodebin = new BufferedInputStream(encodeinput);
        encodeType = AutoDetectUtil.detectEncode(6, encodebin);

        try {
            encodebin.close();
            encodebin = null;
        } catch (Exception e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }

        //It seems unecessary
        try {
            encodeinput.close();
            encodeinput = null;
        } catch (Exception e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }

        InputStream in = new FileInputStream(subTitlePath);
        BufferedInputStream bin = new BufferedInputStream(in);
        Log.v("+++", ">>>>>>>>>>>>>>>>>>>>>>>encodeType: " + encodeType);
        InputStreamReader isr = null;

        if (encodeType != null && !"ascii".equals(encodeType)) {
            if (subTitlePath.endsWith("srt") && encodeType.equals("windows-1252")) {
                encodeType = "Unicode";
            }
            if (subTitlePath.endsWith("smi") && encodeType.equals("windows-1252")) {
                encodeType = "GB2312";
            } else {
                encodeType = AliasUtil.getAlias(encodeType);
            }

            if ("nomatch".equals(encodeType) || "Shift_JIS".equals(encodeType)) {
//			if("nomatch".equals(encodeType)){
                encodeType = "windows-1253";
            } else if ("Shift_JIS".equals(encodeType)) {
                encodeType = "Cp1256";
            }

            Log.v("+++", ">>>>>>>>>>>>>>>>>>>>>>>encodeType: " + encodeType);
            isr = new InputStreamReader(bin, encodeType);
        } else {
            isr = new InputStreamReader(bin);
        }

        BufferedReader br = new BufferedReader(isr);
        return br;
    }

    public static BufferedReader getEncodeType(String subTitlePath, String encodeType) throws FileNotFoundException, UnsupportedEncodingException {
        InputStream in = new FileInputStream(subTitlePath);
        BufferedInputStream bin = new BufferedInputStream(in);
        InputStreamReader isr = null;

        if (encodeType != null && !"ascii".equals(encodeType)) {
            isr = new InputStreamReader(bin, encodeType);
        } else {
            isr = new InputStreamReader(bin);
        }

        BufferedReader br = new BufferedReader(isr);
        return br;
    }

    public static void SortAllList(Map<String, List<SubTitleContent>> subTitleMap) {
        Set<String> keySet = subTitleMap.keySet();
        Iterator<String> keyIt = keySet.iterator();

        String key = null;
        List<SubTitleContent> subTitleList = null;
        while (keyIt.hasNext()) {
            key = keyIt.next();
            subTitleList = subTitleMap.get(key);

            Collections.sort(subTitleList);
        }
    }
}
