/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.rk.RockVideoPlayer;

import java.io.File;
import java.util.ArrayList;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.media.AudioManager;
import android.net.Uri;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.MediaStore;
import android.provider.Settings;
import android.provider.Settings.SettingNotFoundException;
import android.util.Log;
import android.widget.Toast;
import android.app.ActivityManager;
import android.app.ActivityManager.RunningServiceInfo;

public class DBUtils {
    private static final String TAG = "DBUtils";
    private static final String PREFS_NAME = "android.rk.RockVideoPlayer";
    //	public static boolean DEBUG = true;
    public static boolean DEBUG = false;

    public static void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        } else {
            if (DebugUtil.isDebugFileExist())
                Log.d(TAG, msg);
        }
    }

    public static String[] mCols = new String[]{
            MediaStore.Video.Media.DISPLAY_NAME,
            MediaStore.Video.Media.DURATION,
            MediaStore.Video.Media.MIME_TYPE,
            MediaStore.Video.Media.SIZE,
            MediaStore.Video.Media._ID,
            MediaStore.Video.Media.DATA,
            MediaStore.Video.Media.BOOKMARK
    };

    public static ContentResolver getResolver(Context context) {
        return context.getContentResolver();
    }

    public static long getVideoIdByUri(Context context, Uri mUri) {
        Cursor cur = getResolver(context).query(mUri, mCols, null, null, null);
        if (cur != null && cur.getCount() >= 0) {
            cur.moveToFirst();
            long video_id = cur.getLong(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID));
            return video_id;
        }
        return Long.MIN_VALUE;
    }

    public static Uri getTrueUri(Context context, Uri mUri) {
        LOG("Enter getTrueUri() mUri.getPath():" + mUri.getPath());
        if (mUri == null || mUri.getPath() == null) {
            return mUri;
        }
        if (mUri.toString().startsWith("file://")) {
            Uri uri = MediaStore.Video.Media.getContentUri("external");
            Cursor cur = getResolver(context).query(uri, mCols, null, null, null);
            String path = mUri.getPath();
            if (cur == null) {
                return mUri;
            }
            if (cur.moveToFirst()) {
                while (!cur.isAfterLast()) {
                    if (cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA)).equals(path)) {
                        Uri result = ContentUris.withAppendedId(uri, cur.getInt(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID)));
                        cur.close();
                        cur = null;
                        return result;
                    } else {
                        cur.moveToNext();
                    }
                }
            }
            if (cur != null) {
                cur.close();
                cur = null;
            }
        }
        return mUri;
    }

    /*********************************************************
     * ��ȡָ��URI��ý����е�cursor
     * @param context, �����Ļ���
     * @param currenturi,�����URI
     * @return
     **********************************************************/
    public static Cursor getCurrentCursor(Context context, Uri currenturi) {
        LOG("Enter getCurrentCursor() currenturi:" + currenturi.toString());
        Uri uri = MediaStore.Video.Media.getContentUri("external");
        LOG("Enter getCurrentCursor() uri:" + uri.toString());
        Cursor cur = getResolver(context).query(uri, mCols, null, null, null);
        LOG("Enter getCurrentCursor() cur:" + cur);

        if (cur != null) {
//			if(currenturi.toString().startsWith("file://")){
//				String path = currenturi.getPath();
//				if(cur.moveToFirst()){
//					while(!cur.isAfterLast()){
//						if(cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA)).equals(path)){
//							return cur;
//						}else{ 
//							cur.moveToNext();
//						}
//					}
//				  }
//			}else{
            if (cur.moveToFirst()) {
                while (!cur.isAfterLast()) {
                    if (currenturi.equals(ContentUris.withAppendedId(uri, cur.getInt(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID))))) {
                        return cur;
                    } else {
                        cur.moveToNext();
                    }
                }
            }
//			}
        }
        if (cur != null) {
            cur.close();
            cur = null;
        }
        return null;
    }

    /*************************************
     * ����ָ��λ�õ�URI��Ӧ��cursor
     * @param context,�����Ļ���
     * @param position,uri���б��е�λ��
     * @return :���ص�ǰURI��ý����е�cursor
     * ***********************************/
    public static Cursor getCurrentCursor(Context context, int position) {
        Cursor cur = null;
        ContentResolver resolver = context.getContentResolver();
        Uri uri = MediaStore.Video.Media.getContentUri("external");
        cur = resolver.query(uri, mCols, null, null, null);
        if (cur == null) {
            return null;
        }
        if (cur.moveToFirst()) {
            while (!cur.isAfterLast()) {
                cur.moveToPosition(position + 1);
            }
        }
        return cur;
    }

    /*************************************
     * ��ȡ��ǰuri����һ��cursor
     * @param context,�����Ļ���
     * @param currenturi,���uri
     * @return :���ص�Ȼuri��Ӧ��cursor����һ��cursor
     * ***********************************/
    public static Cursor getNextCursor(Context context, Uri currenturi) {
        LOG("Enter getNextCursor()");
        Cursor cur = getCurrentCursor(context, currenturi);
        LOG("Current cur = " + cur);
        if (cur == null)
            return null;
        else {
            if (cur.isLast()) {
                cur.moveToFirst();
                return cur;
            } else {
                cur.moveToNext();
                return cur;
            }
        }
    }

    /*************************************
     * ��ȡ��ǰuri����һ��curosr
     * @param context,�����Ļ���
     * @param currenturi,���uri
     * @return :���ص�Ȼuri��Ӧ��cursor����һ��cursor
     * ***********************************/
    public static Cursor getPrevCursor(Context context, Uri currenturi) {
        LOG("Enter getPrevCursor()");
        Cursor cur = getCurrentCursor(context, currenturi);
        LOG("Current cur = " + cur);
        if (cur == null)
            return null;
        else {
            if (cur.isFirst()) {
                cur.moveToLast();
                return cur;
            } else {
                cur.moveToPrevious();
                return cur;
            }
        }
    }

    /*************************************
     * ������ǩ
     * @param context,�����Ļ���
     * @param cur,ý����cursor
     * @param bookmark,ҩ���õ���ǩ��ʱ��ֵ��
     * @return :true�����óɹ�������ʧ��
     * ***********************************/
    public static boolean setBookmark(Context context, Cursor cur, int bookmark) {
        if (cur != null) {
            Uri uri = MediaStore.Video.Media.getContentUri("external");
            Uri videouri = ContentUris.withAppendedId(uri, cur.getInt(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID)));
            LOG("videouri = " + videouri);
            ContentValues value = new ContentValues();
            value.put(MediaStore.Video.Media.BOOKMARK, bookmark);
            LOG("value = " + value);
            context.getContentResolver().update(videouri, value, null, null);
            LOG(getResolver(context).update(videouri, value, null, null) + "rows changed");
            cur.close();
            return true;
        }
        return false;
    }

    /*************************************
     * �鿴�ļ��Ƿ����
     * @param context,�����Ļ���
     * @param cur,���cursor
     * @return :true���ļ����ڣ������ļ�������
     * ***********************************/
    public static boolean checkVideoAvailable(Context context, Cursor cur) {
        //Uri uri = MediaStore.Video.Media.getContentUri("external");
        //Uri videouri =ContentUris.withAppendedId(uri,cur.getInt(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID)));
        String videofile = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
        LOG("videofile = " + videofile);
        File file = new File(videofile);
        if (file.exists()) {
            cur.close();
            return true;
        } else {
            cur.close();
            return false;
        }
    }

    public static boolean checkVideoAvailable(Context context, String videofile) {
        LOG("videofile = " + videofile);
        File file = new File(videofile);
        if (file.exists()) {
            return true;
        } else {
            return false;
        }
    }

    /*************************************
     * �鿴��ǰURIʱ��֧����ǩ
     * @param uri,��Ƶ��Uri
     * @return : true��֧����ǩ������֧��
     * ***********************************/
    private static boolean uriSupportsBookmarks(Uri uri) {
        LOG("Enter uriSupportsBookmarks()");
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        LOG("scheme = " + scheme + "AND authority = " + authority);
        return ("content".equalsIgnoreCase(scheme)
                && MediaStore.AUTHORITY.equalsIgnoreCase(authority));
    }

    /*************************************
     * ��ȡָ��URI����ǩ
     * @param context,�����Ļ���
     * @param uri,��ƵURI
     * @return :
     **************************************/
    public static Integer getBookmark(Context context, Uri uri) {
        Integer bookmark;
        LOG("Enter getBookmark()");
        if (!uriSupportsBookmarks(uri)) {
            return null;
        }
        Cursor cur = getCurrentCursor(context, uri);
        if (cur != null) {
            bookmark = cur.getInt(cur.getColumnIndexOrThrow(MediaStore.Video.Media.BOOKMARK));
            cur.close();
            return bookmark;
        }
        return null;
    }

    public static String getVedioName(Context context, Uri uri) {
        String vedio_name;
        Cursor cur = getCurrentCursor(context, uri);
        if (cur != null) {
            vedio_name = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DISPLAY_NAME));
            cur.close();
            return vedio_name;
        }
        if (null != uri && uri.toString().startsWith("content://")) {
            try {
                String[] strNames = uri.getPath().split(":");
                if (strNames.length > 1) {
                    return strNames[strNames.length - 1];
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*************************************
     * �鿴��ǩ�Ƿ�Ϊ��
     * @param context,�����Ļ���
     * @param URI,��ƵURI
     * @return :
     * ***********************************/
    public static boolean isBookmarkNull(Context context, Uri uri) {
        Cursor cur = getCurrentCursor(context, uri);
        if (cur != null) {
            if (cur.getInt(cur.getColumnIndexOrThrow(MediaStore.Video.Media.BOOKMARK)) != 0) {
                cur.close();
                return false;
            }
        }
        return true;
    }

    /*************************************
     * ɾ����ǩ
     * @param context,�����Ļ���
     * @param uri,��ƵURI
     * @return :ɾ��ɹ����ӡɾ������ʾ��Ϣ,�����ӡɾ��ʧ����ʾ��Ϣ
     * ***********************************/
    public static void deleteBookmark(Context context, Uri uri) {
        if (!isBookmarkNull(context, uri)) {
            if (ConfigUtil.IS_ENABLE_BOOKMARK_CAPTURE) {
                String videoPath = getVideoPath(context, uri);
                if (videoPath != null) {
                    File thumbFile = new File(ConfigUtil.CAPTURE_DIR + videoPath.hashCode() + ".jpg");
                    if (thumbFile.exists())
                        thumbFile.delete();
                }
            }
            ContentValues value = new ContentValues();
            value.put(MediaStore.Video.Media.BOOKMARK, 0);
            LOG("value = " + value);
            context.getContentResolver().update(uri, value, null, null);
            (Toast.makeText(context, R.string.deletebookmark_sucess, Toast.LENGTH_SHORT)).show();
        } else
            (Toast.makeText(context, R.string.deletebookmark_fail, Toast.LENGTH_SHORT)).show();
    }

    /*************************************
     * ɾ���uri��Ƶ��ý����е���Ϣ
     * @param context,�����Ļ���
     * @param Uri,��ƵUri
     * @return :null
     * ***********************************/
    public static void deleteCurrentVideo(Context context, Uri uri) {
        try {
            getResolver(context).delete(uri, null, null);
        } catch (Exception e) {
            // TODO Auto-generated catch block
//			e.printStackTrace();
            e.printStackTrace();
        }
    }

    /*************************************
     * ɾ����Ƶ�ļ���������̣�
     * @param context,�����Ļ���
     * @param fileName,�ļ�·��
     * @return :NULL����ӡɾ������ʾ��Ϣ
     * ***********************************/
    public static void deleteViedoFile(Context context, String fileName) {
        LOG(" deleteViedoFile fileName = " + fileName);

	    /*int fileLen = fileName.length();
        String strFlash = "/mnt/sdcard";
	    String strSDcard = "/mnt/sdcard/external_sd"; 
	    
	    if(fileName.indexOf("/mnt/sdcard") != -1){
	        fileName = fileName.substring(11, fileLen - 1);
	    }
	    
	    if(fileName.indexOf("/mnt/sdcard/external_sd") != -1){
	        fileName = fileName.substring(11, fileLen - 1);
	    }*/

        //------------------------------------------
        //��Ϊ��ɾ��sdcard�ļ�ʱ�᷵��ʧ��������ɾ��sdcard�ļ�ʱֱ�Ӹ��ɾ��ɹ�����ʾ��
        //�����ж��Ƿ�ɾ��ɹ�
        if ((fileName.indexOf("sdcard")) != -1) {
            LOG("going here !!!!!!!!!!!!!!!!!!!!!!");
            File f = new File(fileName);

            if (f.exists() && f.isFile()) {
                LOG(fileName + " is exist and is a file");
                boolean result = false;
                result = f.delete();
                if (!result) {
                    LOG("Could not delete " + fileName);
                    //(Toast.makeText(context, R.string.alert_cantdelete, Toast.LENGTH_SHORT)).show();
                    (Toast.makeText(context, R.string.alert_cantdelete, Toast.LENGTH_SHORT)).show();
                } else
                    (Toast.makeText(context, R.string.alert_deletesuccess, Toast.LENGTH_SHORT)).show();
            } else {
                LOG(fileName + " not exist!!!");
                (Toast.makeText(context, R.string.alert_deletesuccess, Toast.LENGTH_SHORT)).show();
            }

        } else {
            LOG("going here @@@@@@@@@@@@@@@@@@@@@@@@@");
            File f = new File(fileName);
            if (f.exists() && f.isFile()) {
                LOG(fileName + " is exist and is a file");
                boolean result = false;
                result = f.delete();
                if (!result) {
                    LOG("Could not delete " + fileName);
                    //(Toast.makeText(context, R.string.alert_cantdelete, Toast.LENGTH_SHORT)).show();
                    (Toast.makeText(context, R.string.alert_cantdelete, Toast.LENGTH_SHORT)).show();
                } else
                    (Toast.makeText(context, R.string.alert_deletesuccess, Toast.LENGTH_SHORT)).show();
            } else {
                LOG(fileName + " not exist!!!");
                (Toast.makeText(context, R.string.alert_deletesuccess, Toast.LENGTH_SHORT)).show();
            }
        }
    }

    /*************************************
     * �鿴ý����Ƿ�����ɨ��
     * @param context,�����Ļ���
     * @return :
     * ***********************************/
    public static boolean isMediaScannerScanning(Context context) {
        boolean result = false;
        Cursor cursor = getResolver(context).query(MediaStore.getMediaScannerUri(),
                new String[]{MediaStore.MEDIA_SCANNER_VOLUME}, null, null, null);
        if (cursor != null) {
            if (cursor.getCount() == 1) {
                cursor.moveToFirst();
                result = "external".equals(cursor.getString(0));
            }
            cursor.close();
        }
        LOG(">>>>>>>>>>>>>>>>>>>>>>>>> isMediaScannerScanning returning " + result);
        return result;
    }

    /*************************************
     * ��ѯ����
     * @param context,�����Ļ���
     * @param uri,Ҫ��ѯ��URI
     * @param projeciton,��ѯ���еļ���
     * @param selection,Ҫ���ص���
     * @param selectionArgs,ѡ��ı�־
     * @param sortOrder,����ʽ
     * @return :
     * ***********************************/
    public static Cursor query(Context context, Uri uri, String[] projection,
                               String selection, String[] selectionArgs, String sortOrder) {
        LOG("Enter query()");
        try {
            ContentResolver resolver = context.getContentResolver();
            if (resolver == null) {
                return null;
            }
            return resolver.query(uri, projection, selection, selectionArgs, sortOrder);
        } catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    /*************************************
     * ���ص�ǰuri��Ӧ��Ƶ�ļ���ý����е�λ��
     * @param context,�����Ļ���
     * @param uri,��Ƶuri
     * @return :
     * ***********************************/
    public static int FindPosition(Context context, Uri mUri) {
        int pos = -1;
        if (mUri == null)
            return pos;
        Uri uri = MediaStore.Video.Media.getContentUri("external");
        Cursor cur = query(context, uri, mCols, null, null, null);
        if (cur != null) {
            cur.moveToFirst();
            while (!cur.isAfterLast()) {
                Uri tempUri = Uri.withAppendedPath(uri, cur.getString(cur.getColumnIndex(MediaStore.Video.Media._ID)));
                LOG("mUri/tempUri = " + mUri + "/" + tempUri);
                if (mUri.equals(tempUri)) {
                    return cur.getPosition();
                } else cur.moveToNext();
            }
        }
        cur.close();
        return pos;
    }

    /*************************************
     * �����Ķ���
     * ***********************************/
    public interface Def {
        public final int MODE_SYSTEM = 1;
        public final int MODE_USER = 2;
        public final int VOLUMEPLUS = 1;
        public final int VOLUMEMINUS = -1;
    }

    /*************************************
     * ���ñ���
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void setBacklight(Context context, int mode) {
        setBacklight(context, mode, getBacklight(context, mode));
    }

    /*************************************
     * ���ó�ʼ���⣨�ս��������˳�����ʱʹ�ã�
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void setOriBacklight(Context context, int mode) {
        //�ȸ��ϵͳ������´��ڳ����ڵ�ϵͳ�������
        storeOriBacklight(context, mode);
        //���ģʽ���ñ���
        setOriBacklight(context, mode, getOrigBacklight(context, mode));
    }

    /*************************************
     * ���ó�ʼ���⣨�ս��������˳�����ʱʹ�ã�
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void storeOriBacklight(Context context, int mode) {
        switch (mode) {
            case Def.MODE_SYSTEM:
                storeOriSysBacklight(context, getOriSysBacklight(context));
                break;
            case Def.MODE_USER:
                storeOriSysBacklight(context, getOriSysBacklight(context));
                break;
        }

    }

    /*************************************
     * ���ó�ʼ���⣨�ս��������˳�����ʱʹ�ã�
     * @param context,�����Ļ���
     * @param value,����ֵ
     * @return :null
     * ***********************************/
    public static void storeOriSysBacklight(Context context, int value) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt("sysBacklight", value);
        editor.commit();
        LOG("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SET SCREEN_BRIGHTNESS3:" + value);
        Settings.System.putInt(context.getContentResolver(),
                Settings.System.SCREEN_BRIGHTNESS, value);
    }

    /*************************************
     * ���ó�ʼ���⣨�ս��������˳�����ʱʹ�ã�
     * @param context,�����Ļ���
     * @return :ϵͳ�ı���ֵ
     * ***********************************/
    public static int getOriSysBacklight(Context context) {
        int value = 0;
        try {
            value = Settings.System.getInt(context.getContentResolver(),
                    Settings.System.SCREEN_BRIGHTNESS);
        } catch (SettingNotFoundException e) {
            e.printStackTrace();
            LOG("Get System info error ");
        }//
        if (value == 0) {
            value = getBacklightValue(context, Def.MODE_SYSTEM);
        }
        return value;
    }

    /*************************************
     * ���ó�ʼ���⣨�ս��������˳�����ʱʹ�ã�
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,����ֵ
     * @return :null
     * ***********************************/
    public static void setOriBacklight(Context context, int mode, int value) {
        setBacklightValue(context, mode, value);
        storeBacklightValue(context, mode, value);
    }

    /*************************************
     * ���ñ��⣨����������һ�����ñ��⣬�������汳��ֵ��
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,����ֵ
     * @return :null
     * ***********************************/
    public static void setBacklight(Context context, int mode, int value) {
        setBacklightValue(context, mode, value);
        storeBacklightValue(context, mode, value);
    }

    public static void setBacklightValueAndMode(Context context, int mode, int appmode, int value) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        switch (mode) {
            case Def.MODE_SYSTEM: {
                setBrightness(context, value);
                editor.putInt("sysBacklight", value);
                editor.putInt("appMode", appmode);
                editor.commit();
                LOG("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SET SCREEN_BRIGHTNESS2:" + value);
                Settings.System.putInt(context.getContentResolver(), Settings.System.SCREEN_BRIGHTNESS, value);
            }
            break;
            case Def.MODE_USER: {
                setBrightness(context, value);
                editor.putInt("userBacklight", value);
                editor.putInt("appMode", appmode);
                editor.commit();
            }
            break;
        }
    }

    public static int getBacklightMode(Context context) {
        int mode = 0;
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        mode = settings.getInt("appMode", 0);
        return mode;
    }

    /*************************************
     * ���ر���ֵ
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :����ֵ
     * ***********************************/
    public static int getBacklight(Context context, int mode) {
        return getBacklightValue(context, mode);
    }

    public static int getBrightnessMode(Context context, int defaultValue) {
        int brightnessMode = defaultValue;
        try {
            brightnessMode = Settings.System.getInt(context.getContentResolver(),
                    Settings.System.SCREEN_BRIGHTNESS_MODE);
        } catch (SettingNotFoundException snfe) {
        }
        return brightnessMode;
    }

    public static void setMode(Context context, int mode) {
        Settings.System.putInt(context.getContentResolver(),
                Settings.System.SCREEN_BRIGHTNESS_MODE, mode);
    }

    /*************************************
     * ���ñ���
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,����ֵ
     * @return :null
     * ***********************************/
    public static void setBacklightValue(Context context, int mode, int value) {
        //Log.v("=============", "============="+mode+"=============value:"+value);
        switch (mode) {
            case Def.MODE_SYSTEM: {
                setBrightness(context, value);
                storeBacklightValue(context, Def.MODE_SYSTEM, value);
                LOG("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SET SCREEN_BRIGHTNESS2:" + value);
                Settings.System.putInt(context.getContentResolver(), Settings.System.SCREEN_BRIGHTNESS, value);
            }
            break;
            case Def.MODE_USER: {
                setBrightness(context, value);
            }
            break;
        }
    }

    /*************************************
     * ���ñ��⣨ʵ�����õĺ���
     * @param context,�����Ļ���
     * @param brightness,����ֵ
     * @return :null
     * ***********************************/
    private static void setBrightness(Context context, int brightness) {
//		 Log.v("========================", "===========setBrightness=============");
//		 try {
//	            IPowerManager power = IPowerManager.Stub.asInterface(
//	                    ServiceManager.getService("power"));
//	            if (power != null) {
//	                power.setBacklightBrightness(brightness);
//	            }
//	        } catch (RemoteException doe) {
//	            
//	        }        
    }

    /*************************************
     * �洢����ֵ
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param lihghtness,����ֵ
     * @return :null
     * ***********************************/
    private static void storeBacklightValue(Context context, int mode, int lightness) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        switch (mode) {
            case Def.MODE_SYSTEM: {
                editor.putInt("sysBacklight", lightness);
                editor.commit();
                LOG("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SET SCREEN_BRIGHTNESS:" + lightness);
                Settings.System.putInt(context.getContentResolver(), Settings.System.SCREEN_BRIGHTNESS, lightness);
            }
            break;
            case Def.MODE_USER: {
                editor.putInt("userBacklight", lightness);
                editor.commit();
            }
            break;
        }
    }

    /*************************************
     * ��ȡ����ֵ
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :
     * ***********************************/
    private static int getBacklightValue(Context context, int mode) {
        int lightness = 0;
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        switch (mode) {
            case Def.MODE_SYSTEM: {
                // lightness = settings.getInt("sysBacklight", 0);
                //if(lightness == 0){
                lightness = getOrigBacklight(context, Def.MODE_SYSTEM);
//				 Log.v("DBUtils", "~~~~~~~~~~~~~~~~~~~~~~lightness:"+lightness);
                // }
            }
            break;
            case Def.MODE_USER: {
                lightness = settings.getInt("userBacklight", 0);
                if (lightness == 0) {
                    lightness = getOrigBacklight(context, Def.MODE_SYSTEM);
                }
            }
            break;
        }
        return lightness;
    }

    /*************************************
     * ��ȡ��ʼ����ֵ
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :����ֵ
     * ***********************************/
    private static int getOrigBacklight(Context context, int mode) {
        int value = 0;
        switch (mode) {
            case Def.MODE_SYSTEM: {
                try {
                    value = Settings.System.getInt(context.getContentResolver(),
                            Settings.System.SCREEN_BRIGHTNESS);
                    return value;
                } catch (SettingNotFoundException e) {
                    e.printStackTrace();
                    LOG("Get System info error ");
                }
            }
            break;
            case Def.MODE_USER: {
                value = getBacklightValue(context, Def.MODE_USER);
            }
            break;
        }

        return value;
    }

    /*************************************
     * ��ر���
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void setbackBacklight(Context context, int mode) {
        switch (mode) {
            case Def.MODE_SYSTEM: {
                setBacklightValue(context, Def.MODE_SYSTEM, getBacklightValue(context, Def.MODE_SYSTEM));
            }
            break;
            case Def.MODE_USER: {
                setBacklightValue(context, Def.MODE_USER, getBacklightValue(context, Def.MODE_SYSTEM));
                //setBacklightValue(context,Def.MODE_SYSTEM,getBacklightValue(context,Def.MODE_SYSTEM));
            }
            break;
        }
    }

    /*************************************
     * ���ó�ʼ����ֵ���ڸս������ʱʹ�ã�
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void setOriVolume(Context context, int mode) {
        setOriVolume(context, mode, getOrigVolume(context, mode));
    }

    /*************************************
     * ���ñ���
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void setVolume(Context context, int mode) {
        setVolume(context, mode, getVolumeValue(context, mode));
    }

    /*************************************
     * ��������
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,Ҫ���õ�����ֵ
     * @return :null
     * ***********************************/
    public static void setVolume(Context context, int mode, int value) {
//		 setVolumeValue(context,mode,value);
        storeVolumeValue(context, mode, value);
    }

    /*************************************
     * ����ԭʼ����
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,Ҫ���õ�����ֵ
     * @return :null
     * ***********************************/
    public static void setOriVolume(Context context, int mode, int value) {
        if (mode == Def.MODE_SYSTEM) {
            setVolume(context, mode, value);
        } else {
            storeVolumeValue(context, Def.MODE_SYSTEM, getOrigVolume(context, Def.MODE_SYSTEM));
            setVolume(context, mode, value);
        }
    }

    /*************************************
     * ��������
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :��Ӧģʽ������ֵ
     * ***********************************/
    public static int getVolume(Context context, int mode) {
        return getVolumeValue(context, mode);
    }

    /*************************************
     * ��������
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,����ֵ
     * @return :null
     * ***********************************/
    public static void setVolumeValue(Context context, int mode, int value) {
        switch (mode) {
            case Def.MODE_SYSTEM: {
//			 setVolumes(context,value);
            }
            break;
            case Def.MODE_USER: {
//			 setVolumes(context,value);
            }
            break;
        }
    }
    /*************************************
     * ��������
     * @param context,�����Ļ���
     * @param value,����ֵ
     * @return :null
     * ***********************************/
//	public static void setVolumes(Context context,int value){
//		AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
//		if(value >= audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC))
//			value = audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
//		audioManager.setStreamVolume(AudioManager.STREAM_MUSIC, value, 0);
//	}

    /*************************************
     * ��������
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void volumeAdjust(Context context, int mode, int option) {
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        int volume;
        if (audioManager != null) {
            //Adjust the volume in on key down since it is more
            //responsive to the user.
            int flags = AudioManager.FLAG_REMOVE_SOUND_AND_VIBRATE;
            if (VideoPlayActivity.mCanDisplayCustomUI) {
                flags |= AudioManager.FLAG_SHOW_UI_WARNINGS;
            } else {
                flags |= AudioManager.FLAG_SHOW_UI;
            }
            if (option == Def.VOLUMEPLUS) {
                audioManager.adjustSuggestedStreamVolume(
                        AudioManager.ADJUST_RAISE,
                        AudioManager.STREAM_MUSIC,
                        flags);
                volume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
                storeVolumeValue(context, mode, volume);
            }
            if (option == Def.VOLUMEMINUS) {
                audioManager.adjustSuggestedStreamVolume(
                        AudioManager.ADJUST_LOWER,
                        AudioManager.STREAM_MUSIC,
                        flags);
                volume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
                storeVolumeValue(context, mode, volume);
            }
        }
    }

    /*************************************
     * �洢����
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @param value,Ҫ�洢��ֵ
     * @return :null
     * ***********************************/
    public static void storeVolumeValue(Context context, int mode, int value) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        switch (mode) {
            case Def.MODE_SYSTEM: {
                editor.putInt("sysVolumeValue", value);
                editor.commit();
            }
            break;
            case Def.MODE_USER: {
                editor.putInt("userVolumeValue", value);
                editor.commit();
            }
            break;
        }
    }

//	 public static void setScreenValue(Context context, String hashCode, int mode){
//		 if(hashCode == null){
//			 return ;
//		 }
//		 
//		SharedPreferences settings = context.getSharedPreferences(PREFS_NAME,0);
//		SharedPreferences.Editor editor = settings.edit(); 
//		editor.putInt(hashCode + "-screenSize", mode);   			
//		editor.commit();
//	 }

    public static void setScreenValue(Context context, int mode) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt("VideoscreenSize", mode);
        editor.commit();
    }

    public static int getScreenValue(Context context) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        return settings.getInt("VideoscreenSize", 3);
    }

    /*************************************
     * ��ȡ����ֵ
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :��Ӧģʽ������ֵ
     * ***********************************/
    public static int getVolumeValue(Context context, int mode) {
        int volume = 0;

        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        switch (mode) {
            case Def.MODE_SYSTEM: {
                volume = settings.getInt("sysVolumeValue", 0);
                if (volume == 0) {
                    volume = getOrigVolume(context, Def.MODE_SYSTEM);
                }
            }
            break;
            case Def.MODE_USER: {
                volume = settings.getInt("userVolumeValue", 0);
                if (volume == 0) {
                    volume = getOrigVolume(context, Def.MODE_SYSTEM);
                }
            }
            break;
        }
        return volume;
    }

    /*************************************
     * ��ȡ��ʼ����ֵ
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :��Ӧģʽ�µ�����ֵ
     * ***********************************/
    public static int getOrigVolume(Context context, int mode) {
        int volume = 0;
        switch (mode) {
            case Def.MODE_SYSTEM: {
                AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
                volume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
            }
            break;
            case Def.MODE_USER: {
                volume = getVolumeValue(context, mode);
            }
            break;
        }
        return volume;
    }

    /*************************************
     * ������������˳�����ʱʹ�ã�
     * @param context,�����Ļ���
     * @param mode,����ģʽ
     * @return :null
     * ***********************************/
    public static void setbackVolume(Context context, int mode) {
        switch (mode) {
            case Def.MODE_SYSTEM:

                break;
            case Def.MODE_USER: {
             /*����Ϊϵͳ����*/
                setVolumeValue(context, Def.MODE_SYSTEM, getVolumeValue(context, Def.MODE_SYSTEM));
            }
            break;
        }
    }

    /*
    public static void getDirectoryPath(Context context,Uri uri){
        String path,stringpath = null;
        Cursor cur = context.getContentResolver().query(uri, new String[]{MediaStore.Images.Media.DATA}, null, null, null);
        if(cur!=null){
            stringpath = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Images.Media.DATA));
        }
        path = getPath(stringpath);
        File directory = new File(path);
        if(directory.)
    }
    public static String getPath(String str){
        String path = str;
        SimpleStringSplitter sp = new SimpleStringSplitter('/');
        //sp.setString("/");
        return path;
    }
    */
    public static int getVideoCount(Context context) {
        int count = 0;
        Uri uri = MediaStore.Video.Media.getContentUri("external");
        Cursor cur = query(context, uri, mCols, null, null, null);
        if (cur != null) {
            cur.moveToFirst();
            count = cur.getCount();
        }
        if (cur != null) {
            cur.close();
            cur = null;
        }

        return count;

    }

    public static String getVideoPath(Context context, Uri uri) {
        String path = null;
        if (uri == null)
            return null;

        Cursor cur = DBUtils.getCurrentCursor(context, uri);
        if (cur == null)
            return path;
        else {
            try {
                path = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
            } catch (IllegalArgumentException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        LOG("...........................getvideopath:" + path);
        cur.close();
        return path;
    }

    public static String getPath(Context context, Uri mUri) {
        if (mUri == null || mUri.getPath() == null) {
            return null;
        }
//			Log.v("====================", "====================mUri.toString():"+mUri.toString());
        if (mUri.toString().startsWith("file://")) {
            Uri uri = MediaStore.Video.Media.getContentUri("external");
            Cursor cur = context.getContentResolver().query(uri, mCols, null, null, null);
            String path = mUri.getPath();
            if (cur == null) {
                return null;
            }
            if (cur.moveToFirst()) {
                while (!cur.isAfterLast()) {
                    String temp = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
                    if (temp.equals(path)) {
                        cur.close();
                        cur = null;
                        return temp.trim();
                    } else {
                        cur.moveToNext();
                    }
                }
            }
            if (cur != null) {
                cur.close();
                cur = null;
            }
        } else {
            Cursor cur = context.getContentResolver().query(mUri, mCols, null, null, null);
            if (cur == null) {
                return null;
            }
            if (cur.moveToFirst()) {
                return cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
            }
            cur.close();
            cur = null;
        }
        return null;
    }

    public static void storeValue(Context context, String key, int value) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static int getValue(Context context, String key) {
        SharedPreferences settings = context.getSharedPreferences(PREFS_NAME, 0);
        return settings.getInt(key, 0);
    }

    public static boolean isSeviceWorked(Context context, String serviceName) {
        ActivityManager myManager = (ActivityManager) context
                .getSystemService(Context.ACTIVITY_SERVICE);
        ArrayList<RunningServiceInfo> runningService = (ArrayList<RunningServiceInfo>) myManager
                .getRunningServices(500);
        for (int i = 0; i < runningService.size(); i++) {
            if (runningService.get(i).service.getClassName().toString()
                    .equals(serviceName)) {
                return true;
            }
        }
        return false;
    }
}
