package android.rk.RockVideoPlayer.ui;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;

public class Transition3d {
    public static final int ANIMATIONTIME = 600;
    private final static String TAG = "Transition3d";
    private final static boolean DEBUG = true;

    public final void LOGD(String str) {
        if (DEBUG) {
            Log.d(TAG, str);
        }
    }

    private ViewGroup mContainer;
    private View firstView;
    private View secondView;
    private View threeView;

    private boolean THREEView = false;

    public Transition3d(ViewGroup container,
                        View firstview, View secondview, View threeview) {
        this.mContainer = container;
        this.firstView = firstview;
        this.secondView = secondview;
        this.threeView = threeview;
        mContainer.setPersistentDrawingCache(ViewGroup.PERSISTENT_ANIMATION_CACHE);
    }

    public Transition3d(ViewGroup container, View firstview, View secondview) {
        this.mContainer = container;
        this.firstView = firstview;
        this.secondView = secondview;
        mContainer.setPersistentDrawingCache(ViewGroup.PERSISTENT_ANIMATION_CACHE);
    }

    public void applyRotation(int position, float start, float end) {
        // Find the center of the container
        final float centerX = mContainer.getWidth() / 2.0f;
        final float centerY = mContainer.getHeight() / 2.0f;


        // Create a new 3D rotation with the supplied parameter
        // The animation listener is used to trigger the next animation
        final Rotate3dAnimation rotation =
                new Rotate3dAnimation(start, end, centerX, centerY, 310.0f, true);
        rotation.setDuration(ANIMATIONTIME);
        rotation.setFillAfter(true);
        rotation.setInterpolator(new AccelerateInterpolator());
        rotation.setAnimationListener(new DisplayNextView(position));

        mContainer.startAnimation(rotation);
    }

    private final class DisplayNextView implements Animation.AnimationListener {
        private final int mPosition;

        private DisplayNextView(int position) {
            mPosition = position;
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            mContainer.post(new SwapViews(mPosition));
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    private final class SwapViews implements Runnable {
        private final int mPosition;

        public SwapViews(int position) {
            mPosition = position;
        }

        public void run() {
            final float centerX = mContainer.getWidth() / 2.0f;
            final float centerY = mContainer.getHeight() / 2.0f;
            Rotate3dAnimation rotation = null;

            if (mPosition == 0) {
                firstView.setVisibility(View.GONE);
                secondView.setVisibility(View.GONE);
                if (THREEView) {
                    threeView.setVisibility(View.VISIBLE);
                    threeView.requestFocus();
                }

                rotation = new Rotate3dAnimation(90, 0, centerX, centerY, 310.0f, false);
            } else if (mPosition > 0) {
                firstView.setVisibility(View.GONE);
                if (THREEView) {
                    threeView.setVisibility(View.GONE);
                }
                secondView.setVisibility(View.VISIBLE);
                secondView.requestFocus();

                rotation = new Rotate3dAnimation(90, 0, centerX, centerY, 310.0f, false);
            } else if (mPosition < 0) {
                secondView.setVisibility(View.GONE);
                if (THREEView) {
                    threeView.setVisibility(View.GONE);
                }
                firstView.setVisibility(View.VISIBLE);
                firstView.requestFocus();

                rotation = new Rotate3dAnimation(90, 0, centerX, centerY, 310.0f, false);
            }

            rotation.setDuration(ANIMATIONTIME);
            rotation.setFillAfter(true);
            rotation.setInterpolator(new DecelerateInterpolator());

            mContainer.startAnimation(rotation);
        }
    }
}