/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.rk.RockVideoPlayer;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore.Entry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnDismissListener;
import android.content.DialogInterface.OnCancelListener;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Canvas;
import android.graphics.Color;
import android.media.AudioManager;
import android.media.AudioManager.OnAudioFocusChangeListener;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnCompletionListener;
import android.media.MediaPlayer.OnErrorListener;
import android.media.TimedText;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.provider.MediaStore;
import android.rk.RockVideoPlayer.VideoController.VideoPlayerControl;
import android.rk.RockVideoPlayer.subTitle.SubTitleContent;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.widget.Toast;
import android.os.Parcel;

/**
 * Displays a video file.  The VideoView class
 * can load images from various sources (such as resources or content
 * providers), takes care of computing its measurement from the video so that
 * it can be used in any layout manager, and provides various display options
 * such as scaling and tinting.
 */
public class VideoDisplayView extends SurfaceView implements
        VideoPlayerControl, OnClickListener, OnDismissListener {
    private static final String TAG = "VideoDisplayView";
    private static final String PREFS_NAME = "android.rk.RockVideoPlayer";
    //	private static final boolean DEBUG = true;
    private static final boolean DEBUG = false;

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        } else {
            if (DebugUtil.isDebugFileExist())
                Log.d(TAG, msg);
        }
    }

    // settable by the client
    private Uri mUri;
    private int mDuration;

    // All the stuff we need for playing and showing a video
    private SurfaceHolder mSurfaceHolder = null;
    private MediaPlayer mMediaPlayer = null;
    public boolean mIsPrepared;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private VideoController mVideoController;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private OnErrorListener mOnErrorListener;
    private OnVideoViewListener mOnVideoViewListener;
    //private boolean     mStartWhenPrepared;
    //private int         mSeekWhenPrepared;
    private Context mContext;
    private VideoPlayActivity mActivity;
    private Integer mPlayTime;
    private String mVideoName;
    private boolean mPauseState;
    //private ProgressDialog pd;

    private boolean isNet3gp = false;
    private boolean mEnable = true;
    /*public var:true if seek completed*/
    public boolean mSeekComplete = true;
    //private Uri CurrentUri;
    /*���Ĵ�С��*/
    private static int sMaxWidth = -1;
    private static int sMaxHeight = -1;
    // private View         mBookmarkCheckView;
    AlertDialog BookmarkCheckDialog;
    public boolean mTVOutEnable;

    private int mRepeatMode;
    private final int sSingle = 0;
    private final int sRepeatOne = 1;
    private final int sRepeatAll = 2;
    /*use to mark whether setScreenSize Button Clicked*/
    private boolean mSetScreebSizeClicked = false;
    private int mBrightness;
    public int mBrightMode;
    private final int HIDE_REPEATVIEW = 1;
    private final int BookmarkCheckDialog_FADE_OUT = 2;
    /*�����������������dialog*/
    private final int TIME_SHOWCHECK = 500;
    private final int TIME_SHORT = 5000;
    private final int TIME_MIDDLE = 8000;
    private final int TIME_LONG = 10000;
    /*
     * ��ȫ��ѭ��ʱ�����ж�������Ƶ�Ƿ��ǲ��ɲ��ŵ�
     * mVideoAvailable == true ˵������Ƶ�ǿ�����ŵ�
     * mVideoUnavailable == true˵���Ѿ�����Ƶ���ܲ���
     * */
    private boolean mVideoAvailable = false;
    private boolean mVideoUnavailable = false;
    private int mUnavailableCount = 0;

    private int screenSizeMode = 0;

    public static ArrayList<String> bookmarkvideo = new ArrayList<String>();

    public static final String CRLF = System.getProperty("line.separator");
    private int mSubtitleTrackCnt = 0;
    private int mCurrentSelectSubTrkIdx = 0;
    private int mCurrentSelectAudioTrackIdx = 0;
    private int mDefSelectInBandText = -1;
    private static final int KEY_PARAMETER_AUDIO_SELECT_INDEX = 1997;
    private int mCurrentSelectShowSubFirst = 0;
    private static final String SELELCT_SUB_TYPE = "selectShowSubtitleType";
    private static final int EXTERNAL_SUB_TYPE = 0;
    private static final int EMBEDDED_SUB_TYPE = 1;
    private static final int ERROR_ID_COPYRIGHT_NO_RMVB = 0xF0;    /*no rmvb copyright*/
    private static final int ERROR_ID_COPYRIGHT_NO_DIVX = 0xF1;    /*no divx copyright*/
    private static final int ERROR_ID_COPYRIGHT_DIFF_CHIP = 0xF2;    /*this chip not support this codecID*/
    private static final int ERROR_ID_TOO_HIGH_BITRATE = 0xF3;    /*bitrate is too high*/
    private static final int ERROR_ID_NO_CODEC = 0xF4;    /*codec not found*/
    private static final int ERROR_ID_VPU_MPEG4_ROSOLUTION = 0xF5;    /*mpeg4 not support 4k*/
    private static final int ERROR_ID_10BIT_NOT_SUPPORT = 0xF6;    /*3288 supports 10bit only*/
    private static final int ERROR_ID_4K_NOT_SUPPORT = 0xF7;    /*312x not support 4k(1080p only)*/
    private static final int ERROR_ID_H265_NOT_SUPPORT = 0xF8;    /*312x not support 4k*/
    private boolean hasExternalSub = false;
    private boolean hasEmbeddedSub = false;
    private AudioManager mAudioManager;
    private boolean mPausedByTransientLossOfFocus;

    /*
     ** These keys must be in sync with the keys in AwesomePlayer.cpp,
     ** also need to make sure not conflict with mediaplayer.h.
    */
    private static final int KEY_PARAMETER_TIMED_TEXT_FRAME_DURATION_MS = 1999;

    private int mSeekWhenPrepared;

    // These keys must be in sync with the keys in TimedText.java
    public static final int KEY_START_TIME = 7; // int
    SubTraInfo info = new SubTraInfo();
    private AlertDialog mRepeatModeDialog;
    private AlertDialog mAudioTrackDialog;
    private AlertDialog mSubTrkDialog;
    private AlertDialog mShowSubDialog;

    /**
     * Gets the value of the parameter indicated by key.
     * The caller is responsible for recycling the returned parcel.
     *
     * @param key key indicates the parameter to get.
     * @return value of the parameter.
     * {@hide}
     */
    public Parcel getParcelParameter(int key) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();

        request.writeInterfaceToken("android.media.IMediaPlayer");
        request.writeInt(key);
        mMediaPlayer.invoke(request, reply);
        request.recycle();
        return reply;
    }

    /**
     * mCheckBookmark == true �Ѿ������Ƿ�����ǩ
     */
    private boolean mCheckBookmark = false;

    public VideoDisplayView(Context context) {
        super(context);
        LOG("Enter VideoDisplayView");
        mContext = context;
        init();
    }

    public VideoDisplayView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        LOG("videoDisplayview two args");
    }

    public VideoDisplayView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LOG("Enter VideoDisplayView three args");
        mContext = context;
        init();
    }

    private void init() {

        mRepeatMode = GetRepeatMode();
        initVideoDisplayView();

        //register the listener to top-level view so that can make the videocontroler display/hide.
        //((View)getParent()).setOnClickListener(this);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//		  Log.i("@@@@", "onMeasure");
//		  LOG("widthMeasureSpec = " + widthMeasureSpec +"AND heightMeasureSpec = " + heightMeasureSpec);
//		  LOG("mVideoWidth = " + mVideoWidth + "mVideoHeight = " + mVideoHeight);
//	        int width = getDefaultSize(mVideoWidth, widthMeasureSpec);
//	        int height = getDefaultSize(mVideoHeight, heightMeasureSpec);
            /*
            LOG(" width = " + width + " height = " + height );
	        if (mVideoWidth > 0 && mVideoHeight > 0) {
	            if ( mVideoWidth * height  > width * mVideoHeight ) {
	                Log.i("@@@", "image too tall, correcting");
	                height = width * mVideoHeight / mVideoWidth;
	            } else if ( mVideoWidth * height  < width * mVideoHeight ) {
	                Log.i("@@@", "image too wide, correcting");
	                width = height * mVideoWidth / mVideoHeight;
	            } else {
	                Log.i("@@@", "aspect ratio is correct: " +
	                        width+"/"+height+"="+
	                        mVideoWidth+"/"+mVideoHeight);
	            }
	        }
	        */
        LOG("@@@@@@@@@@ setting size: " + mVideoWidth + 'x' + mVideoHeight);
        //setMeasuredDimension(width, height);
        setMeasuredDimension(mVideoWidth, mVideoHeight);
    }

    public void setMaxWh() {
        DisplayMetrics dm = new DisplayMetrics();
          /*int batHeight = (int)getResources().getDimensionPixelSize(com.android.internal.R.dimen.navigation_bar_height);
          Configuration c = this.getResources().getConfiguration();
		  int smallestScreenWidthDp = c.smallestScreenWidthDp;
		  Log.v(TAG,"--------------------smallestScreenWidthDp:"+smallestScreenWidthDp+"------batHeight:"+batHeight+",dm.heightPixels:"+dm.heightPixels);
		  if(smallestScreenWidthDp >= 600){
			  if(ConfigUtil.IS_ADD_STATUS_BAR_HEIGHT){
//				  if(c.orientation == Configuration.ORIENTATION_LANDSCAPE)
					  dm.heightPixels += 48;
//				  else
//					  dm.widthPixels += getResources().getDimension(com.android.internal.R.dimen.navigation_bar_height);
			  }
		  }else if(ConfigUtil.IS_ADD_STATUS_BAR_WIDTH){
//			  if(c.orientation == Configuration.ORIENTATION_LANDSCAPE)
//				  dm.widthPixels += 42;
//			  else
				  dm.heightPixels += 48; 
		  }*/
        //修复SDK 24以上分屏多任务下视频无法居中的bug
        if (Build.VERSION.SDK_INT >= 24) {
            boolean isInMultiWindowMode = ((Activity) mContext).isInMultiWindowMode();
            if (!isInMultiWindowMode) {
                /*((Activity) mContext).getWindowManager().getDefaultDisplay().getMetrics(dm);
                sMaxWidth = dm.widthPixels;
                sMaxHeight = dm.heightPixels;
                //<600的横屏情况下,导航栏在右侧. <24的低版本没验证过该问题
                Configuration configuration = getResources().getConfiguration();
                int nbHeight = getNavigationBarHeight(mContext);
                if (Configuration.ORIENTATION_LANDSCAPE == configuration.orientation
                        && configuration.smallestScreenWidthDp < 600) {
                    sMaxWidth += nbHeight;
                } else {
                    sMaxHeight += nbHeight;
                }*/
                ((Activity) mContext).getWindowManager().getDefaultDisplay().getRealMetrics(dm);
            } else {
                ((Activity) mContext).getWindowManager().getDefaultDisplay().getMetrics(dm);
            }
            sMaxWidth = dm.widthPixels;
            sMaxHeight = dm.heightPixels;
        } else {
            ((Activity) mContext).getWindowManager().getDefaultDisplay().getMetrics(dm);
            sMaxWidth = dm.widthPixels;
            sMaxHeight = getScreentHeight();
        }
        mVideoWidth = sMaxWidth;
        mVideoHeight = sMaxHeight;
        Log.v(TAG, "--------------------------mVideoWidth:" + mVideoWidth + ",mVideoHeight:" + mVideoHeight);
    }

    private int getNavigationBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public int getScreentHeight() {
        int heightPixels;
        WindowManager w = ((Activity) mContext).getWindowManager();
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        // since SDK_INT = 1;
        heightPixels = metrics.heightPixels;
        // includes window decorations (statusbar bar/navigation bar)
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17)
            try {
                heightPixels = (Integer) Display.class
                        .getMethod("getRawHeight").invoke(d);
            } catch (Exception ignored) {
            }
            // includes window decorations (statusbar bar/navigation bar)
        else if (Build.VERSION.SDK_INT >= 17)
            try {
                android.graphics.Point realSize = new android.graphics.Point();
                Display.class.getMethod("getRealSize",
                        android.graphics.Point.class).invoke(d, realSize);
                heightPixels = realSize.y;
            } catch (Exception ignored) {
            }
        Log.e("realHightPixels-heightPixels", heightPixels + "width");
        return heightPixels;
    }

    public int resolveAdjustedSize(int desiredSize, int measureSpec) {
        int result = desiredSize;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);

        switch (specMode) {
            case MeasureSpec.UNSPECIFIED:
                    /* Parent says we can be as big as we want. Just don't be larger
                     * than max size imposed on ourselves.
	                 */
                result = desiredSize;
                break;

            case MeasureSpec.AT_MOST:
                    /* Parent says we can be as big as we want, up to specSize.
                     * Don't be larger than specSize, and don't be larger than
	                 * the max size imposed on ourselves.
	                 */
                result = Math.min(desiredSize, specSize);
                break;

            case MeasureSpec.EXACTLY:
                // No choice. Do what we are told.
                result = specSize;
                break;
        }
        return result;
    }

    private void initVideoDisplayView() {
        LOG("Enter initVideoDisplayView()");
        mAudioManager = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);
        setMaxWh();
//		    mVideoHeight = 0;
//		  	mVideoWidth = 0;
        //��ʼ�����ֵ
        getHolder().addCallback(mSHCallback);
        getHolder().setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
        setFocusable(true);
        setFocusableInTouchMode(true);
        requestFocus();
        LOG("initVideoDisplayView() Ended");
    }

//	  public void setVideoPath(String path)
//	  {
//		  LOG("Enter setVideoPath()");
//		  setVideoURI(Uri.parse(path));
//	  }

    public void setVideoURI(Uri uri) {
        LOG("Enter setVideoURI() uri:" + uri.toString());
        Cursor temp = DBUtils.getCurrentCursor(mContext, uri);
        if (temp == null) {
            mUri = DBUtils.getTrueUri(mContext, uri);
        } else {
            mUri = uri;
            temp.close();
            temp = null;
        }
        mCheckBookmark = false;
        mSeekWhenPrepared = 0;

        mCurrentSelectSubTrkIdx = DBUtils.getValue(mContext, SUBTITLE_FLAG + mUri.toString());
        mCurrentSelectAudioTrackIdx = DBUtils.getValue(mContext, AUDIOTRACK_FLAG + mUri.toString());
        mCurrentSelectShowSubFirst = DBUtils.getValue(mContext, SELELCT_SUB_TYPE);
        hasExternalSub = false;
        hasEmbeddedSub = false;
        openVideo();
    }

    public void stopPlayback() {
        if (mMediaPlayer != null) {
            mMediaPlayer.stop();
            //mMediaPlayer.reset();
            mMediaPlayer.release();
            //mMediaPlayer.reset();
            mMediaPlayer = null;
        }
    }

    public Thread subTitleShowThread = null;
    private boolean showSubTitleFlag = false;
    public static boolean runSubtitleThread = true;

    private void clearAllMsg() {
        mActivity.subtitleHandler
                .removeMessages(VideoPlayActivity.HIDE_IMGSUBTITLE);
        mActivity.subtitleHandler
                .removeMessages(VideoPlayActivity.HIDE_SUBTITLE);
        mActivity.subtitleHandler
                .removeMessages(VideoPlayActivity.SHOW_SUBTITLE);
        mActivity.subtitleHandler
                .removeMessages(VideoPlayActivity.SHOW_LASTSUBTITLE);
        mActivity.subtitleHandler
                .removeMessages(VideoPlayActivity.SHOW_IMGSUBTITLE);
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        if (null != mVideoController){
            mVideoController.viewDialogDismiss();
        }
    }

    private class SubTraInfo {
        private ArrayList<String> subtitle = new ArrayList<String>();
        private ArrayList<String> track = new ArrayList<String>();
        private HashMap<Integer, Integer> subIndex = new HashMap<Integer, Integer>();
        private HashMap<Integer, Integer> traIndex = new HashMap<Integer, Integer>();

        public SubTraInfo() {
        }

        public ArrayList<String> getSubtitles() {
            return subtitle;
        }

        public ArrayList<String> getTrack() {
            return track;
        }

        public void addToSubtitles(String value, int index) {
            subIndex.put(subtitle.size(), index);
            subtitle.add(value);
        }

        public void addToTracks(String value, int index) {
            traIndex.put(track.size(), index);
            track.add(value);
        }

        public HashMap<Integer, Integer> getTraIndexMap() {
            return traIndex;
        }

        public HashMap<Integer, Integer> getSubIndexMap() {
            return subIndex;
        }

        public void clear() {
            subtitle.clear();
            track.clear();
            subIndex.clear();
            traIndex.clear();
        }
    }

    private void openVideo() {
        LOG("Enter the openVideo()");
        if (mUri == null || mSurfaceHolder == null) {
            // not ready for playback just yet, will try again later
            return;
        }
        LOG("mContext = " + mContext + "mUri = " + mUri);
        mPlayTime = DBUtils.getBookmark(mContext, mUri);
        mVideoName = DBUtils.getVedioName(mContext, mUri);
        mVideoController.setVedioName(mVideoName);
        mActivity.displaySubTitleView(false);

        LOG("mPlayTime = " + mPlayTime);
        if (mMediaPlayer != null) {
            mMediaPlayer.reset();
            mMediaPlayer.release();
            mMediaPlayer = null;
        }

        try {
            mMediaPlayer = new MediaPlayer();
            LOG("mMediaPlayer = " + mMediaPlayer);
            mIsPrepared = false;

            mMediaPlayer.setOnPreparedListener(mPreparedListener);
            LOG("reset duration to -1 in openVideo");
            mDuration = -1;
            mMediaPlayer.setOnVideoSizeChangedListener(mSizeChangedListener);
            mMediaPlayer.setOnCompletionListener(mCompletionListener);
            mMediaPlayer.setOnErrorListener(mErrorListener);
            mMediaPlayer.setOnBufferingUpdateListener(mBufferingUpdateListener);
            mMediaPlayer.setOnSeekCompleteListener(mOnSeekCompleteListener);
            mMediaPlayer.setOnTimedTextListener(mTimeTextListener);

            mCurrentBufferPercentage = 0;
            LOG("-------------setDataSource-------------mUri:" + mUri);
            mMediaPlayer.setDataSource(mContext, mUri, null);

            mMediaPlayer.setDisplay(mSurfaceHolder);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
            mMediaPlayer.setScreenOnWhilePlaying(true);

            mMediaPlayer.prepareAsync();
            attachMediaController();

            LOG("<--------------------here will get subtitle track info---------------------------");

            //make current subtitle or audio track to default;
            if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                if (info != null) {
                    info.clear();
                }
//	                mCurrentSelectSubTrkIdx = 0;
//	                if(!ConfigUtil.IS_ENABLE_CHOOSE_DTS_POWER_CONTROL){
//	                	mCurrentSelectAudioTrackIdx = 0;
//	                }
                mSubtitleTrackCnt = 0;
                mDefSelectInBandText = -1;
            }
        } catch (IOException | IllegalStateException ex) {
            Log.w(TAG, "Unable to open content: " + mUri, ex);
            mErrorListener.onError(mMediaPlayer, 0, 0);
            return;
        } catch (IllegalArgumentException ex) {
            Log.w(TAG, "Unable to open content: " + mUri, ex);
            return;
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }

        final String subtitlePath = SubContentUtil.getSubTitleFile(mContext, mUri);
        LOG("<---------------subtitlePath=" + subtitlePath + "-------------------->");
//	        while(ConfigUtil.ISENABLESUBTITLE){
//        		if(subTitleShowThread != null && subTitleShowThread.isAlive()){
//	        		runSubtitleThread = false;
//
//	        		clearAllMsg();
//
//	        		mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.HIDE_IMGSUBTITLE);
//	        		mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.HIDE_SUBTITLE);
//
//	        		SubContentUtil.stopDecodeFlag = true;
//	        		VideoPlayActivity.isShowingSubtitle = false;
//
//	        		try {
//	        			LOG(">>>>>>>>>>>>>>>.waiting for prethread die");
//						Thread.sleep(10L);
//					} catch (InterruptedException e) {
//						// TODO Auto-generated catch block
//						e.printStackTrace();
//					}
//        		}else{
//        			break;
//        		}
//        	}
        mActivity.subtitleList = null;

        runSubtitleThread = true;
        if (ConfigUtil.ISENABLESUBTITLE && subtitlePath != null && mSubtitleTrackCnt == 0) {
            new Thread() {
                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    SubContentUtil.stopDecodeFlag = false;
                    VideoPlayActivity.isShowingSubtitle = false;
                    mActivity.subtitleList = SubContentUtil.decodeSubtitle(subtitlePath);
                    mActivity.decodeSubtitleFinish = true;
                }
            }.start();

            subTitleShowThread = new Thread() {
                int currPos = 0;

                @Override
                public void run() {
                    // TODO Auto-generated method stub
                    SubTitleContent content = null;
                    SubTitleContent preContent = null;
                    Message msg = null;
                    int delayTime = 0;
                    showSubTitleFlag = true;

                    while (runSubtitleThread) {
                        if (mActivity.subtitleList == null || mActivity.subtitleList.size() == 0) {
                            try {
                                Thread.sleep(500L);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }

                        if (mMediaPlayer != null && showSubTitleFlag) {
                            try {
                                currPos = mMediaPlayer.getCurrentPosition();
                            } catch (Exception e) {
                                continue;
                            }

                            content = SubContentUtil.getCurrentSubTitle(currPos, mActivity.subtitleList);
                            if (content != null) {
                                hasExternalSub = true;
                                delayTime = content.getmSubTitleEndTime() - content.getmSubTitleStartTime();
                            }
                            LOG("VideoPlayActivity.isShowingSubtitle:" + VideoPlayActivity.isShowingSubtitle);
                            LOG("*******************************************delayTime:" + delayTime);
                            if (hasExternalSub && hasEmbeddedSub && mCurrentSelectShowSubFirst == EMBEDDED_SUB_TYPE) {

                            } else if (!VideoPlayActivity.isShowingSubtitle) {
                                if (content != null) {
                                    if (subtitlePath.endsWith(".idx")) {
                                        msg = new Message();
                                        msg.what = VideoPlayActivity.SHOW_IMGSUBTITLE;
                                        msg.obj = content.getmSubTitleBmp();
                                        clearAllMsg();
                                        mActivity.subtitleHandler.sendMessage(msg);
                                        if (content.getmSubTitleEndTime() == Integer.MAX_VALUE)
                                            mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.SHOW_LASTSUBTITLE);
                                        mActivity.subtitleHandler.sendEmptyMessageDelayed(VideoPlayActivity.HIDE_IMGSUBTITLE, delayTime);
                                    } else {
                                        msg = new Message();
                                        msg.what = VideoPlayActivity.SHOW_SUBTITLE;
                                        msg.obj = content.getmSubTitleLine();
                                        clearAllMsg();
                                        mActivity.subtitleHandler.sendMessage(msg);
                                        if (content.getmSubTitleEndTime() == Integer.MAX_VALUE)
                                            mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.SHOW_LASTSUBTITLE);
                                        mActivity.subtitleHandler.sendEmptyMessageDelayed(VideoPlayActivity.HIDE_SUBTITLE, delayTime);
                                    }

                                    LOG("show subtitle and delay time:" + delayTime + " ms");
                                } else {
                                    clearAllMsg();
                                    mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.HIDE_SUBTITLE);
                                    LOG("content is null!!!");
                                }

                                preContent = content;
                            } else {
                                LOG("is showing subtitle!!!");
                                if (preContent != null && content != null && preContent.getmSubTitleLine() != null && !preContent.getmSubTitleLine().equals(content.getmSubTitleLine())) {
                                    LOG("+++++++++++++++++++++++++++++++++++++have new change");
                                    LOG("preline:" + preContent.getmSubTitleLine());
                                    LOG("currline:" + content.getmSubTitleLine());
                                    clearAllMsg();
                                    msg = new Message();
                                    msg.what = VideoPlayActivity.SHOW_SUBTITLE;
                                    msg.obj = content.getmSubTitleLine();
                                    mActivity.subtitleHandler.sendMessage(msg);
                                    if (content.getmSubTitleEndTime() == Integer.MAX_VALUE)
                                        mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.SHOW_LASTSUBTITLE);
                                    mActivity.subtitleHandler.sendEmptyMessageDelayed(VideoPlayActivity.HIDE_SUBTITLE, delayTime);

                                    preContent = content;
                                }
                            }

                            try {
                                Thread.sleep(500L);
                            } catch (InterruptedException e) {
                                // TODO Auto-generated catch block
                                e.printStackTrace();
                            }
                        } else {
                            break;
                        }
                    }
                }
            };
            subTitleShowThread.start();
        }
    }

    public void setMediaController(VideoController controller) {
        LOG("<-----------setMediaController-------------->");
        boolean show = false;
        if (mVideoController != null) {
            if (mVideoController.isShowing()) {
                show = true;
            }
            mVideoController.hide();
        }
        mVideoController = controller;
        attachMediaController();
        if (show) {
            mVideoController.show();
        }
    }

    private void attachMediaController() {
        LOG("<----------attachMediaController------------->");
        if (mMediaPlayer != null && mVideoController != null) {
            mVideoController.setMediaPlayer(this);
                /*View anchorView = this.getParent() instanceof View ?
                        (View)this.getParent() : this;*/
              /*
              View parentView = (View)this.getParent();
	          //*��ȫ����Χ�ڰ���ʱ����������
	          parentView.setOnClickListener(fullscreenListener);
	          */
            //mVideoController.setAnchorView(anchorView);
            mVideoController.setEnabled(mIsPrepared);
	          /*���ŵ�������3gp�Ļ��ý������������û����Ӧ*/
            if (isNet3gp)
                mVideoController.setDisableWhen3gp();
        }
    }

    private boolean isUriAva() {
        try {
            LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>connect :" + mUri.toString());
            URL url = new URL(mUri.toString());
            HttpURLConnection http = (HttpURLConnection) url.openConnection();
            http.connect();

            int responseCode = http.getResponseCode();
            LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>responseCode :" + responseCode);
            if (responseCode == 200) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            return false;
        }
    }

    private Handler showErrDialogHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            new AlertDialog.Builder(mContext)
                    .setTitle(R.string.VideoView_error_title)
                    .setMessage(R.string.VideoView_error_networkfail)
                    .setPositiveButton(R.string.VideoView_error_button,
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                            /* If we get here, there is no onError listener, so
                             * at least inform them that the video is over.
                             */
                                    if (mOnCompletionListener != null) {
                                        mOnCompletionListener.onCompletion(mMediaPlayer);
                                    }
                                    mActivity.Finish();
                                }
                            })
                    .setCancelable(true)
                    .show();
        }

    };

    Handler checkLiveStreamHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            new Thread() {
                long starttime = System.currentTimeMillis();
                long currtime = 0L;
                int currpos = -1;

                @Override
                public void run() {
                    // TODO Auto-generated method stub
                    synchronized (obj) {
                        LOG("##############+++++++++++++++++video is pause,start reconnect++++++++++++++");

                        if (mMediaPlayer == null) {
                            return;
                        }

                        if (mMediaPlayer.isPlaying() == false) {
                            mReplayHandler.sendEmptyMessage(STOP_PLAYER);
                            new Thread() {
                                @Override
                                public void run() {
                                    // TODO Auto-generated method stub
                                    starttime = System.currentTimeMillis();
                                    while (true) {
                                        currtime = System.currentTimeMillis();
                                        if (currtime - starttime > ConfigUtil.NETWORK_FAIL_TIMEOUT) {
                                            showErrDialogHandler.sendEmptyMessage(0);
                                            break;
                                        }

                                        if (isUriAva()) {
                                            mReplayHandler.sendEmptyMessage(START_PLAYER);
                                            break;
                                        }

                                        try {
                                            Thread.sleep(1000L);
                                        } catch (InterruptedException e) {
                                            // TODO Auto-generated catch block
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }.start();
                            return;
                        }

                        //mActivity.mHandler.sendEmptyMessage(VideoPlayActivity.SHOW_PROCESS_FLAG);
                        starttime = System.currentTimeMillis();
                        isEnableSeek = false;
                        while (true) {
                            currtime = System.currentTimeMillis();
                            if (mMediaPlayer == null) {
                                return;
                            }
                            currpos = mMediaPlayer.getCurrentPosition();
                            if (currtime - starttime > ConfigUtil.NETWORK_FAIL_TIMEOUT) {
                                mActivity.mHandler.sendEmptyMessageDelayed(VideoPlayActivity.HIDE_PROCESS_FLAG, 2000);
                                showErrDialogHandler.sendEmptyMessage(0);
                                isEnableSeek = true;
                                return;
                            } else {
                                if (isUriAva() && mMediaPlayer != null) {
                                    int duration = mMediaPlayer.getDuration();
                                    if (duration - currpos < 2 * 1000L) {
                                        mActivity.Finish();
                                    } else {
                                        mMediaPlayer.seekTo(currpos + (int) ((duration - currpos) * 0.9));
                                        LOG(">>>>>>>>>>>>>>>>>>>>>>>>uri is ava, reseek to " + (currpos + (int) ((duration - currpos) * 0.9)) + " current:" + currpos);
                                        try {
                                            Thread.sleep(2000L);
                                        } catch (InterruptedException e) {
                                            // TODO Auto-generated catch block
                                            e.printStackTrace();
                                        }
                                        mMediaPlayer.seekTo(currpos);
                                    }

//									mActivity.mHandler.sendEmptyMessageDelayed(VideoPlayActivity.HIDE_PROCESS_FLAG, 2000);
                                    return;
                                } else {
                                    LOG(">>>>>>>>>>>>>>>>>>>>>>>>uri is unava!!!");
                                }
                            }

                            try {
                                Thread.sleep(500L);
                            } catch (InterruptedException e) {
                                // TODO Auto-generated catch block
                                e.printStackTrace();
                            }
                        }
                    }
                }

            }.start();
        }

    };

    Object obj = new Object();
    public static boolean isEnableSeek = true;
    public static boolean isNetWorkDisconnect = false;
    public static boolean isInDownloading = false;
    MediaPlayer.OnInfoListener mOnInfoListener = new MediaPlayer.OnInfoListener() {
        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            // TODO Auto-generated method stub
            LOG("onInfo msg receive, what: " + what + " extra: " + extra);
            switch (extra) {
                case 99:
                    isEnableSeek = false;
                    isNetWorkDisconnect = true;
                    if (isInDownloading) {
                        checkLiveStreamHandler.removeMessages(0);
                        Message msg = new Message();
                        msg.what = 0;
                        checkLiveStreamHandler.sendMessageDelayed(msg, 1000);
                    }
                    return true;
                case 98:
                    mActivity.mHandler.sendEmptyMessage(VideoPlayActivity.HIDE_PROCESS_FLAG);
                    isEnableSeek = true;
                    isNetWorkDisconnect = false;
                    isInDownloading = false;
                    return true;
                case 97:
                    isInDownloading = true;
                    if (isNetWorkDisconnect == true) {
                        isNetWorkDisconnect = false;
                        checkLiveStreamHandler.removeMessages(0);
                        Message msg = new Message();
                        msg.what = 0;
                        checkLiveStreamHandler.sendMessageDelayed(msg, 1000);
                    } else {
                        LOG("going onInfo 97 to  SHOW_PROCESS_FLAG");
                        if (mActivity.mPercentView != null && mActivity.mPercentView.getVisibility() != View.VISIBLE) {
                            //mActivity.mHandler.sendEmptyMessage(VideoPlayActivity.SHOW_PROCESS_FLAG);
                        }

                    }

                    return true;

                case 101:
                    LOG("onInfo, get extra data" + extra);
                default:
                    LOG("onInfo, default case");
                    break;
            }

            return false;
        }

    };
    MediaPlayer.OnTimedTextListener mTimeTextListener =
            new MediaPlayer.OnTimedTextListener() {

                @Override
                public void onTimedText(MediaPlayer mediaplayer, TimedText timedText) {
                    if ((mediaplayer == null) || (timedText == null)) {
                        return;
                    }

                    // TODO Auto-generated method stub

                    //get info from TimedText
                    String strSubDataSrc = timedText.getText();
                    String strSubDataDst = "";
                    if (strSubDataSrc == null) {
                        return;
                    }
                    int subDataInLen = strSubDataSrc.length();

                    Parcel retParcel = getParcelParameter(KEY_PARAMETER_TIMED_TEXT_FRAME_DURATION_MS);
                    int subFrmDurationMs = retParcel.readInt();
                    retParcel.recycle();

                    LOG("subtitle textLen: " + subDataInLen +
                            " subFrmDurationMs: " + subFrmDurationMs);
                    LOG("subDataIn: " + strSubDataSrc);

					/* find CRLF */
                    int indexCRLF = 0;
                    int iLastCRLFIndex = strSubDataSrc.lastIndexOf(CRLF);
                    int iSubstrStart = 0;
                    int iSubstrEnd = 0;

                    while ((indexCRLF >= 0) && (indexCRLF < strSubDataSrc.length())) {
                        indexCRLF = strSubDataSrc.indexOf(CRLF, iSubstrStart);
                        if (indexCRLF == 0) {
                            iSubstrStart += CRLF.length();
                            continue;
                        }

                        if (indexCRLF >= 1) {
                            iSubstrEnd = indexCRLF;
                            strSubDataDst += strSubDataSrc.substring(iSubstrStart, iSubstrEnd - CRLF.length());
                            strSubDataDst += "<br>";
                            iSubstrStart = iSubstrEnd + CRLF.length();
                        }

                        if ((iLastCRLFIndex >= 0) && (indexCRLF == iLastCRLFIndex)) {
                            strSubDataDst += strSubDataSrc.substring(iLastCRLFIndex + CRLF.length());
                            break;
                        }
                    }

                    if (strSubDataDst == "") {
                        strSubDataDst = strSubDataSrc;
                    }

                    Message msg = null;
                    msg = new Message();
                    msg.what = VideoPlayActivity.SHOW_SUBTITLE;
                    msg.obj = strSubDataDst;        //"hello world, crystal here :)";
                    if (hasExternalSub && hasEmbeddedSub && mCurrentSelectShowSubFirst == EXTERNAL_SUB_TYPE) {
                        return;
                    }
                    clearAllMsg();
                    mActivity.subtitleHandler.sendMessage(msg);
                    if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.O) {
                        mActivity.subtitleHandler.sendEmptyMessageDelayed(VideoPlayActivity.HIDE_SUBTITLE,
                                subFrmDurationMs);
                    }
                }
            };

    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener =
            new MediaPlayer.OnVideoSizeChangedListener() {
                public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                    setScreenMode(screenSizeMode);
                }
            };

    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener() {
        public void onPrepared(MediaPlayer mp) {
            mIsPrepared = true;
            if (ConfigUtil.IS_ENABLE_CHOOSE_DTS_POWER_CONTROL) {
                //mCurrentSelectAudioTrackIdx = mMediaPlayer.getIntParameter(KEY_PARAMETER_AUDIO_SELECT_INDEX);
            }
            LOG("mOnPreparedListener = " + mOnPreparedListener);
            if (mOnPreparedListener != null) {
                mOnPreparedListener.onPrepared(mMediaPlayer);
            }
            LOG("mVideoController = " + mVideoController);
            if (mVideoController != null) {
                mVideoController.setEnabled(true);
                if (isNet3gp)
                    mVideoController.setDisableWhen3gp();
            }
            LOG("MediaPlayer mp= " + mp);
            mVideoWidth = mp.getVideoWidth();
            mVideoHeight = mp.getVideoHeight();
            screenSizeMode = DBUtils.getScreenValue(mContext);
            mVideoController.setButtonSrcByMode(screenSizeMode);
            setScreenMode(screenSizeMode);
            LOG("mVideoWidth = " + mVideoWidth + " mVideoHeight = " + mVideoHeight);
            int seekToPosition = mSeekWhenPrepared;  // mSeekWhenPrepared may be changed after seekTo() call
            boolean isShowBookmark = seekToPosition == 0 ? true : false;
            if (seekToPosition != 0) {
                seekTo(seekToPosition);
            }
            if (mActivity.getWasPlayingWhenPaused() || mActivity.getIsForceDoStartPlay()) {
                Log.v(TAG, "mMediaPlayer.start after prepared");
                isEnableSeek = true;
                mMediaPlayer.start();
                mActivity.updateForceDoStartPlay(false);
            }
            SubAuHandler.removeMessages(SUB_AU_MSG);
            SubAuHandler.sendEmptyMessageDelayed(SUB_AU_MSG, 1500);
            mHandler.postDelayed(checkBookmarkRunnable, TIME_SHOWCHECK);

            mActivity.progress_Handler.removeMessages(VideoPlayActivity.SHOW_PROCESS_FLAG);
            mActivity.progress_Handler.sendEmptyMessage(VideoPlayActivity.HIDE_PROCESS_FLAG);
            mActivity.dismissLoading();
            handler.removeMessages(MSG);
            handler.sendEmptyMessageDelayed(MSG, 200);
        }
    };

    private static final int MSG = 0x01;
    private Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG:
                    if (mVideoController != null)
                        mVideoController.show();
                    break;
            }
        }

    };

    private static final int SUB_AU_MSG = 0x01;
    private Handler SubAuHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case SUB_AU_MSG:
                    try {
                        if (mMediaPlayer != null) {
                            MediaPlayer.TrackInfo[] trkInfo = mMediaPlayer.getTrackInfo();
                            int trkType = -1;
                            String value = null;

                            for (int i = 0; i < trkInfo.length; i++) {
                                trkType = trkInfo[i].getTrackType();
                                value = trkInfo[i].getLanguage();

                                if (trkType == MediaPlayer.TrackInfo.MEDIA_TRACK_TYPE_TIMEDTEXT || trkType == MediaPlayer.TrackInfo.MEDIA_TRACK_TYPE_SUBTITLE) {
                                    if (mDefSelectInBandText == -1) {
                                        mDefSelectInBandText = i;
                                    }

                                    info.addToSubtitles(value, i);
                                    mSubtitleTrackCnt++;
                                } else if (trkType == MediaPlayer.TrackInfo.MEDIA_TRACK_TYPE_AUDIO) {
                                    info.addToTracks(value, i);
                                }
                            }

//						if((mDefSelectInBandText >=0) &&
//								(mDefSelectInBandText <trkInfo.length)){
//
//								if (trkInfo[mDefSelectInBandText].getTrackType() ==
//									MediaPlayer.TrackInfo.MEDIA_TRACK_TYPE_TIMEDTEXT) {
//
//									/* select to default InBand text */
//									mMediaPlayer.selectTrack(mDefSelectInBandText);
//								}
//							}
                            if (info.getSubIndexMap().size() > 0) {
                                hasEmbeddedSub = true;
                            }
                            if (info != null && info.getSubIndexMap() != null && info.getSubIndexMap().size() > 0) {
                                int realIndex = info.getSubIndexMap().get(mCurrentSelectSubTrkIdx);
                                mMediaPlayer.selectTrack(realIndex);
                            }
                            if (info != null && info.getTraIndexMap() != null && info.getTraIndexMap().size() > 0) {
                                int realIndex = info.getTraIndexMap().get(mCurrentSelectAudioTrackIdx);
                                mMediaPlayer.selectTrack(realIndex);
                            }

                        }
                        break;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
            }
        }

    };

    private static final int STOP_PLAYER = 0x0009;
    private static final int START_PLAYER = 0x00010;
    private static final int SHOW_PERCENT = 0x00011;
    private static final int HIDE_PERCENT = 0x00012;
    private Handler mReplayHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>now replay the video>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");

            switch (msg.what) {
                case START_PLAYER:
                    mActivity.setUri(mUri);
                    setVideoURI(mUri);
                    initStatus();
                    break;
                case STOP_PLAYER:
                    pause();
                    StopPlay();
                    break;
                case SHOW_PERCENT:
                    StringBuilder sb = new StringBuilder();
                    String loadtitle = mContext.getResources().getString(R.string.loadtitle);
                    int precent = getBufferPercentage();

                    sb.append(precent);
                    sb.append("% ");
                    sb.append(loadtitle);
                    mActivity.mPercentView.setVisibility(View.VISIBLE);
                    mActivity.mPercentText.setText(sb.toString());
                    mReplayHandler.sendEmptyMessageDelayed(SHOW_PERCENT, 500);
                    break;
                case HIDE_PERCENT:
                    mActivity.mPercentView.setVisibility(View.GONE);
                    break;
                default:
                    break;
            }
        }
    };


    private MediaPlayer.OnCompletionListener mCompletionListener =
            new MediaPlayer.OnCompletionListener() {
                public void onCompletion(MediaPlayer mp) {
                    if (mVideoController != null && !mVideoController.isShowing()) {
                        mVideoController.hide();
                    }
                    if (BookmarkCheckDialog != null) {
                        BookmarkCheckDialog.dismiss();
                    }
                    //next(mRepeatMode);
//				  Intent i  = new Intent("com.android.rk.videoplay.finish");
//				  mActivity.sendBroadcast(i);
                    afterVideoComplete();
                }
            };

    private void afterVideoComplete() {
        Log.v(TAG, "afterVideoComplete mRepeatMode= " + mRepeatMode);
        switch (mRepeatMode) {
            case sSingle:
                Finish();
                break;
            case sRepeatOne:
                next(sRepeatOne);
                break;
            case sRepeatAll:
                next(sRepeatAll);
                break;

        }
    }

    private MediaPlayer.OnSeekCompleteListener mOnSeekCompleteListener =
            new MediaPlayer.OnSeekCompleteListener() {

                public void onSeekComplete(MediaPlayer mp) {
                    // TODO Auto-generated method stub
                    LOG("mSeekComplete = " + mSeekComplete);
                    mSeekComplete = true;
                }

            };

    public boolean isNetworkAvailable(Activity mActivity) {
        Context context = mActivity.getApplicationContext();
        ConnectivityManager connectivity = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (connectivity == null) {
            return false;
        } else {
            NetworkInfo[] info = connectivity.getAllNetworkInfo();
            if (info != null) {
                for (int i = 0; i < info.length; i++) {
                    if (info[i].getState() == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                }
            }
        }
        return false;
    }


    private AlertDialog.Builder alert = null;
    private boolean isVideoError = false;
    private MediaPlayer.OnErrorListener mErrorListener =
            new MediaPlayer.OnErrorListener() {
                public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
                    Log.e(TAG, "Video Display View Error: " + framework_err + "," + impl_err);
                    isVideoError = true;
                    if (mVideoController != null) {
                        mVideoController.hide();
                    }

                    LOG("+++++++++++++++++++++++++mVideoController == null");
                    if (mMediaPlayer != null) {
                        mMediaPlayer.setScreenOnWhilePlaying(true);
                    }

                    LOG("+++++++++++++++++++++++++mMediaPlayer == null");
	            /* If an error handler has been supplied, use it and finish. */
                    if (mOnErrorListener != null) {
                        if (mOnErrorListener.onError(mMediaPlayer, framework_err, impl_err)) {
                            LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>.use on error listener");
                            return true;
                        }
                    }

                    LOG("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
	            /* Otherwise, pop up an error dialog so the user knows that
	             * something bad has happened. Only try and pop up the dialog
	             * if we're attached to a window. When we're going away and no
	             * longer have a window, don't bother showing the user an error.
	             */
                    if (getWindowToken() != null) {
                        LOG("++++++++++++++++++++++++++++++++++++getWindowToken() != null");
                        mActivity.KeyguardLock();
                        mActivity.hh.removeMessages(1);
                        mActivity.hh.sendEmptyMessageDelayed(1, 2000);
                        Resources r = mContext.getResources();
                        int messageId = R.string.VideoView_error_text_unknown;

                        if (framework_err == MediaPlayer.MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK) {
                            messageId = R.string.VideoView_error_text_invalid_progressive_playback;
                        } else {
                            LOG("+++++++++++++++++++++++++++impl_err =:" + impl_err);
                            switch (impl_err) {
                                case -11:
                                    messageId = R.string.VideoView_error_networkfail;
                                    break;
                                default:
                                    messageId = R.string.VideoView_error_text_unknown;
                                    break;
                            }
                            switch (impl_err) {
                                case ERROR_ID_COPYRIGHT_NO_RMVB:
                                    messageId = R.string.MediaError_RMVBCopyRight;
                                    break;
                                case ERROR_ID_COPYRIGHT_NO_DIVX:
                                    messageId = R.string.MediaError_DIVXCopyRight;
                                    break;
                                case ERROR_ID_COPYRIGHT_DIFF_CHIP:
                                    messageId = R.string.MediaError_ChipDiff;
                                    break;
                                case ERROR_ID_TOO_HIGH_BITRATE:
                                    messageId = R.string.MediaError_HightBitrate;
                                    break;
                                case ERROR_ID_NO_CODEC:
                                    messageId = R.string.MediaError_NoCodec;
                                    break;
                                case ERROR_ID_VPU_MPEG4_ROSOLUTION:
                                    messageId = R.string.MediaError_MPEG4;
                                    break;
                                case ERROR_ID_10BIT_NOT_SUPPORT:
                                    messageId = R.string.MediaError_10BIT;
                                    break;
                                case ERROR_ID_4K_NOT_SUPPORT:
                                    messageId = R.string.MediaError_4K;
                                    break;
                                case ERROR_ID_H265_NOT_SUPPORT:
                                    messageId = R.string.MediaError_H265;
                                    break;
                                default:
                                    break;
                            }
                        }
                        if (mRepeatMode == sRepeatAll) {
                            String tUriString = mUri.toString();
                            if (false) {
                                mVideoUnavailable = true;
                                mUnavailableCount++;
                                Toast.makeText(mContext, messageId, Toast.LENGTH_LONG).show();
                                //����Ѿ�����Ƶ���Բ�����ת����һ��
                                if (mVideoAvailable) {
                                    next();
                                } else {

                                    if (mVideoUnavailable == true) {
                                        //����޷���Ƶ���ŵ��������ڵ�����Ƶ����ʱ
                                        if (mUnavailableCount >= DBUtils.getVideoCount(mContext)) {
                                            mActivity.finish();
//		                			android.os.Process.killProcess(android.os.Process.myPid());
                                        } else {
                                            next();
                                        }
                                    }
                                }
                            }//������sdcard�����ļ��Ļ�����ʾ�����˳�
                            else {
                                if (alert == null) {
                                    alert = new AlertDialog.Builder(mContext);
                                    alert.setOnCancelListener(new OnCancelListener() {

                                        @Override
                                        public void onCancel(DialogInterface dialog) {
                                            // TODO Auto-generated method stub
                                            mActivity.Finish();
                                        }
                                    });
                                    alert.setTitle(R.string.VideoView_error_title)
                                            .setMessage(messageId)
                                            .setPositiveButton(R.string.VideoView_error_button,
                                                    new DialogInterface.OnClickListener() {
                                                        public void onClick(DialogInterface dialog, int whichButton) {
	                                        /* If we get here, there is no onError listener, so
	                                         * at least inform them that the video is over.
	                                         */
                                                            if (mOnCompletionListener != null) {
                                                                mOnCompletionListener.onCompletion(mMediaPlayer);
                                                            }
                                                            mActivity.Finish();
                                                        }
                                                    })
                                            .setCancelable(true)
                                            .show();
                                }
                            }
                        } else {

                            AlertDialog.Builder alert = new AlertDialog.Builder(mContext);
                            alert.setOnCancelListener(new OnCancelListener() {

                                @Override
                                public void onCancel(DialogInterface dialog) {
                                    // TODO Auto-generated method stub
                                    mActivity.Finish();
                                }
                            });

                            alert.setTitle(R.string.VideoView_error_title)
                                    .setMessage(messageId)
                                    .setPositiveButton(R.string.VideoView_error_button,
                                            new DialogInterface.OnClickListener() {
                                                public void onClick(DialogInterface dialog, int whichButton) {
		                                        /* If we get here, there is no onError listener, so
		                                         * at least inform them that the video is over.
		                                         */
                                                    if (mOnCompletionListener != null) {
                                                        mOnCompletionListener.onCompletion(mMediaPlayer);
                                                    }
                                                    mActivity.Finish();
                                                }
                                            })
                                    .setCancelable(true)
                                    .show();

                        }
                    }
                    isVideoError = false;
                    return true;
                }
            };

    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener =
            new MediaPlayer.OnBufferingUpdateListener() {
                public void onBufferingUpdate(MediaPlayer mp, int percent) {
                    mCurrentBufferPercentage = percent;
                }
            };

    /**
     * Register a callback to be invoked when the media file
     * is loaded and ready to go.
     *
     * @param l The callback that will be run
     */
    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        LOG("Enter setOnPreparedListener()");
        mOnPreparedListener = l;
    }

    /**
     * Register a callback to be invoked when the end of a media file
     * has been reached during playback.
     *
     * @param l The callback that will be run
     */
    public void setOnCompletionListener(OnCompletionListener l) {
        mOnCompletionListener = l;
    }

    /**
     * Register a callback to be invoked when an error occurs
     * during playback or setup.  If no listener is specified,
     * or if the listener returned false, VideoView will inform
     * the user of any errors.
     *
     * @param l The callback that will be run
     */
    public void setOnErrorListener(OnErrorListener l) {
        mOnErrorListener = l;
    }

    public void setOnVideoViewListener(OnVideoViewListener listener) {
        mOnVideoViewListener = listener;
    }

    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback() {
        public void surfaceChanged(SurfaceHolder holder, int format,
                                   int w, int h) {
            LOG("<----------surfaceChanged---------> format=" + format + "w=" + w + " h=" + h);
            mSurfaceWidth = w;
            mSurfaceHeight = h;
//				if(mMediaPlayer != null && mMediaPlayer.getCurrentPosition() > 0)
//				{}
            if (mMediaPlayer != null && mIsPrepared && mVideoWidth == w && mVideoHeight == h) {
                LOG("CASE 5 EXE");
                if (mSetScreebSizeClicked == true) {
                    return;
                }
//						 mMediaPlayer.start();
//						 if(false == mCheckBookmark ){
                //CheckIfHaveBookmark();
//							 mHandler.postDelayed(checkBookmarkRunnable, TIME_SHOWCHECK);
//						 }
                // mSeekWhenPrepared = 0;
            } else return;
        }

        public void surfaceCreated(SurfaceHolder holder) {
            LOG("<--------surfaceCreate---------->");
            mSurfaceHolder = holder;
            openVideo();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            LOG("<-----------surfaceDestoryed-------->");
            // after we return from this we can't use the surface any more
            mSurfaceHolder = null;
            if (mVideoController != null && !mVideoController.isShowing()) mVideoController.hide();
            if (mMediaPlayer != null) {
                mMediaPlayer.reset();
                mMediaPlayer.release();
                mMediaPlayer = null;
            }
				/*if(mActivity != null )
				{
					mActivity.Finish();
				}*/
        }
    };

//	    @Override
//	    public boolean onTrackballEvent(MotionEvent ev)
//	    {
//	    	 if (mIsPrepared && mMediaPlayer != null && mVideoController != null) {
//	             toggleMediaControlsVisiblity();
//	         }
//	         return false;
//	    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        Log.v(TAG, ">>>>>>>>>>>>>>>>>>>>>on keydown:" + keyCode);
        if (mIsPrepared
                &&
                // keyCode != KeyEvent.KEYCODE_BACK &&
                // keyCode != KeyEvent.KEYCODE_VOLUME_UP &&
                // keyCode != KeyEvent.KEYCODE_VOLUME_DOWN &&
                keyCode != KeyEvent.KEYCODE_SEARCH
                && keyCode != KeyEvent.KEYCODE_CALL
                && keyCode != KeyEvent.KEYCODE_ENDCALL && mMediaPlayer != null
                && mVideoController != null) {
            if (keyCode == KeyEvent.KEYCODE_HEADSETHOOK
                    || keyCode == KeyEvent.KEYCODE_MEDIA_PLAY_PAUSE) {
                if (mMediaPlayer.isPlaying()) {
                    pause();
                    mVideoController.show();
                } else {
                    start();
                    mVideoController.hide();
                }
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_MEDIA_STOP
                    && mMediaPlayer.isPlaying()) {
                pause();
                mVideoController.show();
            } else if (keyCode == KeyEvent.KEYCODE_BACK) {
                Finish();
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
                if (ConfigUtil.REPLACE_KEY_VOLUME_UI
                        && KeyEvent.ACTION_DOWN == event.getAction()) {
                    VideoPlayActivity.mCanDisplayCustomUI = true;
                    displayVolume();
                } else {
                    VideoPlayActivity.mCanDisplayCustomUI = false;
                }
                DBUtils.volumeAdjust(mContext, getVolumeMode(), -1);
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
                if (ConfigUtil.REPLACE_KEY_VOLUME_UI
                        && KeyEvent.ACTION_DOWN == event.getAction()) {
                    VideoPlayActivity.mCanDisplayCustomUI = true;
                    displayVolume();
                } else {
                    VideoPlayActivity.mCanDisplayCustomUI = false;
                }
                DBUtils.volumeAdjust(mContext, getVolumeMode(), 1);
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_MENU) {
                toggleMediaControlsVisiblity();
            } else if (keyCode == KeyEvent.KEYCODE_MEDIA_NEXT) {
                next(mRepeatMode);
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_MEDIA_PREVIOUS) {
                prev(mRepeatMode);
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_MEDIA_PLAY) {
                start();
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_MEDIA_PAUSE) {
                pause();
                return true;
            }
        }

        return super.onKeyDown(keyCode, event);
    }

    public void toggleMediaControlsVisiblity() {
        LOG("Enter toggleMediaControlsVisiblity()");
        LOG("mVideoController = " + mVideoController);
        if (!mTVOutEnable) {
//				if (mMediaPlayer != null && mIsPrepared) {
            if (mVideoController.isShowing()) {
                mVideoController.hide();
            } else {
                mVideoController.show();
            }
//				}
        }
    }

    public void start() {
        LOG("<------------------------mediaplayer start---------------->");
        mActivity.acquireWakeLock();
        //mActivity.KeyguardLock();
        if (mMediaPlayer != null && mIsPrepared) {
            mMediaPlayer.start();
            //mStartWhenPrepared = false;
            mAudioManager.requestAudioFocus(mAudioFocusListener, AudioManager.STREAM_MUSIC,
                    AudioManager.AUDIOFOCUS_GAIN_TRANSIENT);
        } else {
            //mStartWhenPrepared = true;
            mAudioManager.requestAudioFocus(mAudioFocusListener, AudioManager.STREAM_MUSIC,
                    AudioManager.AUDIOFOCUS_GAIN_TRANSIENT);
        }
    }

    public void pause() {
        LOG("<-----------------mediaplayer pause----------------->");
        if (mMediaPlayer != null && mIsPrepared) {
            if (mMediaPlayer.isPlaying()) {
                mMediaPlayer.pause();
                mActivity.releaseWakeLock();
                // mActivity.KeyguardUnLock();
                if (mVideoController != null) {
                    mVideoController.removeBookmarkRunnable();
                }
                System.gc();
            }
        }
        //mStartWhenPrepared = false;
    }

    @Override
    public void displayVolume() {
        if (null != mOnVideoViewListener) {
            mOnVideoViewListener.displayCurrentVolume();
        }
    }

    /*����һ�����һ���л�����ʱ��*/
    public void StopPlay() {
        if (mMediaPlayer != null) {
            try {
                LOG("<-----------------stopPlay-------------->");
                Log.e(TAG, "<-----------------stopPlay-------------->");
                mMediaPlayer.stop();
                //mMediaPlayer.reset();
                mMediaPlayer.release();
                //mMediaPlayer.reset();
                mMediaPlayer = null;
                // mSurfaceHolder.getSurface().release();
                //  mSurfaceHolder = null;
                LOG("<-----------------stopPlay-------------->");
            } catch (Exception e) {

            }
        }
    }

    @Override
    public void prev(int mode) {
        LOG("Enter prev() and mUri = " + mUri);
        mActivity.updateForceDoStartPlay(true);
        VideoDisplayView.runSubtitleThread = false;
        switch (mode) {
            case sSingle:
                showSubTitleFlag = false;
                Finish();
                break;
            case sRepeatAll:
                showSubTitleFlag = false;
                prev();
                break;
            case sRepeatOne:
                showSubTitleFlag = false;
                prevWithRepeatCheck();
                break;
            default:
                showSubTitleFlag = false;
                prev();
                break;
        }
    }

    public void prev() {
        //if(mVideoController != null){
        //	mVideoController.hide();
        //}
        if (mMediaPlayer == null || !mIsPrepared) {
            Log.v(TAG, "prev directly return with "
                    + mMediaPlayer + ", mIsPrepared=" + mIsPrepared);
            return;
        }
        mActivity.mSubTitleText.setText("");
        LOG("<-----------prev---------");
        BookmarkCheckDialog = null;
//	    	 if(mActivity.m3uPlaylist != null && mActivity.m3uPlaylist.size() > 0 && mActivity.m3uplayindex != 0 && mActivity.m3uplayindex != -1){
//	    		 mActivity.mHandler.post(mActivity.mPlayingChecker);
//	    		 Uri uri = mActivity.m3uPlaylist.get(mActivity.m3uplayindex - 1);
//                 mActivity.m3uplayindex--;
//                 pause();
//                 StopPlay();
//                 mActivity.setUri(uri);
//                 setVideoURI(uri);
//                 initStatus();
//         }else{
//                 mActivity.m3uPlaylist = null;
//                 mActivity.m3uplayindex = -1;

        Cursor cur = DBUtils.getPrevCursor(mContext, mUri);
        if (cur != null) {
            Uri uri = MediaStore.Video.Media.getContentUri("external");
            Uri AimUri = Uri.withAppendedPath(uri, cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID)));
            LOG(" Prev Uri = " + AimUri);
            cur.close();
            cur = null;
            pause();
            StopPlay();
            isEnableSeek = false;
//                         try{
//         		    		Thread.sleep(500);
//         		    	}catch(Exception e){}
//                         if(mMediaPlayer == null){
            mActivity.setUri(AimUri);
            setVideoURI(AimUri);
            initStatus();
//                         }else{
//                         if (BookmarkCheckDialog != null){
//   	    			        BookmarkCheckDialog.dismiss();
//   	    		         }
//                         mActivity.finish();
//                        	 Intent intent = new Intent(Intent.ACTION_VIEW, AimUri);
//                        	 intent.setClass(mActivity, VideoPlayActivity.class);
//                        	 intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                        	 mActivity.startActivity(intent);
//                         }
        } else {
            return;
        }
//         }

    }

    public String getCurrentVideoName() {
        String name = null;
        Cursor cur = DBUtils.getCurrentCursor(mContext, mUri);
        if (cur != null) {
            name = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DISPLAY_NAME));
            cur.close();

        }

        return name;

    }

    private void prevWithRepeatCheck() {
        if (mRepeatMode == sRepeatOne) {
            //hideController();
//                if(mActivity.m3uPlaylist != null && mActivity.m3uPlaylist.size() > 0 && mActivity.m3uplayindex != -1){
//                		mActivity.mHandler.post(mActivity.mPlayingChecker);
//                		Uri uri = null;
//                        if(mActivity.m3uplayindex == 0){
//                                uri = mActivity.m3uPlaylist.get(0);
//                                mActivity.m3uplayindex = 0;
//                        }else{
//                                uri = mActivity.m3uPlaylist.get(mActivity.m3uplayindex - 1);
//                                mActivity.m3uplayindex--;
//                        }
//
//                        pause();
//                        StopPlay();
//                        mActivity.setUri(uri);
//                        setVideoURI(uri);
//                        initStatus();
//                }else{
//                		mActivity.m3uPlaylist = null;
//                		mActivity.m3uplayindex = -1;
            Cursor cur = DBUtils.getCurrentCursor(mContext, mUri);
            if (cur != null) {
                cur.close();
                cur = null;
                pause();
                StopPlay();
                mActivity.setUri(mUri);
                setVideoURI(mUri);
                initStatus();
            } else return;
        }
//        }
    }

    @Override
    public void next(int mode) {
        LOG("Enter next() and mUri = " + mUri);
        mActivity.updateForceDoStartPlay(true);
        VideoDisplayView.runSubtitleThread = false;
        switch (mode) {
            case sSingle:
                showSubTitleFlag = false;
                Finish();
                break;
            case sRepeatAll:
                showSubTitleFlag = false;
                next();
                break;
            case sRepeatOne:
                showSubTitleFlag = false;
                nextWithRepeatCheck();
                break;
        }
    }

    public void next() {
        LOG("<--------------next----------->");
        BookmarkCheckDialog = null;
        //mHandler.removeMessages(BookmarkCheckDialog_FADE_OUT);
        if (mMediaPlayer == null || !mIsPrepared) {
            Log.v(TAG, "next directly return with "
                    + mMediaPlayer + ", mIsPrepared=" + mIsPrepared);
            return;
        }
        mActivity.mSubTitleText.setText("");
        //if(mVideoController != null){
        //	mVideoController.hide();
        //}

//	    	if(mActivity.m3uPlaylist != null && mActivity.m3uPlaylist.size() > 0 && mActivity.m3uplayindex < (mActivity.m3uPlaylist.size() - 1) && mActivity.m3uplayindex != -1){
//	    		mActivity.mHandler.post(mActivity.mPlayingChecker);
//	    		Uri uri = mActivity.m3uPlaylist.get(mActivity.m3uplayindex + 1);
//                mActivity.m3uplayindex++;
//                LOG(" Next m3u Uri = " + uri.toString());
//                pause();
//                StopPlay();
//                mActivity.setUri(uri);
//                setVideoURI(uri);
//                initStatus();
//	    	}else{
//	    		mActivity.m3uPlaylist = null;
//                mActivity.m3uplayindex = -1;

        Cursor cur = DBUtils.getNextCursor(mContext, mUri);
        if (!isVideoError && (cur != null || mUri.toString().startsWith("file://"))) {
            Uri AimUri;
            if (cur != null) {
                Uri uri = MediaStore.Video.Media.getContentUri("external");
                AimUri = Uri.withAppendedPath(uri, cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media._ID)));
                cur.close();
                cur = null;
            } else {
//    	    			AimUri = mUri;
                mActivity.finish();
                return;
            }
            LOG(" Next Uri = " + AimUri);
            pause();
            StopPlay();
            isEnableSeek = false;
            try {
                Thread.sleep(500);
            } catch (Exception e) {
            }
            mActivity.setUri(AimUri);
            setVideoURI(AimUri);
            initStatus();
        } else {
            if (cur != null) {
                cur.close();
                cur = null;
            }
            mActivity.finish();
        }
//	    	}

    }

    private void nextWithRepeatCheck() {
        if (mRepeatMode == sRepeatOne) {
            //hideController();
//	    		 if(mActivity.m3uPlaylist != null && mActivity.m3uPlaylist.size() > 0 && mActivity.m3uplayindex != -1){
//	    			 mActivity.mHandler.post(mActivity.mPlayingChecker);
//	    			 Uri uri = null;
//                     if(mActivity.m3uplayindex == (mActivity.m3uPlaylist.size() - 1)){
//                             uri = mActivity.m3uPlaylist.get(0);
//                             mActivity.m3uplayindex = 0;
//                     }else{
//                             uri = mActivity.m3uPlaylist.get(mActivity.m3uplayindex + 1);
//                             mActivity.m3uplayindex++;
//                     }
//
//                     LOG("nextWithRepeatCheck m3u Uri = " + uri.toString());
//                     pause();
//					 StopPlay();
//					 mActivity.setUri(uri);
//					 setVideoURI(uri);
//					 initStatus();
//	    		 }else{
//	    			 mActivity.m3uPlaylist = null;
//                     mActivity.m3uplayindex = -1;

            Cursor cur = DBUtils.getCurrentCursor(mContext, mUri);
            if (cur != null || mUri.toString().startsWith("file://")) {
                if (cur != null) {
                    cur.close();
                    cur = null;
                }
                pause();
                StopPlay();
                mActivity.setUri(mUri);
                setVideoURI(mUri);
                initStatus();
            } else {
                mActivity.finish();
//     		    		android.os.Process.killProcess(android.os.Process.myPid());
            }
//	    		 }
        }
    }

    public int getDuration() {
        if (mMediaPlayer != null && mIsPrepared) {
            if (mDuration > 0) {
                return mDuration;
            }
            mDuration = mMediaPlayer.getDuration();
            return mDuration;
        }
        mDuration = -1;
        return mDuration;
    }

    public int getCurrentPosition() {
        if (mMediaPlayer != null && mIsPrepared) {
            return mMediaPlayer.getCurrentPosition();
        }
        return -1;
    }

    public void seekTo(int msec) {
        LOG("seekto mIsPrepared = " + mIsPrepared);
        if (mMediaPlayer != null && mIsPrepared) {
            try {
                mMediaPlayer.seekTo(msec);
                mSeekWhenPrepared = 0;
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        if (mMediaPlayer != null && mIsPrepared) {
            return mMediaPlayer.isPlaying();
        }
        return false;
    }

    public boolean isDismiss() {
        if (mMediaPlayer != null)
            return mMediaPlayer.isPlaying();
        else
            return false;
    }

    /*���������صİٷֱ�*/
    public int getBufferPercentage() {
        if (mMediaPlayer != null) {
            return mCurrentBufferPercentage;
        }
        return 0;
    }

    public Uri getCurrentUri() {
        return mUri;
    }

    public int setScreenBright(int ScreenBright) {
        return 0;
    }

    Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case BookmarkCheckDialog_FADE_OUT:
                    LOG("handleMessage bookmarkcheckdialog_fade_out BookmarkCheckDialog=" + BookmarkCheckDialog);
                    if (mMediaPlayer != null && mIsPrepared && BookmarkCheckDialog != null) {
                        BookmarkCheckDialog.dismiss();
                    }
                    break;

            }
        }
    };
    private float WHdegree = 0.0f;

    public void setScreenSize(int width, int height) {
        LOG("Enter setScreenSize() and width = " + width + " height = " + height + " sMaxWidth=" + sMaxWidth + " sMaxHeight=" + sMaxHeight);
        //getHolder().setFixedSize(0x28062806, 0x28062806); //enable size changed
        getHolder().setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);
        mHandler.postDelayed(null, 100);

        if (width > sMaxWidth) {
            width = sMaxWidth;
        }
        if (height > sMaxHeight) {
            height = sMaxHeight;
        }
//
        LOG("------1--------Enter setFixedSize() and width = " + width + " height = " + height);
        getHolder().setFixedSize(sMaxWidth, sMaxHeight);
        WHdegree = width / (float) height;
        mVideoWidth = width;
        mVideoHeight = height;
        LOG("setScreenSize : setFixedSize() EXE");
    }

    public int setScreenMode(int ScreenMode) {
        int maxWidth = sMaxWidth;
        int maxHeight = sMaxHeight;
        LOG("maxWidth / maxHeight = " + maxWidth + "/ " + maxHeight);
        LOG(">>>>>>>ScreenMode:=" + ScreenMode);
//		    String hashCode = String.valueOf(getCurrentUri().hashCode());
        switch (ScreenMode) {
            case VideoController.SCREEN_MODE_ORIGINAL:
//	    		if(ConfigUtil.FULLSCREEN_MAINTIANXY){
                if (null == mMediaPlayer) {
                    Log.d("ljh", "-----------------------------case 0: mMediaPlayer is null");
                    break;
                }
                if (true) {
                    if (mMediaPlayer.getVideoWidth() > maxWidth || mMediaPlayer.getVideoHeight() > maxHeight) {
                        float degree = (float) mMediaPlayer.getVideoWidth() / (float) mMediaPlayer.getVideoHeight();
                        int tmpWidth1 = maxWidth;
                        int tmpHeight1 = (int) (tmpWidth1 / degree);

                        int tmpHeight2 = maxHeight;
                        int tmpWidth2 = (int) (tmpHeight2 * degree);

                        int finalWidth = 0;
                        int finalHeight = 0;

                        LOG("degree1:" + degree + " tmpWidth1:" + tmpWidth1 + " tmpHeight1:" + tmpHeight1 + " mMediaPlayer.getVideoWidth():" + mMediaPlayer.getVideoWidth() + " mMediaPlayer.getVideoHeight():" + mMediaPlayer.getVideoHeight());
                        LOG("degree2:" + degree + " tmpWidth2:" + tmpWidth2 + " tmpHeight2:" + tmpHeight2);
                        if (tmpHeight1 > maxHeight && tmpWidth2 <= maxWidth) {
                            LOG("set fullscreen1: will set to :" + tmpWidth2 + " x " + tmpHeight2);
                            finalWidth = tmpWidth2;
                            finalHeight = tmpHeight2;
                        } else if (tmpWidth2 > maxWidth && tmpHeight1 <= maxHeight) {
                            LOG("set fullscreen2: will set to :" + tmpWidth1 + " x " + tmpHeight1);
                            finalWidth = tmpWidth1;
                            finalHeight = tmpHeight1;
                        } else if (tmpHeight1 <= maxHeight && tmpWidth2 <= maxWidth) {
                            if (tmpWidth1 * tmpHeight1 > tmpWidth2 * tmpHeight2) {
                                LOG("set fullscreen3: will set to :" + tmpWidth1 + " x " + tmpHeight1);
                                finalWidth = tmpWidth1;
                                finalHeight = tmpHeight1;
                            } else {
                                LOG("set fullscreen4: will set to :" + tmpWidth2 + " x " + tmpHeight2);
                                finalWidth = tmpWidth2;
                                finalHeight = tmpHeight2;
                            }
                        } else {
                            finalWidth = maxWidth;
                            finalHeight = maxHeight;
                        }
                        setScreenSize(finalWidth, finalHeight);
                    } else {
                        //针对某些视频在缩放模式下获取的原始大小为0导致黑屏
                        if (mMediaPlayer.getVideoWidth() == 0 && mMediaPlayer.getVideoHeight() == 0) {
                            setScreenSize(maxWidth / 2, maxHeight / 2);
                        } else {
                            setScreenSize(mMediaPlayer.getVideoWidth(), mMediaPlayer.getVideoHeight());
                        }
                    }
                } else {
                    setScreenSize(mMediaPlayer.getVideoWidth(), mMediaPlayer.getVideoHeight());
                }

                break;
            case VideoController.SCREEN_MODE_169:
                if (maxWidth * 9 > maxHeight * 16) {
                    setScreenSize(maxHeight * 16 / 9, maxHeight);
                } else {
                    setScreenSize(maxWidth, maxWidth / 16 * 9);
                }
//	    		setScreenSize(maxWidth,maxWidth/16*9);
                break;
            case VideoController.SCREEN_MODE_43:
                if (maxWidth * 3 > maxHeight * 4) {
                    setScreenSize(maxHeight / 3 * 4, maxHeight);
                } else {
                    setScreenSize(maxWidth, maxWidth / 4 * 3);
                }
//	    		setScreenSize(maxHeight/3*4,maxHeight);
                break;
            case VideoController.SCREEN_MODE_FULL:
                if (mMediaPlayer == null) {
                    Log.d("ljh", "-----------------------------case 3: mMediaPlayer is null");
                    break;
                }
                if (mMediaPlayer.getVideoWidth() == 0 || mMediaPlayer.getVideoHeight() == 0) {
                    LOG("+++++++++++++++++++++ERROR:" + mMediaPlayer.getVideoWidth() + "*" + mMediaPlayer.getVideoHeight());
                    setScreenSize(maxWidth, maxHeight);
                    break;
                }

                if (ConfigUtil.FULLSCREEN_MAINTIANXY) {
                    float degree = (float) mMediaPlayer.getVideoWidth() / (float) mMediaPlayer.getVideoHeight();
                    int tmpWidth1 = maxWidth;
                    int tmpHeight1 = (int) (tmpWidth1 / degree);

                    int tmpHeight2 = maxHeight;
                    int tmpWidth2 = (int) (tmpHeight2 * degree);

                    int finalWidth = 0;
                    int finalHeight = 0;

                    LOG("degree1:" + degree + " tmpWidth1:" + tmpWidth1 + " tmpHeight1:" + tmpHeight1 + " mMediaPlayer.getVideoWidth():" + mMediaPlayer.getVideoWidth() + " mMediaPlayer.getVideoHeight():" + mMediaPlayer.getVideoHeight());
                    LOG("degree2:" + degree + " tmpWidth2:" + tmpWidth2 + " tmpHeight2:" + tmpHeight2);
                    if (tmpHeight1 > maxHeight && tmpWidth2 <= maxWidth) {
                        LOG("set fullscreen1: will set to :" + tmpWidth2 + " x " + tmpHeight2);
                        finalWidth = tmpWidth2;
                        finalHeight = tmpHeight2;
                    } else if (tmpWidth2 > maxWidth && tmpHeight1 <= maxHeight) {
                        LOG("set fullscreen2: will set to :" + tmpWidth1 + " x " + tmpHeight1);
                        finalWidth = tmpWidth1;
                        finalHeight = tmpHeight1;
                    } else if (tmpHeight1 <= maxHeight && tmpWidth2 <= maxWidth) {
                        if (tmpWidth1 * tmpHeight1 > tmpWidth2 * tmpHeight2) {
                            LOG("set fullscreen3: will set to :" + tmpWidth1 + " x " + tmpHeight1);
                            finalWidth = tmpWidth1;
                            finalHeight = tmpHeight1;
                        } else {
                            LOG("set fullscreen4: will set to :" + tmpWidth2 + " x " + tmpHeight2);
                            finalWidth = tmpWidth2;
                            finalHeight = tmpHeight2;
                        }
                    } else {
                        finalWidth = maxWidth;
                        finalHeight = maxHeight;
                    }
                    setScreenSize(finalWidth, finalHeight);
                } else {
                    setScreenSize(maxWidth, maxHeight);
                }

                break;
        }

        return 0;
    }

    public boolean Capture() {
        return true;
    }

    private Toast mToast = null;
    private static final int ADDBMSUCCESS = 0x0007;
    private static final int ADDBMFAIL = 0x0008;
    private Handler toastHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            if (mToast != null)
                mToast.cancel();

            switch (msg.what) {
                case ADDBMSUCCESS:
                    mToast = Toast.makeText(mContext, R.string.addbookmark_sucess, Toast.LENGTH_SHORT);
                    mToast.show();
                    break;

                case ADDBMFAIL:
                    mToast = Toast.makeText(mContext, R.string.addbookmark_false, Toast.LENGTH_SHORT);
                    mToast.show();
                    break;
            }


        }
    };

    public void setBookmark(final int bookmark) {
        if (mMediaPlayer == null || !mIsPrepared) {
            return;
        }
        new Runnable() {
            public void run() {
                LOG("Enter setBookmark()");
                //pause();
                Cursor cur = DBUtils.getCurrentCursor(mContext, mUri);
                if (cur == null) {
                    Toast.makeText(mContext, R.string.bookmark_error, Toast.LENGTH_SHORT).show();
                    return;
                }
                String videopath = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
                LOG("Cur = " + cur);
                if (cur != null) {
                    if (DBUtils.setBookmark(mContext, cur, bookmark)) {
                        cur.close();
                        if (toastHandler != null) {
                            toastHandler.removeMessages(ADDBMSUCCESS);
                            toastHandler.removeMessages(ADDBMFAIL);
                            toastHandler.sendEmptyMessage(ADDBMSUCCESS);
                            if (!bookmarkvideo.contains(videopath))
                                bookmarkvideo.add(videopath);
                        }

                    } else {
                        cur.close();
                        if (toastHandler != null) {
                            toastHandler.removeMessages(ADDBMSUCCESS);
                            toastHandler.removeMessages(ADDBMFAIL);
                            toastHandler.sendEmptyMessage(ADDBMFAIL);
                        }

                    }
                    cur = null;
                } else {
                    if (toastHandler != null) {
                        toastHandler.removeMessages(ADDBMSUCCESS);
                        toastHandler.removeMessages(ADDBMFAIL);
                        toastHandler.sendEmptyMessage(ADDBMFAIL);
                    }

                }
            }
        }.run();
        //start();
        //mActivity.setBookmark(bookmark);
        //mSeekWhenPrepared = bookmark;
    }

    public void setActivity(VideoPlayActivity newactivity) {
        mActivity = newactivity;
    }

    public int getDefaultWidth() {
        if (mMediaPlayer == null) {
            return -1;
        }
        return mMediaPlayer.getVideoWidth();
    }

    public int getDefaultHeight() {
        if (mMediaPlayer == null) {
            return -1;
        }
        return mMediaPlayer.getVideoHeight();
    }

    public void Finish() {
        if (mMediaPlayer != null) {

//	            if (mVideoController != null) {
//	                mVideoController.hide();
//	            }

//	            long starttime = System.currentTimeMillis();
            // mMediaPlayer.pause();
            System.out.println("+++++++++++++++++++++++++++++++++mMediaPlayer.pause() ms");
//	            starttime = System.currentTimeMillis();
            //  StopPlay();
            //System.out.println("+++++++++++++++++++++++++++++++++StopPlay():" + (System.currentTimeMillis() - starttime) + " ms");
//	            starttime = System.currentTimeMillis();
//	            android.os.Process.killProcess(android.os.Process.myPid());
            mActivity.finish();
            //System.out.println("+++++++++++++++++++++++++++++++++mActivity.finish():" + (System.currentTimeMillis() - starttime) + " ms");
        }
    }

    public void deleteBookmark() {
        DBUtils.deleteBookmark(mContext, mUri);
    }

    public void DisplayHelpView() {
        if (ConfigUtil.IS_PAUSE_ONDIALOG) {
            if (mMediaPlayer.isPlaying())
                mMediaPlayer.pause();
        }

        mActivity.DisplayHelpView();
    }

    public void PlayFormBeginning() {
        if (DBUtils.isBookmarkNull(mContext, mUri)) {
            Toast.makeText(mContext, R.string.deletebookmark_fail, Toast.LENGTH_SHORT).show();
            return;
        }

        DBUtils.deleteBookmark(mContext, mUri);
        if (mMediaPlayer != null && mIsPrepared) {
            if (!mMediaPlayer.isPlaying()) {
                start();
            }
            mMediaPlayer.seekTo(0);
        } else {
            mActivity.finish();
            Intent intent = new Intent(Intent.ACTION_VIEW, mUri);
            intent.setClass(mActivity, VideoPlayActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            mActivity.startActivity(intent);
        }
//	    	hh.removeMessages(1);
//	    	StopPlay();
//	    	hh.sendEmptyMessageDelayed(1, 200);
    }

    //	    private Handler hh = new Handler(){
//			@Override
//			public void handleMessage(Message msg) {
//				switch (msg.what) {
//				case 1:
//					setVideoURI(mUri);
//					break;
//				}
//			}
//	    };
    Runnable checkBookmarkRunnable = new Runnable() {

        public void run() {
            // TODO Auto-generated method stub
            CheckIfHaveBookmark();
        }

    };

    public void CheckIfHaveBookmark() {
        LOG("<-----------checkIfHaveBookmark----------->");
        mActivity.dismissLoading();
        if (mMediaPlayer != null && mIsPrepared) {
            if (mPlayTime != null && mPlayTime > 0) {
                if (mVideoController != null) {
                    mVideoController.hide();
                }

                if (ConfigUtil.IS_ENTERPLAY_SHOW_BOOKMARK) {
                    LOG("<--------------------checkIfHaveBookmark-BookmarkCheckDialog=" + BookmarkCheckDialog + "--------------->");
                    if (BookmarkCheckDialog == null) {

                        mHandler.removeMessages(BookmarkCheckDialog_FADE_OUT);
                        if (mMediaPlayer != null && mIsPrepared) {
                            BookmarkCheckDialog = new AlertDialog.Builder(mContext, AlertDialog.THEME_HOLO_LIGHT)
                                    .setTitle(R.string.VideoView_playfromchoice_title)
                                    .setPositiveButton(R.string.VideoView_playfrom_beginning, new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int whichButton) {
                                            dialog.dismiss();
                                        }
                                    })
                                    .setNegativeButton(R.string.VideoView_playfrom_bookmark, new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int whichButton) {
                                            mMediaPlayer.seekTo(mPlayTime);
                                            dialog.dismiss();
                                        }
                                    }).show();
                            BookmarkCheckDialog.setOnDismissListener(new OnDismissListener() {
                                @Override
                                public void onDismiss(DialogInterface dialog) {
                                    setSystemUiVisibility(SYSTEM_UI_FLAG_HIDE_NAVIGATION);
                                }
                            });
                            Message msg = mHandler.obtainMessage(BookmarkCheckDialog_FADE_OUT);
                            mHandler.sendMessageDelayed(msg, 5000);
                        }
                    } else {
                        Message msg = mHandler.obtainMessage(BookmarkCheckDialog_FADE_OUT);
                        mHandler.sendMessageDelayed(msg, 5000);
                        BookmarkCheckDialog.show();
                    }
                } else {
                    mMediaPlayer.seekTo(mPlayTime);
                }


            }
        }
    }

    public void setDisableWhen3gp(boolean ifTrue) {
        isNet3gp = true;
    }

    /*	View.OnClickListener fullscreenListener = new View.OnClickListener(){
            public void onClick(View v) {
                //modified by huangm 2010-07-30
//				if(mEnable){
                    toggleMediaControlsVisiblity();
                    //mVideoController.setShortClickButtonDisable();
//				}
            }
        };*/
    public void setEnable(boolean mode) {
        mEnable = mode;
    }

    public boolean isSeekComplete() {
        return mSeekComplete;
    }

    public void setSeekComplete(boolean mode) {
        mSeekComplete = false;
    }

    public void hideController() {
        if (mVideoController != null) {
            mVideoController.hide();
            //mStatusBar.hide();
        }
    }

    public void initStatus() {
        mEnable = true;
        mSeekComplete = true;
			/*��ʼ��seektime��ֵ*/
        mVideoController.mSeekTime = 0;
        mSetScreebSizeClicked = false;
    }

    private int[] AdjustSize(int width, int height) {
        int a[] = new int[2];
        if (sMaxWidth * height > width * sMaxHeight) {
//	                Log.i("@@@", "image too tall, correcting");
            height = width * sMaxHeight / sMaxWidth;
        } else if (sMaxWidth * height < width * sMaxHeight) {
//	                Log.i("@@@", "image too wide, correcting");
            width = height * sMaxWidth / sMaxHeight;
        } else {
//	                Log.i("@@@", "aspect ratio is correct: " +
//	                        width+"/"+height+"="+
//	                        sMaxWidth+"/" + sMaxHeight);
        }
        a[0] = width;
        a[1] = height;
        return a;
    }


    public void DisplayRepeat() {
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
            private int index = -1;

            @Override
            public void onClick(DialogInterface arg0, int arg1) {
                // TODO Auto-generated method stub
                if (arg1 >= 0) {
                    index = arg1;
                } else if (arg1 == DialogInterface.BUTTON_POSITIVE && index != -1) {
                    LOG("<---------repeatMode=" + mRepeatMode + "-------------->");
                    mRepeatMode = index;
                    StoreRepeatMode(mRepeatMode);
                    mMediaPlayer.start();
                }
            }
        };
        if (null != mRepeatModeDialog) {
            mRepeatModeDialog.cancel();
        }
        mRepeatModeDialog = new AlertDialog.Builder(getContext()).setTitle(R.string.selection_repeatmode_title)
                .setSingleChoiceItems(
                        R.array.RepeatMode, mRepeatMode, listener)
                .setPositiveButton(R.string.yes, listener)
                .setNegativeButton(R.string.no, null).show();
        mRepeatModeDialog.setOnDismissListener(this);
    }

    private void StoreRepeatMode(int mode) {
        SharedPreferences settings = mContext.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt("RepeatMode", mode);
        editor.commit();
    }

    private int GetRepeatMode() {
        SharedPreferences settings = mContext.getSharedPreferences(PREFS_NAME, 0);
        int mode = settings.getInt("RepeatMode", sRepeatAll);
        return mode;
    }

    public int getRepeatMode() {
        // TODO Auto-generated method stub
        return mRepeatMode;
    }

    public void SetScreenSizeClickMode(boolean mode) {
        mSetScreebSizeClicked = mode;
    }


    public void hideMediaControls() {
        if (mVideoController.isShowing()) {
            mVideoController.hide();
        }
    }

    public int getBrightMode() {
        return mActivity.mBrightMode;
    }

    public int getVolumeMode() {
        return mActivity.mVolumeMode;
    }

    //
    public void DisplayHdmi() {
        // TODO Auto-generated method stub
        mActivity.DisplayHdmi();
    }
    //

    //
    public void DisplayTvout() {
        // TODO Auto-generated method stub
        mActivity.DisplayTvout();
    }
    //

    public VideoController getVideoController() {
        return mVideoController;
    }

    @Override
    public void onClick(View v) {
        // TODO Auto-generated method stub
        LOG("VideoDisplayView:onClick");
        toggleMediaControlsVisiblity();
    }

    private static String SUBTITLE_FLAG = "Subtitle";
    private static String AUDIOTRACK_FLAG = "AudioTrack";

    @Override
    public void setSubtitle() {
        // TODO Auto-generated method stub
        LOG("<-----------setSubtitle------------>" + mCurrentSelectSubTrkIdx);
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
            private int index = mCurrentSelectSubTrkIdx;

            @Override
            public void onClick(DialogInterface arg0, int arg1) {
                // TODO Auto-generated method stub
                if (arg1 >= 0) {
                    index = arg1;
                    LOG("<-----------choice the subtitle whitch=" + arg1 + "----------------->");
                } else if (arg1 == DialogInterface.BUTTON_POSITIVE) {
                    //save the choice
                    //clear the pre subtitle
                    clearAllMsg();
                    mActivity.subtitleHandler.sendEmptyMessage(VideoPlayActivity.HIDE_SUBTITLE);
                    //if(mCurrentSelectSubTrkIdx != index){
                    mCurrentSelectSubTrkIdx = index;
                    if (info == null || info.getSubIndexMap() == null
                            || info.getSubIndexMap().size() == 0) {
                        return;
                    }
                    int realIndex = info.getSubIndexMap().get(index);
//						 Log.v(TAG,"select to new subtitle track: " + mCurrentSelectSubTrkIdx);
                    DBUtils.storeValue(mActivity, SUBTITLE_FLAG + mUri.toString(), mCurrentSelectSubTrkIdx);
                    mMediaPlayer.selectTrack(realIndex);
                    //}
                }
            }
        };


        Object[] typeObject = info.getSubtitles().toArray();
        String[] type = new String[typeObject.length];
        for (int i = 0; i < type.length; i++) {
            type[i] = (String) typeObject[i];
        }
        if (null != mSubTrkDialog) {
            mSubTrkDialog.cancel();
        }
        mSubTrkDialog = new AlertDialog.Builder(getContext()).setTitle(R.string.Subtitle_Select)
                .setSingleChoiceItems(
                        type, mCurrentSelectSubTrkIdx, listener)
                .setPositiveButton(R.string.yes, listener)
                .setNegativeButton(R.string.no, null).show();
        mSubTrkDialog.setOnDismissListener(this);
    }

    @Override
    public void setSelectSubDialog() {
        LOG("<-----------setSelectSubDialog------------>");
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
            private int index = mCurrentSelectShowSubFirst;

            @Override
            public void onClick(DialogInterface arg0, int arg1) {
                if (arg1 >= 0) {
                    index = arg1;
                } else if (arg1 == DialogInterface.BUTTON_POSITIVE) {
                    mCurrentSelectShowSubFirst = index;
                    DBUtils.storeValue(mActivity, SELELCT_SUB_TYPE, mCurrentSelectShowSubFirst);
                }
            }
        };


        String[] type = new String[2];
        type[0] = mContext.getResources().getText(R.string.External_Sub_title).toString();
        type[1] = mContext.getResources().getText(R.string.embedded_Sub_title).toString();
        if (null != mShowSubDialog) {
            mShowSubDialog.cancel();
        }
        mShowSubDialog = new AlertDialog.Builder(getContext()).setTitle(R.string.Select_Sub_title)
                .setSingleChoiceItems(
                        type, mCurrentSelectShowSubFirst, listener)
                .setPositiveButton(R.string.yes, listener)
                .setNegativeButton(R.string.no, null).show();
        mShowSubDialog.setOnDismissListener(this);
    }

    @Override
    public void updatePlayPauseStatus(boolean play) {
        mActivity.updatePlayingWhenPaused(play);
    }

    @Override
    public void refreshWindow() {
        if (null != mActivity) {
            mActivity.refreshWindow();
        }
    }

    @Override
    public void setAudioTrack() {
        // TODO Auto-generated method stub
        LOG("<--------------setAudioTrace------->" + mCurrentSelectAudioTrackIdx);
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
            private int index = mCurrentSelectAudioTrackIdx;

            @Override
            public void onClick(DialogInterface arg0, int arg1) {
                // TODO Auto-generated method stub
                if (arg1 >= 0) {
                    index = arg1;
                    LOG("<-----------choice the subtitle whitch=" + arg1 + "----------------->");
                } else if (arg1 == DialogInterface.BUTTON_POSITIVE) {
                    //save the choice
                    //if(mCurrentSelectAudioTrackIdx != index){
                    mCurrentSelectAudioTrackIdx = index;
//						Log.v(TAG,"select to new Audio track: " + mCurrentSelectAudioTrackIdx);
                    if (info == null || info.getTraIndexMap() == null
                            || info.getTraIndexMap().size() == 0) {
                        return;
                    }
                    int realIndex = info.getTraIndexMap().get(index);
                    DBUtils.storeValue(mActivity, AUDIOTRACK_FLAG + mUri.toString(), mCurrentSelectAudioTrackIdx);
                    mMediaPlayer.selectTrack(realIndex);
                    //}
                }
            }
        };

        Object[] typeObject = info.getTrack().toArray();
        String[] type = new String[typeObject.length];
        for (int i = 0; i < type.length; i++) {
            type[i] = (String) typeObject[i];
        }
        if (null != mAudioTrackDialog) {
            mAudioTrackDialog.cancel();
        }
        mAudioTrackDialog = new AlertDialog.Builder(getContext()).setTitle(R.string.Audio_Track_Select)
                .setSingleChoiceItems(
                        type, mCurrentSelectAudioTrackIdx, listener)
                .setPositiveButton(R.string.yes, listener)
                .setNegativeButton(R.string.no, null).show();
        mAudioTrackDialog.setOnDismissListener(this);
    }

    @Override
    public void playWindow() {
        LOG("playwindow");
        Intent intent = new Intent("com.rk.app.mediafloat.CUSTOM_ACTION");
        intent.setPackage("com.android.rk.mediafloat");
        intent.setClassName("com.android.rk.mediafloat", "com.android.rk.mediafloat.MediaFloatService");
        LOG("-------playWindow----------mUri:" + mUri);
        intent.putExtra("URI", mUri.toString());
        intent.putExtra("POSITION", getCurrentPosition());
        mActivity.startService(intent);
        mActivity.Finish();
    }

    private float mLeft = 0.0f;
    private float mTop = 0.0f;
    private boolean isZoomIn_X = false;
    private boolean isZoomIn_Y = false;

    public void setScreenSizeScale(float scale) {
        int scaleWidth = (int) (mVideoWidth * scale);
        int scaleHeight = (int) (mVideoHeight * scale);
        if (scaleWidth > sMaxWidth * 3) {
            scaleWidth = sMaxWidth * 3;
        }
        if (scaleHeight > sMaxHeight * 3) {
            scaleHeight = sMaxHeight * 3;
        }
        if (scaleWidth < sMaxWidth / 4 || scaleHeight < sMaxHeight / 4) {
            return;
        }
//		if(WHdegree > 0){
        float fx = scaleWidth / (float) scaleHeight;
        if (fx > WHdegree) {
            scaleWidth = (int) (scaleHeight * WHdegree);
        } else {
            scaleHeight = (int) (scaleWidth / WHdegree);
        }
//		}

        mLeft *= scaleWidth / (float) mVideoWidth;
        mTop *= scaleHeight / (float) mVideoHeight;
        mVideoWidth = scaleWidth;
        mVideoHeight = scaleHeight;
        if (mVideoWidth <= sMaxWidth) {
            isZoomIn_X = false;
        }
        if (mVideoHeight <= sMaxHeight) {
            isZoomIn_Y = false;
        }
        center(isZoomIn_X, isZoomIn_Y);
    }

    public boolean isPrepare() {
        if (mIsPrepared && mMediaPlayer != null && mVideoController != null) {
            return true;
        }
        return false;
    }

    public void center(boolean zoomIn_X, boolean zoomIn_Y) {
        if (!zoomIn_X) {
            mLeft = (sMaxWidth - mVideoWidth) / 2;
        }
        if (!zoomIn_Y) {
            mTop = (sMaxHeight - mVideoHeight) / 2;
        }
        if (mVideoWidth > sMaxWidth) {
//			if (mLeft + mVideoWidth < sMaxWidth) {
//				mLeft = sMaxWidth - mVideoWidth;
//			}
//			if (mLeft > 0.0f) {
//				mLeft = 0.0f;
//			}
        } else {
            mLeft = (sMaxWidth - mVideoWidth) / 2;
        }
        if (mVideoHeight > sMaxHeight) {
//			if (mTop + mVideoHeight < sMaxHeight) {
//				mTop = sMaxHeight - mVideoHeight;
//			}
//            if (mTop > 0.0f) {
//				mTop = 0.0f;
//			}
        } else {
            mTop = (sMaxHeight - mVideoHeight) / 2;
        }

        this.requestLayout();
    }

    public void setOffset(float dx, float dy) {
        if (mVideoWidth <= sMaxWidth && mVideoHeight <= sMaxHeight) {
            return;
        }
        mLeft -= dx;
        mTop -= dy;

        if (mVideoWidth > sMaxWidth) {
            isZoomIn_X = true;
        } else {
            mLeft = (sMaxWidth - mVideoWidth) / 2;
            isZoomIn_X = false;
        }
        if (mVideoHeight > sMaxHeight) {
            isZoomIn_Y = true;
        } else {
            mTop = (sMaxHeight - mVideoHeight) / 2;
            isZoomIn_Y = false;
        }
        this.requestLayout();
    }

    private int tmpXstep[] = new int[100];
    private int tmpYstep[] = new int[100];
    private int stepcountX = 0;
    private int stepcountY = 0;

    public void onFlingOffset() {
        if (mVideoWidth > sMaxWidth) {
            if (mLeft > 0) {
                stepcountX = FlingDataUtil.getTransAnimationFlingData(0 - mLeft, 200, 1, tmpXstep);
            } else if (mLeft + mVideoWidth < sMaxWidth) {
                stepcountX = FlingDataUtil.getTransAnimationFlingData(sMaxWidth - mVideoWidth - mLeft, 200, 1, tmpXstep);
            }
        }
        if (mVideoHeight > sMaxHeight) {
            if (mTop > 0) {
                stepcountY = FlingDataUtil.getTransAnimationFlingData(0 - mTop, 200, 1, tmpYstep);
            } else if (mTop + mVideoHeight < sMaxHeight) {
                stepcountY = FlingDataUtil.getTransAnimationFlingData(sMaxHeight - mVideoHeight - mTop, 200, 1, tmpYstep);
            }
        }
        flingHandler.sendEmptyMessage(FLING_MSG);
    }

    private static final int FLING_MSG = 0x01;
    private Handler flingHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case FLING_MSG:
                    boolean isContinue = false;
                    if (stepcountX > 0) {
                        float dx = tmpXstep[0];
                        if (stepcountX > 1) {
                            dx = tmpXstep[stepcountX - 1] - tmpXstep[stepcountX - 2];
                        }
                        mLeft += dx;
                        stepcountX -= 1;
                        isContinue = true;
                    }
                    if (stepcountY > 0) {
                        float dy = tmpYstep[0];
                        if (stepcountY > 1) {
                            dy = tmpYstep[stepcountY - 1] - tmpYstep[stepcountY - 2];
                        }
                        mTop += dy;
                        stepcountY -= 1;
                        isContinue = true;
                    }
                    VideoDisplayView.this.requestLayout();
                    if (isContinue) {
                        flingHandler.sendEmptyMessage(FLING_MSG);
                    }
                    break;
            }
        }

    };

    private OnAudioFocusChangeListener mAudioFocusListener = new OnAudioFocusChangeListener() {
        public void onAudioFocusChange(int focusChange) {
            if (mMediaPlayer == null) {
                // this activity has handed its MediaPlayer off to the next activity
                // (e.g. portrait/landscape switch) and should abandon its focus
                mAudioManager.abandonAudioFocus(this);
                return;
            }
            switch (focusChange) {
                case AudioManager.AUDIOFOCUS_LOSS:
                    mPausedByTransientLossOfFocus = false;
                    pause();
                    if (mVideoController != null)
                        mVideoController.show();
                    break;
                case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT:
                case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK:
                    if (mMediaPlayer.isPlaying()) {
                        mPausedByTransientLossOfFocus = true;
                        pause();
                        if (mVideoController != null)
                            mVideoController.show();
                    }
                    break;
                case AudioManager.AUDIOFOCUS_GAIN:
                    if (mPausedByTransientLossOfFocus) {
                        mPausedByTransientLossOfFocus = false;
                        start();
                        if (mVideoController != null)
                            mVideoController.hide();
                    }
                    break;
            }
        }
    };

    @Override
    public void layout(int l, int t, int r, int b) {
        int left = (int) mLeft;
        int top = (int) mTop;
        if (mVideoWidth <= sMaxWidth) {
            left = (sMaxWidth - mVideoWidth) / 2;
        }
        if (mVideoHeight <= sMaxHeight) {
            top = (sMaxHeight - mVideoHeight) / 2;
        }
        LOG("--------------layout------------------left:" + left + ",top:" + top + ",sMaxWidth:" + sMaxWidth + ",sMaxHeight:" + sMaxHeight + ",mVideoWidth:" + mVideoWidth + ",mVideoHeight:" + mVideoHeight);
        super.layout(left, top, mVideoWidth + left, mVideoHeight + top);
    }

    @Override
    public boolean isShowSubTitle() {
        if (mActivity.mSubTitleText != null
                && !mActivity.mSubTitleText.getText().toString().trim().equals(
                "")) {
            return true;
        }
        return false;

    }

    public boolean isDialogShowing() {
        if (null != BookmarkCheckDialog && BookmarkCheckDialog.isShowing()) {
            return true;
        }
        if (null != mRepeatModeDialog && mRepeatModeDialog.isShowing()) {
            return true;
        }
        if (null != mAudioTrackDialog && mAudioTrackDialog.isShowing()) {
            return true;
        }
        if (null != mSubTrkDialog && mSubTrkDialog.isShowing()) {
            return true;
        }
        if (null != mShowSubDialog && mShowSubDialog.isShowing()) {
            return true;
        }
        return false;
    }

    public void hideAllDialog() {
        if (null != BookmarkCheckDialog && BookmarkCheckDialog.isShowing()) {
            BookmarkCheckDialog.cancel();
        }
        if (null != mRepeatModeDialog && mRepeatModeDialog.isShowing()) {
            mRepeatModeDialog.cancel();
        }
        if (null != mAudioTrackDialog && mAudioTrackDialog.isShowing()) {
            mAudioTrackDialog.cancel();
        }
        if (null != mSubTrkDialog && mSubTrkDialog.isShowing()) {
            mSubTrkDialog.cancel();
        }
        if (null != mShowSubDialog && mShowSubDialog.isShowing()) {
            mShowSubDialog.cancel();
        }
    }

    public interface OnVideoViewListener {
        void displayCurrentVolume();
        void displaySubTitleView(boolean show);
    }
}
