/**
 *
 */
package android.rk.RockVideoPlayer;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;

/**
 * @author hm
 */
public class SubDBUtils {

    public static SQLiteDatabase subDatabase = null;
    public static String subTableName = null;

    public static void openDatabase(String databaseFilename, String tableName) {
        subTableName = tableName;
        subDatabase = SQLiteDatabase.openOrCreateDatabase(databaseFilename, null);
        subDatabase.execSQL("DROP TABLE IF EXITS " + tableName);
        subDatabase.execSQL("CREATE TABLE " + tableName + " (_starttime integer not null, _endtime integer not null, _content text)");
        subDatabase.execSQL("CREATE INDEX STARTTIME_INDEX ON " + tableName + "(_starttime);");
        subDatabase.execSQL("CREATE INDEX ENDTIME_INDEX ON " + tableName + "(_endtime);");
    }

    public static void insertSubTitle(int startTime, int endTime, String content) {
        ContentValues values = new ContentValues();
        values.put("_starttime", startTime);
        values.put("_endtime", endTime);
        values.put("_content", content);
        subDatabase.insertOrThrow(subTableName, null, values);
    }

    public static void closeDatabaseAndFree() {
        subDatabase.close();
        subDatabase = null;
        SQLiteDatabase.releaseMemory();
    }
}
