package android.rk.RockVideoPlayer;

import java.io.IOException;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnCompletionListener;
import android.media.MediaPlayer.OnPreparedListener;
import android.os.Handler;
import android.util.Log;

public class Player {
    private String TAG = "Player";
    private boolean DEBUG = false;

    private void LOG(String log) {
        if (DEBUG) {
            Log.d(TAG, log);
        }
    }

    private final int MSG_REPEAT = 0;

    private Context mContext;
    private int resourceId = -1;
    private boolean isRepeat = false;
    private MediaPlayer mMediaPlayer = null;

    public Player(Context c) {
        // TODO Auto-generated constructor stub
        this.mContext = c;
    }

    public void playBegin(int resid, boolean repeat) {
        isRepeat = repeat;
        if (isRepeat) {
            resourceId = resid;
        }
        try {
            mMediaPlayer = MediaPlayer.create(this.mContext, resid);
            mMediaPlayer.setOnCompletionListener(mOnCompletionListener);
            mMediaPlayer.setOnPreparedListener(mOnPreparedListener);
            mMediaPlayer.prepare();
        } catch (IllegalStateException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void playStopNow() {
//		playStop();
//		mMediaPlayer.reset();
////		if (mMediaPlayer.isPlaying()) {
//			mMediaPlayer.pause();
////		}
//		mMediaPlayer.release();
        playStop();
    }

    public void playStop() {
        isRepeat = false;
        mHandler.removeMessages(MSG_REPEAT);
    }

    OnPreparedListener mOnPreparedListener = new OnPreparedListener() {
        public void onPrepared(MediaPlayer mp) {
            // TODO Auto-generated method stub
            if (mMediaPlayer != null) {
                LOG("mMediaPlay != null");
                mMediaPlayer.start();
            }
        }

    };

    OnCompletionListener mOnCompletionListener = new OnCompletionListener() {
        public void onCompletion(MediaPlayer mp) {
            // TODO Auto-generated method stub
            LOG("Player completion---------------> !");
            if (mMediaPlayer != null) {
                mMediaPlayer.release();
            }
            if (isRepeat) {
                mHandler.sendEmptyMessage(MSG_REPEAT);
            } else {
                mMediaPlayer.release();
            }
        }

    };

    Handler mHandler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            switch (msg.what) {
                case MSG_REPEAT:
                    playBegin(resourceId, isRepeat);
                    break;

                default:
                    break;
            }
        }

        ;
    };
}
