/**
 *
 */
package android.rk.RockVideoPlayer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import android.net.Uri;
import android.util.Log;

/**
 * @author hm
 */
public class M3uUtil {
    public final static String USERAGENT_STR = "Mozilla/5.0 (iPad; U; CPU OS 3_2 like Mac OS X; en-us) AppleWebKit/531.21.10 (KHTML, like Gecko) Version/4.0.4 Mobile/7B334b Safari/531.21.10";

    private static boolean checkPlayListEntry(String entry, int index) {
        int entryLength = entry.length();
        while (entryLength > 0 && Character.isWhitespace(entry.charAt(entryLength - 1)))
            entryLength--;
        // path should be longer than 3 characters.
        // avoid index out of bounds errors below by returning here.
        if (entryLength < 3)
            return false;
        if (entryLength < entry.length())
            entry = entry.substring(0, entryLength);

        return true;
    }

    public static List<Uri> decodeM3u(String path) {
        List<Uri> uris = new ArrayList<Uri>();
        Log.v("m3u", "+++++++++++++++++++++start decode m3u: path:" + path);
        HttpURLConnection http;
        InputStream urlStream = null;
        BufferedReader reader = null;
        try {
            if (path.startsWith("http://") || (path.startsWith("https://"))) {
                URL url = new URL(path);
                http = (HttpURLConnection) url.openConnection();
                http.setRequestProperty("User-agent", USERAGENT_STR);
                http.connect();
                urlStream = http.getInputStream();
            } else {
                File f = null;
                if (path.startsWith("file://")) {
                    f = new File(path.replace("file://", ""));
                } else {
                    f = new File(path);
                }

                urlStream = new FileInputStream(f);
            }

            reader = new BufferedReader(new InputStreamReader(urlStream, "GB2312"));
            String line = reader.readLine();
            int index = 0;
            while (line != null) {
                // ignore comment lines, which begin with '#'
                if (line.length() > 0 && line.charAt(0) != '#') {
                    if (checkPlayListEntry(line, index)) {

//                    	URL url = new URL(line.trim());
//        				http = (HttpURLConnection) url.openConnection();
//        				http.setRequestProperty("User-agent", USERAGENT_STR);
//        				http.setInstanceFollowRedirects(false);
//        				http.connect();
//
//        				Log.v("m3u Response Code:", http.getURL() + " " + http.getResponseCode());
//        				Log.v("m3u Response:", http.getResponseMessage());
//                    	
//        				if(http.getResponseCode() == 302){
//        					uris.add(Uri.parse(http.getHeaderField("location")));
//        				}else if(http.getResponseCode() == 200){
                        uris.add(Uri.parse(line.trim()));
//        				}

                        index++;
//                        http.disconnect();
                    }
                }
                line = reader.readLine();
            }

        } catch (MalformedURLException e1) {
            e1.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (reader != null)
                    reader.close();

            } catch (IOException e) {
            }

            try {
                if (urlStream != null)
                    urlStream.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        return uris;
    }
}
