/**
 *
 */
package android.rk.RockVideoPlayer;

import java.io.File;

import android.util.Log;

/**
 * @author hm
 *         This class will auto fetch the caller class and caller method
 */
public class LogUtil {
    private static int CURRENT_LOG_LEVEL = Log.VERBOSE;
    private static boolean isDebugFileExist = false;
    private final static String LOGCLASSNAME = "android.rk.RockVideoPlayer.LogUtil";

    static {
        if (isDebugFileExist()) {
            isDebugFileExist = true;
            Log.v("LogUtil", "---------------------Log is enable----------------------");
        }
    }

    private static boolean isDebugFileExist() {
        File file = new File("/flash/rkvideodebug");
        if (file.exists())
            return true;
        else
            return false;
    }

    private static void invokeLog(String className, String methodName, int lineNumber, String logStr, Exception... ex) {
        String tag = "(" + className + "$" + methodName + ":" + lineNumber + ")";
        boolean isHasException = ex != null && ex.length > 0;
        switch (CURRENT_LOG_LEVEL) {
            case Log.INFO:
                if (!isHasException) {
                    Log.i(tag, logStr);
                } else {
                    Log.i(tag, logStr, ex[0]);
                }
                break;
            case Log.DEBUG:
                if (!isHasException) {
                    Log.d(tag, logStr);
                } else {
                    Log.d(tag, logStr, ex[0]);
                }
                break;
            case Log.VERBOSE:
                if (!isHasException) {
                    Log.v(tag, logStr);
                } else {
                    Log.v(tag, logStr, ex[0]);
                }
                break;
            case Log.ERROR:
                if (!isHasException) {
                    Log.e(tag, logStr);
                } else {
                    Log.e(tag, logStr, ex[0]);
                }
                break;
            default:
                break;
        }
    }

    @SuppressWarnings("unchecked")
    public final static void LOG(String logStr, Exception... ex) {
//		Log.v("LogUtil", logStr);
        StackTraceElement stack[] = (new Throwable()).getStackTrace();
        int ix = 0;
        StackTraceElement frame = null;
        String cname = null;
        String simpleName = null;
        Class destClass = null;
        while (ix < stack.length) {
            frame = stack[ix++];
            cname = frame.getClassName();
            simpleName = cname.substring(cname.lastIndexOf(".") + 1);
            try {
                destClass = Class.forName(cname);
            } catch (ClassNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            if (!LOGCLASSNAME.equals(cname) && destClass != null) {
                //1.At first, check class annontaion if the debug flag exist
                if (destClass.isAnnotationPresent(DebugAnno.class)) {
                    DebugAnno anno = (DebugAnno) destClass.getAnnotation(DebugAnno.class);
                    if (anno.isEnableDebug()) {
                        if (ex == null || ex.length == 0) {
                            invokeLog(simpleName, frame.getMethodName(), frame.getLineNumber(), logStr);
                        } else {
                            invokeLog(simpleName, frame.getMethodName(), frame.getLineNumber(), logStr, ex);
                        }
                    }//2.if annontaion debug flag is false but debug file is exist, force to print log info
                    else {
                        if (isDebugFileExist) {
                            if (ex == null || ex.length == 0) {
                                invokeLog(simpleName, frame.getMethodName(), frame.getLineNumber(), logStr);
                            } else {
                                invokeLog(simpleName, frame.getMethodName(), frame.getLineNumber(), logStr, ex);
                            }
                        }
                    }
                }//the debug flag not exist
                else {
                    if (isDebugFileExist) {
                        if (ex == null || ex.length == 0) {
                            invokeLog(simpleName, frame.getMethodName(), frame.getLineNumber(), logStr);
                        } else {
                            invokeLog(simpleName, frame.getMethodName(), frame.getLineNumber(), logStr, ex);
                        }
                    }
                }

                return;
            }
        }
    }
}
