package android.rk.RockVideoPlayer;

import android.graphics.Matrix;
import android.util.Log;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;

public class FlingDataUtil {

    private static final int DISTANCE = 100;

    public static int getTransAnimationFlingData(float distance,
                                                 long durationMillis, float factor, int[] flingData) {
        int flingDataCount = 0;
        TranslateAnimation animation = null;
        TranslateAnimation transAnimation = null;
        Transformation mTransformation = new Transformation();
        float[] params = new float[9];
        float dstPlace = 0;
        float curPlace = 0.0F;
        if (distance > 0) {
            curPlace = 0.0F;
            dstPlace = distance;
        } else {
            curPlace = distance;
            dstPlace = 0.0F;
        }
        animation = transAnimation = new TranslateAnimation(curPlace, dstPlace, 0, 0);

        if (Math.abs(distance) < DISTANCE) {
            durationMillis = (long) (Math.abs(distance) / (float) DISTANCE * durationMillis);
        }
        animation.setDuration(durationMillis);
        animation.setInterpolator(new DecelerateInterpolator(factor));
        animation.startNow();
        boolean more = true;
        long time = AnimationUtils.currentAnimationTimeMillis();// SystemClock.uptimeMillis();

        if (!transAnimation.isInitialized()) // initialize animation
            transAnimation.initialize(0, 0, 0, 0);
        while (more) {
//			if (transAnimation == null)
//				break;
            time += 20;
            more = transAnimation.getTransformation(time, mTransformation);
            Matrix matrix = mTransformation.getMatrix();
            matrix.getValues(params);
            float tmp = params[Matrix.MTRANS_X];
            if (tmp >= dstPlace) {
                tmp = dstPlace;
                transAnimation = null;
                int step = (int) (distance < 0 ? (curPlace - dstPlace) : (dstPlace - curPlace));
//				Log.v("===========", "==========="+step);
                flingData[flingDataCount] = step;
                flingDataCount++;
                break;
            }
            float temp = distance < 0 ? (curPlace - tmp) : (tmp - curPlace);
            int step = (int) temp;
//			Log.v("===========", "==========="+step);
            //curPlace = tmp;
            flingData[flingDataCount] = step;
            flingDataCount++;
        }

        flingData[flingDataCount] = distance > 0 ? ((int) distance + 2) : ((int) distance - 2);
        flingDataCount++;

        return flingDataCount;
    }
}
