package android.rk.RockVideoPlayer.ui;

import java.util.ArrayList;
import java.util.Random;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

public class seekbarmy extends View {
    private static final String TAG = "seekbarmy";
    private static final boolean DEBUG = false;

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        }
    }

    private final static int MAXSTART = 20;
    private final static int MAXWIDTH = 15;
    private final static int MINLEFT = 20;

    class StartPoint {
        int x = 0;
        int y = 0;
        float w = 0;
        int stepx = 0;
        int stepy = 0;
        Bitmap mbitmap = null;
        boolean availability = false;
    }

    private int mbgid;
    private int mpgid;
    private int mspgid;
    private int mstartid;
    private Context mContext;
    private Paint mPaint = null;
    private Drawable background;
    private Drawable progress;
    private Drawable secondProgress;
    private OnSeekBarMyChangeListener mOnSeekBarMyChangeListener;

    private int mMaxProgress = 100;
    private int currentProgress = 0;
    private int currentProgressSec = 0;

    private int progressheight = 30;
    private int progresstop = -1;

    ArrayList<StartPoint> mStartPoints = new ArrayList<StartPoint>();
    private Bitmap startBitmap = null;
    private static Random random = new Random(50);
    private seekbarmy mseekbarmy = null;

    public seekbarmy(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mPaint = new Paint();
        this.mseekbarmy = this;
        for (int i = 0; i < MAXSTART; i++) {
            mStartPoints.add(new StartPoint());
        }
    }

    public void setMax(int max) {
        this.mMaxProgress = max;
    }

    public void setBitmapResource(int bgid, int pgid, int spgid, int startid) {
        if (bgid > 0) {
            this.mbgid = bgid;
            background = mContext.getResources().getDrawable(bgid);
        }
        if (pgid > 0) {
            this.mpgid = pgid;
            progress = mContext.getResources().getDrawable(pgid);
        }
        if (spgid > 0) {
            this.mspgid = spgid;
            secondProgress = mContext.getResources().getDrawable(spgid);
        }
        if (startid > 0) {
            this.mstartid = startid;
            Drawable tmp = mContext.getResources().getDrawable(startid);
            startBitmap = ((BitmapDrawable) tmp).getBitmap();
        }
    }

    public void setOnSeekBarMyChangeListener(OnSeekBarMyChangeListener onseekbarmychangelistener) {
        this.mOnSeekBarMyChangeListener = onseekbarmychangelistener;
    }

    public void setProgress(int progress) {
        this.currentProgress = progress;
        invalidate();
    }

    public int getProgress() {
        return this.currentProgress;
    }

    public void setSecondaryProgress(int secprogress) {
        this.currentProgressSec = secprogress;
    }

    @Override
    protected void onDraw(Canvas canvas) {
//		super.onDraw(canvas);
        if (progresstop < 0)
            progresstop = (getHeight() - progressheight) / 2;

        int baseleft = currentProgress * (getWidth() - MINLEFT) / mMaxProgress;
        LOG("   onDraw(),   progresstop = " + progresstop + "   currentProgress = " + currentProgress);
        if (background == null) {
            Log.e(TAG, " ---------> onDraw(),   background = null~~");
            background = mContext.getResources().getDrawable(mbgid);
        }
        background.setBounds(0, progresstop + 3, getWidth(), progresstop + 3 + progressheight);
        background.draw(canvas);
        baseleft += MINLEFT;
        if (progress == null) {
            Log.e(TAG, " ---------> onDraw(),   progress = null~~");
            progress = mContext.getResources().getDrawable(mpgid);
        }
        progress.setBounds(0, progresstop + 2, baseleft, progresstop + 2 + progressheight);
        progress.draw(canvas);
        if (startBitmap != null) {
            StepStartPoint(canvas, mStartPoints, progresstop + 2, baseleft, startBitmap);
        }
    }

    private float old_x = 0.0f;
    private float old_y = 0.0f;
    private boolean ischangeprogress = false;

    @Override
    public boolean onTouchEvent(MotionEvent event) {
//		LOG(" ------ onTouchEvent(),  event.getAction() = " + event.getAction());
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                old_x = event.getX();
                old_y = event.getY();
                ischangeprogress = false;
                if (old_y > progresstop && old_y < progresstop + progressheight && old_x > 0 && old_x < getWidth()) {
                    if (mOnSeekBarMyChangeListener != null)
                        mOnSeekBarMyChangeListener.onStartTrackingTouch();
                    int nowprogress = (int) (mMaxProgress * old_x / getWidth());
                    if (nowprogress != currentProgress) {
                        setProgress(nowprogress);
                    }
                    ischangeprogress = true;
                }
                break;
            case MotionEvent.ACTION_MOVE:
            case MotionEvent.ACTION_UP:
                if (ischangeprogress) {
                    old_x = event.getX();
                    old_y = event.getY();
                    if (old_x > 0 && old_x < getWidth()) {
                        int nowprogress = (int) (mMaxProgress * old_x / getWidth());
                        if (nowprogress != currentProgress) {
                            setProgress(nowprogress);
                            if (mOnSeekBarMyChangeListener != null)
                                mOnSeekBarMyChangeListener.onProgressChanged(this.currentProgress, true);
                        }
                    }
                    if (MotionEvent.ACTION_UP == event.getAction()) {
                        if (mOnSeekBarMyChangeListener != null)
                            mOnSeekBarMyChangeListener.onStopTrackingTouch();
                    }
                }
                break;
        }
        return true;
    }

    public interface OnSeekBarMyChangeListener {
        public void onStartTrackingTouch();

        public void onProgressChanged(int progress, boolean fromUser);

        public void onStopTrackingTouch();
    }

    ;

    private void StepStartPoint(Canvas canvas, ArrayList<StartPoint> mstartpoints, int basetop, int baseleft, Bitmap startbitmap) {
        boolean isNeedAvailabilityPoint = true;
        for (StartPoint tmp : mstartpoints) {
            if (isNeedAvailabilityPoint && !tmp.availability) {
                isNeedAvailabilityPoint = false;
                tmp.availability = true;
                tmp.x = baseleft;
                tmp.y = basetop;
                tmp.w = random.nextFloat() * MAXWIDTH;
                if (tmp.w < 2)
                    tmp.w = 2;
                tmp.stepx = (int) (random.nextFloat() * 3);
                tmp.stepy = (int) (random.nextFloat() * 3);
                tmp.x = baseleft - tmp.stepx;
                tmp.y = basetop + tmp.stepy;
                tmp.mbitmap = bitmapRoom(startbitmap, (int) tmp.w, (int) tmp.w);
                canvas.drawBitmap(tmp.mbitmap, tmp.x, tmp.y, mPaint);
            } else if (tmp.availability) {
                if (tmp.x < 0 || tmp.y < 0 || tmp.w < 1.5f) {
                    tmp.availability = false;
                    if (tmp.mbitmap != null)
                        tmp.mbitmap.recycle();
                    tmp.mbitmap = null;
                } else {
                    tmp.x -= tmp.stepx;
                    tmp.y -= tmp.stepy;
                    tmp.w -= 0.3f;
                    if (tmp.mbitmap != null)
                        tmp.mbitmap.recycle();
                    tmp.mbitmap = bitmapRoom(startbitmap, (int) tmp.w, (int) tmp.w);
                    canvas.drawBitmap(tmp.mbitmap, tmp.x, tmp.y, mPaint);
                }
            }
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == View.VISIBLE) {
            mUIHandler.sendEmptyMessage(0);
        }
    }

    private Handler mUIHandler = new Handler() {
        public void dispatchMessage(android.os.Message msg) {
            if (mseekbarmy.getVisibility() == View.VISIBLE) {
                invalidate();
                this.sendEmptyMessageDelayed(0, 100);
            }
        }

        ;
    };

    private Bitmap bitmapRoom(Bitmap srcBitmap, int newHeight, int newWidth) {
        int srcWidth = srcBitmap.getWidth();
        int srcHeight = srcBitmap.getHeight();
        float scaleWidth = ((float) newWidth) / srcWidth;
        float scaleHeight = ((float) newHeight) / srcHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap(srcBitmap, 0, 0, srcWidth, srcHeight, matrix, true);
        if (resizedBitmap != null) {
            return resizedBitmap;
        } else {
            return srcBitmap;
        }
    }
}