package android.rk.RockVideoPlayer.ui;

import java.util.Random;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

public class DeleteImage extends ImageView {
    private final static int DUE = 10;
    private final static float MACANGLE = 20;
    private float ratation = 0;
    private float step = 0;
    private Bitmap mBitmap;
    private static Random random = new Random(50);
    private static Random randomstep = new Random(50);

    public DeleteImage(Context context, AttributeSet attrs) {
        super(context, attrs);
        Drawable mtmp = this.getDrawable();
        mBitmap = ((BitmapDrawable) mtmp).getBitmap();
        ratation = random.nextFloat();
        step = randomstep.nextFloat() * 4;
        if (step < 2.0f)
            step = 2.0f;
//		mHandler.sendEmptyMessageDelayed(0, DUE * 2);	
    }

    @Override
    protected void onDraw(Canvas canvas) {
//		super.onDraw(canvas);
        Paint mPaint = new Paint();
        mPaint.setColor(Color.GREEN);

        int cx = mBitmap.getWidth() / 2;
        int cy = mBitmap.getHeight() / 2;
        canvas.rotate(ratation, cx, cy);

        canvas.drawBitmap(mBitmap, 0, 0, mPaint);
//		canvas.scale(sx, sy);	
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == View.VISIBLE) {
            mHandler.removeMessages(0);
            mHandler.sendEmptyMessageDelayed(0, DUE);
        } else {
            mHandler.removeMessages(0);
        }
    }

    ;

    Handler mHandler = new Handler() {
        public void dispatchMessage(android.os.Message msg) {
            invalidate();
            ratation = ratation + step;
            if (Math.abs(ratation) > MACANGLE) {
                step = -step;
            }
            sendEmptyMessageDelayed(0, DUE);
        }

        ;
    };
}