/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.rk.RockVideoPlayer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import android.Manifest;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.app.KeyguardManager.KeyguardLock;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.provider.MediaStore;
import android.provider.MediaStore.Video;
import android.provider.Settings;
import android.rk.RockVideoPlayer.DBUtils.Def;
import android.rk.RockVideoPlayer.TopBar.TopBarButton;
import android.rk.RockVideoPlayer.TopBar.TopBarControl;
import android.rk.RockVideoPlayer.armFreq.util.Utils;
import android.rk.RockVideoPlayer.subTitle.SubTitleContent;
import android.text.Html;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnSystemUiVisibilityChangeListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.os.SystemProperties;

public class VideoPlayActivity extends Activity implements
        MediaPlayer.OnErrorListener, MediaPlayer.OnCompletionListener,
        DBUtils.Def, View.OnKeyListener
        //
        , TopBarControl
        //
        , OnSystemUiVisibilityChangeListener, VideoDisplayView.OnVideoViewListener {
    private static final String TAG = "VideoPlayActivity";
    //	private static final boolean DEBUG = true;
    private static final boolean DEBUG = false;
    private static final boolean MOVE_TO_ADJUST_VOLUME = false;

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        } else {
            if (DebugUtil.isDebugFileExist())
                Log.d(TAG, msg);
        }
    }

    //	private StorageManager mStorageManager = null;
    private static final String SERVICE_ACTION_RK = "android.rk.RockAudioPlayer.musicservicecommand";
    private static final String SERVICE_ACTION_ANDROID = "com.android.music.musicservicecommand";
    private static final String CMDNAME = "command";
    private static final String CMDPAUSE = "pause";
    private BroadcastReceiver mMediaReceiver;
    private BroadcastReceiver mShutDownReceiver;
    private BroadcastReceiver dismissReceiver;
    private VideoDisplayView mVideoDisplayView;
    public View mProgressView;
    public View mPercentView;
    public TextView mPercentText;
    private View mHelpView;
    private boolean mFinishOnCompletion;
    private Uri mUri;
    private String mUriPath = null;
    private int mPositionWhenPaused = -1;
    private int mPositionWhenStop = -1;
    private boolean mWasPlayingWhenPaused = true;

    /**
     * 强制prepared后进行播放,用于辅助mWasPlayingWhenPaused状态不对,例如:
     * 点击下一首,然后立马暗屏,此时可能还没执行播放,mediaPlayer.isPlaying就为false.
     * 那么mWasPlayingWhenPaused记录的就是false,导致唤醒解锁后,
     * VideoDisplayView.java的prepared监听,不去调用mMediaPlayer.start()
     * 添加一个新值,不论上次是否点击暂停等,只要点击上下首、播放结束进行轮播等状态,
     * 就认为用户将要进行播放操作
     */
    private boolean mForceDoStartPlay;
    private int position = 0;
    /**
     * Called when the activity is first created.
     */
    private int mOriginalBrightness;
    static StringBuilder mFormatBuilder;
    static Formatter mFormatter;
    private Context mContext;
    public ProgressDialog mLoadDialog;
    private AudioManager audioMa;
    private int volume = 0;
    private final int VOLUMEPLUS = 1;
    private final int VOLUMEMINUS = -1;
    private View Volume_view;
    private final int SHOWTIME = 2000;
    private int mOldBrightness = 0;
    public int mSystemBacklight;
    public int mBrightness;
    public int mBrightMode;
    private boolean mAutomaticMode;
    public int mVolumeMode;
    public final int SYSBRIGHT = Def.MODE_SYSTEM;
    public final int USERBRIGHT = Def.MODE_USER;
    private int mOldVolume = 0;
    private int mSystemVolume;
    private boolean isScreenOff = false;
    private final int HIDE_HELPVIEW = 1;
    public static final int FULLSCREEN_FLAG = 0x0003;
    public static final int NOT_FULLSCREEN_FLAG = 0x0004;
    public static final int SHOW_SUBTITLE = 0x0005;
    public static final int HIDE_SUBTITLE = 0x0006;
    public static final int SHOW_PROCESS_FLAG = 0x0007;
    public static final int HIDE_PROCESS_FLAG = 0x0008;
    public static final int SHOW_IMGSUBTITLE = 0x0009;
    public static final int HIDE_IMGSUBTITLE = 0x00010;
    public static final int SHOW_LASTSUBTITLE = 0x00011;
    public static final int SHOW_CURRENT_VOLUME = 0x00012;
    public static final int HIDE_CURRENT_VOLUME = 0x00013;
    private final int TIME_SHORT = 5000;
    private final int TIME_MIDDLE = 8000;
    private final int TIME_LONG = 10000;
    PowerManager mPowerManager;
    PowerManager.WakeLock mWakeLock;

    public View mTopView;
    public long mSeekTime;
    public TextView mTopCurrentTime;
    public TextView mTotalTime;
    public ProgressBar mTopProgress;
    private boolean mPauseStatus = false;
    private final int sDefaultTimeout = 4000;
    private boolean mDragging;
    public boolean mTopViewShow;
    public TopBar mTopBar;
    private final static String TOPBAR_PAUSE = "pause";
    private long mStartSeekPos = 0;
    private long mEndSeekPos = 0;
    public boolean mOutputToTvOut = false;

    public static int currPlayPos = -1;

    private static final int MENU_ITEM__OUTPUT_TO_PAL = 11;
    private static final int MENU_ITEM__OUTPUT_TO_NTSC = 12;
    private static final int MENU_ITEM__OUTPUT_TO_YBR_480 = 13;
    private static final int MENU_ITEM__OUTPUT_TO_YBR_576 = 14;
    private static final int MENU_ITEM__OUTPUT_TO_YBR_720 = 15;

    private int mTVOutMode;
    private final int sTVOUT_Cvbs_PAL = 0;
    private final int sTVOUT_Cvbs_NTSC = 1;
    private final int sTVOUT_Ypbpr480 = 2;
    private final int sTVOUT_Ypbpr576 = 3;
    private final int sTVOUT_Ypbpr720 = 4;
    public boolean mOutputToHdmi = false;

    // options menu item IDs.
    private static final int MENU_ITEM__OUTPUT_TO_HDMI_576p = 1;
    private static final int MENU_ITEM__OUTPUT_TO_HDMI_720p = 2;
    // TvOut manager.

    //
    private boolean mTVOutEnable = false;
    private boolean mHdmiEnable = false;
    private ArrayList<ChoiceItem> choiceItems;

    public VideoPlayActivity() {
        mContext = this;
    }

    int timeoutmode;
    int screenOn;
    private final int TopView_FADEOUT = 0;
    private VideoPlayActivity mActivity = this;
    private MediaPlayer.OnErrorListener mErrorListener = this;
    private MediaPlayer.OnCompletionListener mCompletionListener = this;
    private View.OnKeyListener mKeyListener = this;

    private boolean isActivityRunning = true;

    private KeyguardManager mKeyguardManager = null;
    private KeyguardLock mKeyguardLock = null;

    // public static List<Uri> m3uPlaylist = null;
    // public static int m3uplayindex = -1;

    // add by wangbo
    public TextView mSubTitleText = null;
    private ImageView mSubTitleImg = null;
    private View mSubtitleView = null;
    public boolean decodeSubtitleFinish = false;
    public Map<String, List<SubTitleContent>> subtitleList = null;

    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mGestureDetector;
    private Configuration mOldConfig;

    private static final String KEY_VIDEO_POSITION = "video-position";
    private static final String KEY_VIDEO_URI = "video-uri";

    private ProgressBar mCurrentVolumeView;
    private AudioManager mAudioManager;
    private boolean mAlreadyReceiver;
    public static boolean mCanDisplayCustomUI;

    // 根据intent要求是否播放一次就退出，陈伟项目要求（开机播放一段视频）
    // public boolean isOneShot = false;

    // private String path = null;

    private void updateFullscreenStatus(boolean bUseFullscreen) {
        LOG("***************************************");
        LOG("updateFullscreenStatus:" + bUseFullscreen);
        LOG("***************************************");
        if (bUseFullscreen) {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
            getWindow().clearFlags(
                    WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN);
        } else {
            getWindow().addFlags(
                    WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN);
            getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        }

    }

    public static boolean isShowingSubtitle = false;
    public Handler subtitleHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            switch (msg.what) {
                case SHOW_LASTSUBTITLE:
                    isShowingSubtitle = false;
                    break;
                case SHOW_SUBTITLE:
                    // if(mTVOutEnable || mHdmiEnable){

                    // }else{
                    if (View.VISIBLE != mSubtitleView.getVisibility()) {
                        mSubtitleView.setVisibility(View.VISIBLE);
                    }
                    mSubTitleText.setText(Html.fromHtml((String) msg.obj));
                    LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>SHOW_SUBTITLE:"
                            + (String) msg.obj);
                    isShowingSubtitle = true;
                    // }
                    break;
                case HIDE_SUBTITLE:
                    if (mVideoDisplayView.isPlaying()) {
                        LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>is playing");
                        mSubTitleText.setText("");
                        if (View.GONE != mSubtitleView.getVisibility()) {
                            mSubtitleView.setVisibility(View.GONE);
                        }
                        isShowingSubtitle = false;
                    } else {
                        LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>not playing");
                        this.sendEmptyMessageDelayed(HIDE_SUBTITLE, 500L);
                    }
                    break;
                case SHOW_IMGSUBTITLE:
                    mSubTitleImg.setImageBitmap((Bitmap) msg.obj);
                    isShowingSubtitle = true;
                    break;
                case HIDE_IMGSUBTITLE:
                    if (mVideoDisplayView.isPlaying()) {
                        mSubTitleImg.setImageBitmap(null);
                        isShowingSubtitle = false;
                    } else {
                        this.sendEmptyMessageDelayed(HIDE_IMGSUBTITLE, 500L);
                    }
                    break;
                default:
                    break;
            }

            LOG("isShowingSubtitle:" + VideoPlayActivity.isShowingSubtitle);
        }
    };

    public Handler progress_Handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case SHOW_PROCESS_FLAG:
                    mProgressView.setVisibility(View.VISIBLE);
                    break;
                case HIDE_PROCESS_FLAG:
                    mProgressView.setVisibility(View.GONE);
                    break;
            }
        }

        ;
    };

    public Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                //
                case TopView_FADEOUT:
                    mHandler.removeMessages(SHOWTIME);
                    mHandler.removeMessages(TopView_FADEOUT);
                    hideTopView();
                    break;
                //
                case HIDE_HELPVIEW:
                    mHelpView.setVisibility(View.GONE);
                    mVideoDisplayView.setEnable(true);
                    break;
                case NOT_FULLSCREEN_FLAG:
                    updateFullscreenStatus(false);
                    break;
                case FULLSCREEN_FLAG:
                    updateFullscreenStatus(true);
                    break;
                case SHOW_PROCESS_FLAG:
                    mProgressView.setVisibility(View.VISIBLE);
                    break;
                case HIDE_PROCESS_FLAG:
                    mProgressView.setVisibility(View.GONE);
                    break;
                case SHOW_CURRENT_VOLUME:
                    break;
                case HIDE_CURRENT_VOLUME:
                    if (null != mCurrentVolumeView) {
                        mCurrentVolumeView.setVisibility(View.GONE);
                    }
                    break;
            }
        }
    };

    public Runnable mPlayingChecker = new Runnable() {
        public void run() {
            if (isActivityRunning == false)
                return;

            LOG("Downlaod percent = " + mVideoDisplayView.getBufferPercentage());
            if (mVideoDisplayView.isDismiss()) {
                LOG("+++++++++++++++++++++++++++++++++++++++++i am run A");
                mHandler.sendEmptyMessage(FULLSCREEN_FLAG);
                mProgressView.setVisibility(View.GONE);
            } else if (mVideoDisplayView.getBufferPercentage() >= 0) {
                LOG("+++++++++++++++++++++++++++++++++++++++++i am run B");
                mHandler.post(mLoadingChecker);
            } else {
                mHandler.sendEmptyMessage(NOT_FULLSCREEN_FLAG);
                LOG("+++++++++++++++++++++++++++++++++++++++++i am run C");
                mHandler.postDelayed(mPlayingChecker, 250);
            }
        }

    };

    public boolean isVideoViewPrepare() {
        return mVideoDisplayView.mIsPrepared;
    }

    private int samePercentCount = 0;
    private int prePercent = 0;
    public Runnable mLoadingChecker = new Runnable() {
        public void run() {
            if (isActivityRunning == false)
                return;
            if (!mVideoDisplayView.mIsPrepared) {
                LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>mLoadingChecker>>>>>>>>>>");
                StringBuilder sb = new StringBuilder();
                String loadtitle = mContext.getResources().getString(
                        R.string.loadtitle);
                int precent = mVideoDisplayView.getBufferPercentage();

                sb.append(precent);
                sb.append("% ");
                sb.append(loadtitle);
                mProgressView.setVisibility(View.VISIBLE);
                mPercentView.setVisibility(View.GONE);
                mPercentText.setText(sb.toString());
                mHandler.sendEmptyMessage(NOT_FULLSCREEN_FLAG);
                mHandler.postDelayed(mLoadingChecker, 250);
            } else {
                mPercentView.setVisibility(View.GONE);
                mHandler.sendEmptyMessage(FULLSCREEN_FLAG);
            }
        }
    };

    AlertDialog TVOutAlert;
    AlertDialog HdmiAlert;

    public void acquireWakeLock() { // 加锁
        LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>acquireWakeLock<<<<<<<<<<<<<<<");
        if (mWakeLock != null) {
            try {
                if (mWakeLock.isHeld() == false)
                    mWakeLock.acquire();
                else
                    LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>error: wake lock is held!");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Handler hh = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    releaseWakeLock();
                    break;
            }
            super.handleMessage(msg);
        }

    };

    public void releaseWakeLock() { // 解锁
        if (mWakeLock != null) {
            try {
                if (mWakeLock.isHeld()) {
                    LOG(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>now release wake lock!");
                    mWakeLock.release();
                    mWakeLock.setReferenceCounted(false);
                    // mWakeLock = null;
                }

            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    public void KeyguardUnLock() {
//		if (mKeyguardLock != null) {
//			try {
//				mKeyguardLock.disableKeyguard();
//			} catch (Exception e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
    }

    public void KeyguardLock() {
//		if (mKeyguardLock != null) {
//			try {
//				mKeyguardLock.reenableKeyguard();
//			} catch (Exception e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
    }

    private Handler errorDialogHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            super.handleMessage(msg);
            new AlertDialog.Builder(mContext).setTitle(
                    R.string.VideoView_error_title).setMessage(
                    R.string.VideoView_error_text_unknown).setPositiveButton(
                    R.string.VideoView_error_button,
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog,
                                            int whichButton) {
                            mActivity.Finish();
                        }
                    }).setCancelable(true).show();
        }
    };

    private ViewGroup view = null;
    /**
     * 将原先onResume的操作放入onStart，onPause的放入onStop中，
     * 使得的O的分屏功能,在点击其他分屏时可以继续播放视频。
     * 1.不点击其他分屏，进行拖拽，onPause-onSave-onStop-onCreate,
     * 为了可以正常跳到播放前，onPause中需要记录暂停点
     * 2.点击其他分屏后,在将分屏拖拽调整大小，onPause-onSave-onStop-onCreate-onPause
     * 由于会重新Prepared，里面会对mWasPlayingWhenPaused做检测，
     * 因此onPause不要去记录播放状态,否则会由于onPause的重写导致重新播放
     * 由于onPause中不去记录，也可能导致重新播放，所以在onSave中做判断保存
     */
    private boolean mIsActivityStop = true;

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        LOG("-------onSaveInstanceState--------Position:" + position);
        if (isInMultiWindowMode() && -1 == position && null != mVideoDisplayView) {
            position = mVideoDisplayView.getCurrentPosition();
            Log.v(TAG, "save current position in multi windows mode,position=" + position);
        }
        outState.putInt(KEY_VIDEO_POSITION, position);
        if (null != mUri) {
            outState.putParcelable(KEY_VIDEO_URI, mUri);
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        LOG("Enter onCreate()");
        boolean work = DBUtils.isSeviceWorked(mContext, "com.android.rk.mediafloat.MediaFloatService");
        if (work) {
            LOG("play in window");
            Uri uri = getIntent().getData();
            if (uri == null || uri.toString().trim().equals("")) {
                errorDialogHandler.sendEmptyMessage(0);
                return;
            }
            Intent intent = new Intent("com.rk.app.mediafloat.CUSTOM_ACTION");
            intent.setPackage("com.android.rk.mediafloat");
            intent.setClassName("com.android.rk.mediafloat", "com.android.rk.mediafloat.MediaFloatService");
            intent.putExtra("URI", uri.toString());
            mContext.startService(intent);
            finish();
        }
        this.overridePendingTransition(-1, -1);
        super.onCreate(savedInstanceState);

        mCanDisplayCustomUI = false;

        Uri uriStore = null;
        if (savedInstanceState != null) {
            position = savedInstanceState.getInt(KEY_VIDEO_POSITION, 0);
            uriStore = savedInstanceState.getParcelable(KEY_VIDEO_URI);
            LOG("========onCreate==============position:" + position);
        }

        ConfigUtil.SET_FIX_FREQUENCY = SystemProperties.getBoolean("ro.videoplayer.fixfreq", false);
        Log.v("----zjy", "------------------------------ConfigUtil.SET_FIX_FREQUENCY:" + ConfigUtil.SET_FIX_FREQUENCY);

//		if (mStorageManager == null) {
//			mStorageManager = (StorageManager) getSystemService(Context.STORAGE_SERVICE);
//			mStorageManager.registerListener(mStorageListener);
//		}

        mAudioManager = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);

        IntentFilter dismissFilter = new IntentFilter();
        dismissFilter.addAction("action.dismiss.hide");
        if (null != dismissReceiver) {
            try {
                Log.v(TAG, "dismissReceiver not null in videoplayactivity");
                unregisterReceiver(dismissReceiver);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        dismissReceiver = new BroadcastReceiver() {
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("action.dismiss.hide")) {
                    hideSystemUI();
                }
            }
        };
        registerReceiver(dismissReceiver, dismissFilter);
        getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(this);
        //getWindow().getDecorView().setSystemUiVisibility(
        //View.SYSTEM_UI_FLAG_SHOW_FULLSCREEN);
        //getWindow().getDecorView().setBackgroundColor(Color.BLACK);
        hideSystemUI();
        getWindow().getDecorView().getRootView().setBackgroundColor(R.color.black);
        setContentView(R.layout.play_display_land);
        final Intent intent = getIntent();
        if (intent == null) {
            return;
        }
//             registMediaBroadcast();
        mUri = intent.getData();
        if (mUri == null || mUri.toString().trim().equals("")) {
            errorDialogHandler.sendEmptyMessage(0);
            return;
        }

        if (CheckPermissionActivity.jump2PermissionActivity(this, getIntent())) {
            finish();
            return;
        }

        if (null != uriStore && !mUri.toString().equals(uriStore.toString())) {
            mUri = uriStore;
        }

        final String scheme = mUri.getScheme();
        if ("http".equalsIgnoreCase(scheme) || "rtsp".equalsIgnoreCase(scheme)
                || (mUri != null && (mUri.toString().endsWith(".m3u8") || mUri.toString().endsWith(".m3u")))) {
            progress_Handler.sendEmptyMessage(SHOW_PROCESS_FLAG);
        }
        mFormatBuilder = new StringBuilder();
        mFormatter = new Formatter(mFormatBuilder, Locale.getDefault());
        view = (ViewGroup) findViewById(R.id.layout_controller);
//        mVideoDisplayView = (VideoDisplayView) findViewById(R.id.surface_view);
		mVideoDisplayView = new VideoDisplayView(this);
		RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
		params.addRule(RelativeLayout.CENTER_IN_PARENT);
		RelativeLayout rootLayout = (RelativeLayout) findViewById(R.id.root_layout);
		rootLayout.addView(mVideoDisplayView, 0, params);
        mVideoDisplayView.setOnVideoViewListener(this);
        mVideoDisplayView.setOnErrorListener(VideoPlayActivity.this);
        mVideoDisplayView.setOnCompletionListener(VideoPlayActivity.this);
//		viewHandler.sendEmptyMessage(SETVIDEOCONN);
        mBrightMode = SYSBRIGHT;
        mAutomaticMode = DBUtils.getBrightnessMode(mContext, 0) == Settings.System.SCREEN_BRIGHTNESS_MODE_AUTOMATIC;
        DBUtils.setMode(mContext, Settings.System.SCREEN_BRIGHTNESS_MODE_MANUAL);
        mBrightness = DBUtils.getBacklight(mContext, mBrightMode);
        mVideoDisplayView.setMediaController(new VideoController(
                VideoPlayActivity.this, view, mBrightness,
                -1));
        mVideoDisplayView.requestFocus(); // make the video view handle
        // keys for seeking and
        // pausing
        mVideoDisplayView.setActivity(mActivity);
        mVideoDisplayView.setOnKeyListener(VideoPlayActivity.this);

        mProgressView = findViewById(R.id.progress_indicator);
        mPercentView = findViewById(R.id.percent_indicator);
        mPercentView.setVisibility(View.GONE);
        mPercentText = (TextView) mPercentView.findViewById(R.id.percent_text);
        mSubtitleView = (View) findViewById(R.id.layout_subtitle);
        mSubTitleText = (TextView) findViewById(R.id.txtsubtitle);
        mSubTitleText.getPaint().setDither(true);
        mSubTitleText.getPaint().setAntiAlias(true);
        mSubtitleView.setVisibility(View.GONE);
        mSubTitleImg = (ImageView) findViewById(R.id.imgsubtitle);
        isActivityRunning = true;

        mVolumeMode = SYSBRIGHT;
//		DBUtils.setOriVolume(mContext, mVolumeMode);
        setVolumeControlStream(AudioManager.STREAM_MUSIC);

        registShutDownBroadcast();

        mFinishOnCompletion = intent.getBooleanExtra(
                MediaStore.EXTRA_FINISH_ON_COMPLETION, true);
        final String netType = intent.getType();
        if (intent.hasExtra(MediaStore.EXTRA_SCREEN_ORIENTATION)) {
            int orientation = intent.getIntExtra(
                    MediaStore.EXTRA_SCREEN_ORIENTATION,
                    ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
            if (orientation != getRequestedOrientation()) {
                setRequestedOrientation(orientation);
            }
        }

        // processNetworkStream(scheme, netType);
        // processM3uList();

//		checkTvout();
//		checkHdmi();
        sendBrocastToPause();
        mVideoDisplayView.setVideoURI(mUri);

        try {
            mPowerManager = (PowerManager) mContext
                    .getSystemService(Context.POWER_SERVICE);
            mWakeLock = mPowerManager.newWakeLock(
                    PowerManager.SCREEN_BRIGHT_WAKE_LOCK, TAG);
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            mKeyguardManager = (KeyguardManager) getSystemService(Context.KEYGUARD_SERVICE);
            mKeyguardLock = mKeyguardManager.newKeyguardLock("SCService");
        } catch (Exception e) {
            e.printStackTrace();
        }

        acquireWakeLock();
        if (ConfigUtil.ISDISABLEKEYGUARD) {
            KeyguardUnLock();
        }

        mScaleDetector = new ScaleGestureDetector(mContext,
                new MyScaleListener());
        mGestureDetector = new GestureDetector(mContext,
                new MyGestureListener(), null, true /* ignoreMultitouch */);
        if (mOldConfig == null) {
            mOldConfig = this.getResources().getConfiguration();
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        LOG("Enter onConfigurationChanged");
        if (mOldConfig != null && null != newConfig) {
            LOG("Configuration diff " + mOldConfig.diff(newConfig));
            if (mOldConfig.diff(newConfig) == (ActivityInfo.CONFIG_KEYBOARD | ActivityInfo.CONFIG_KEYBOARD_HIDDEN)
                    || mOldConfig.diff(newConfig) == (ActivityInfo.CONFIG_NAVIGATION | ActivityInfo.CONFIG_KEYBOARD_HIDDEN)) {
                LOG("No need reinit VideoController");
                mOldConfig = new Configuration(newConfig);
                return;
            }
        }
        mOldConfig = new Configuration(newConfig);

        int layoutRes = newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE ? R.layout.media_controller : R.layout.media_controller_port;
        if (null != mVideoDisplayView) {
            mVideoDisplayView.hideAllDialog();
            VideoController videoController = mVideoDisplayView.getVideoController();
            if (null != videoController) {
                videoController.hideAllDialog();
            }
        }
        mVideoDisplayView.setMediaController(new VideoController(
                VideoPlayActivity.this, view, mBrightness,
                layoutRes));
        mVideoDisplayView.setMaxWh();
        VideoController mVideoController = mVideoDisplayView.getVideoController();
        if (mVideoController != null) {
            mVideoController.setScreen(mVideoController.ScreenSizeMode);
        }
        updateViewHandler.removeMessages(update_view_msg);
        updateViewHandler.sendEmptyMessageDelayed(update_view_msg, 500);
    }

    private final int update_view_msg = 0x01;
    private Handler updateViewHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case update_view_msg:
                    mVideoDisplayView.setMaxWh();
                    VideoController mVideoController = mVideoDisplayView.getVideoController();
                    if (mVideoController != null) {
                        mVideoController.setScreen(mVideoController.ScreenSizeMode);
                        Uri nameUri = mUri;
                        // if the method of getTrueUri or the order of setUri is change in the future,
                        // this code need change too
                        if (null != nameUri && nameUri.toString().startsWith("file://")) {
                            nameUri = DBUtils.getTrueUri(VideoPlayActivity.this, mUri);
                        }
                        String videoName = DBUtils.getVedioName(mContext, nameUri);
                        mVideoController.setVedioName(videoName);
                    }
                /* 分屏后概率性IllegalArgumentException:
                   View=DecorView@db1c6e4[VideoPlayActivity] not attached to window manager
				   看代码，这边应该是与悬浮框有关，先去掉
				WindowManager mWindowManager = (WindowManager)getApplicationContext().getSystemService("window");
				WindowManager.LayoutParams lp = (WindowManager.LayoutParams) getWindow().getDecorView().getLayoutParams();
				if (lp != null) {
				      mWindowManager.updateViewLayout(getWindow().getDecorView(), lp);
				}*/
                    break;
            }
        }

    };

//	StorageEventListener mStorageListener = new StorageEventListener() {
//		@Override
//		public void onStorageStateChanged(String path, String oldState,
//				String newState) {
//			// Log.i(TAG, "Received storage state changed notification that " +
//			// path +
//			// " changed state from " + oldState + " to " + newState);
//			// NOTE:
//
//			if (mUriPath != null) {
//				LOG("<--------------storage_path=" + mUriPath
//						+ "-------------->");
//				String[] media_path = mUriPath.split("/");
//				String[] arg_path = path.split("/");
//				LOG("<----------------media_path=" + media_path[2]
//						+ ",arg_path=" + arg_path[2] + "------------->");
//				if (arg_path[2].equals(media_path[2])) {
//					mVideoDisplayView.pause();
//					mVideoDisplayView.stopPlayback();
//					finish();
//				}
//			}
//
//		}
//	};

    private String getCurrentVideoStoragePath() {
        String path = null;
        Cursor cursor = getContentResolver().query(mUri,
                new String[]{Video.Media.DATA}, null, null, null);

        if (cursor != null) {
            if (cursor.moveToFirst()) {
                LOG("-----------------mUri=" + mUri + cursor.getCount() + "-----"
                        + cursor.getColumnCount() + "-----"
                        + cursor.getColumnIndex(Video.Media.DATA)
                        + "-----------------------");
                path = cursor.getString(0);
            }
            cursor.close();
        }

        return path;
    }

    private void registMediaBroadcast() {
        IntentFilter intentFilter = new IntentFilter();
        //intentFilter.addAction(Intent.ACTION_MEDIA_MOUNTED);
        //intentFilter.addAction(Intent.ACTION_MEDIA_UNMOUNTED);
        intentFilter.addAction(Intent.ACTION_MEDIA_REMOVED);
        intentFilter.addAction(Intent.ACTION_MEDIA_EJECT);
        intentFilter.addDataScheme("file");
        mMediaReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Log.w(TAG, "VideoPlayActivity receive action= " + action);
//				Uri uri = intent.getData();
//				if (uri != null) {
                if (/*action.equals(Intent.ACTION_MEDIA_MOUNTED)
                        || action.equals(Intent.ACTION_MEDIA_UNMOUNTED)*/
                        Intent.ACTION_MEDIA_EJECT.equals(action)
                        || action.equals(Intent.ACTION_MEDIA_REMOVED)) {
                    /*Toast.makeText(VideoPlayActivity.this,
                            getText(R.string.media_scanning),
                            Toast.LENGTH_SHORT).show();*/
                    Toast.makeText(VideoPlayActivity.this,
                            getText(R.string.toast_media_unplug),
                            Toast.LENGTH_SHORT).show();
                    mVideoDisplayView.pause();
                    mVideoDisplayView.stopPlayback();
                    finish();
                    return;
                }
//				}
            }
        };
        Log.v(TAG, "VideoPlayActivity registerReceiver mMediaReceiver");
        registerReceiver(mMediaReceiver, new IntentFilter(intentFilter));
    }

    private void registShutDownBroadcast() {
        mShutDownReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals(Intent.ACTION_SHUTDOWN)) {
                    mVideoDisplayView.pause();
                    mVideoDisplayView.stopPlayback();
                    finish();
                }
            }
        };
        registerReceiver(mShutDownReceiver, new IntentFilter(
                Intent.ACTION_SHUTDOWN));
    }

    // private void processNetworkStream(String scheme, String netType) {
    // if ("http".equalsIgnoreCase(scheme) || "rtsp".equalsIgnoreCase(scheme)) {
    // // progress_Handler.sendEmptyMessage(SHOW_PROCESS_FLAG);
    // if (netType != null) {
    // if (netType.equalsIgnoreCase("video/mp4")
    // || netType.equalsIgnoreCase("video/flv")
    // || netType.equalsIgnoreCase("video/x-flv")) {
    //
    // if (mUri != null
    // && (mUri.toString().endsWith(".m3u8") || mUri
    // .toString().endsWith(".m3u"))) {
    // LOG(">>>>>>>>>>>>>>>>>>>get m3u and decode");
    // m3uPlaylist = M3uUtil.decodeM3u(mUri.toString());
    //
    // if (m3uPlaylist.size() == 0) {
    // errorDialogHandler.sendEmptyMessage(0);
    // return;
    // }
    //
    // for (Uri uri : m3uPlaylist) {
    // LOG(">>>>>>>>>>>>>>>>>>>>>>>>>uri:"
    // + uri.toString());
    // }
    //
    // mUri = m3uPlaylist.get(0);
    // m3uplayindex = 0;
    // } else if (mUri != null
    // && mUri.toString().startsWith(
    // "http://v.iask.com/v_play_ipad.php")) {
    // try {
    // LOG(">>>>>>>>>>>>>>>>>>>get sina ipad");
    // URL url = new URL(mUri.toString());
    // HttpURLConnection http = (HttpURLConnection) url
    // .openConnection();
    // http.setRequestProperty("User-agent",
    // M3uUtil.USERAGENT_STR);
    // http.setInstanceFollowRedirects(false);
    // http.connect();
    //
    // if (http.getResponseCode() == 302) {
    // mUri = Uri.parse(http
    // .getHeaderField("location"));
    // LOG(">>>>>>>>>>>>>>>>>>>sina ipad uri:"
    // + mUri.toString());
    // }
    //
    // http.disconnect();
    // } catch (MalformedURLException e) {
    // // TODO Auto-generated catch block
    // e.printStackTrace();
    // } catch (IOException e) {
    // // TODO Auto-generated catch block
    // e.printStackTrace();
    // }
    // }
    //
    // mHandler.postDelayed(mPlayingChecker, 250);
    // } else if (netType.equalsIgnoreCase("video/3gp")
    // || netType.equalsIgnoreCase("video/3gpp")
    // || netType.equalsIgnoreCase("video/3gpp2")) {
    // mVideoDisplayView.setDisableWhen3gp(true);
    // mHandler.postDelayed(mPlayingChecker, 250);
    // }
    // } else {
    // mHandler.postDelayed(mPlayingChecker, 250);
    // }
    // }
    // }

    // private void processM3uList() {
    //
    // if (mUri != null
    // && (mUri.toString().endsWith(".m3u8") || mUri.toString()
    // .endsWith(".m3u"))) {
    // LOG(">>>>>>>>>>>>>>>>>>>get m3u and decode");
    // // progress_Handler.sendEmptyMessageDelayed(SHOW_PROCESS_FLAG, 500);
    // m3uPlaylist = M3uUtil.decodeM3u(mUri.toString());
    // if (m3uPlaylist.size() == 0) {
    // errorDialogHandler.sendEmptyMessage(0);
    // return;
    // }
    //
    // for (Uri uri : m3uPlaylist) {
    // LOG(">>>>>>>>>>>>>>>>>>>>>>>>>uri:" + uri.toString());
    // }
    //
    // mUri = m3uPlaylist.get(0);
    // m3uplayindex = 0;
    //
    // mHandler.post(mPlayingChecker);
    // }
    // }

    private void sendBrocastToPause() {
        Intent i = new Intent(SERVICE_ACTION_RK);
        i.putExtra(CMDNAME, CMDPAUSE);
        sendBroadcast(i);
        Intent z = new Intent(SERVICE_ACTION_ANDROID);
        z.putExtra(CMDNAME, CMDPAUSE);
        sendBroadcast(z);
    }

    private BroadcastReceiver mScreencloseReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            if (action.equals(Intent.ACTION_SCREEN_OFF)) {
                LOG("----------ACTION_SCREEN_OFF-------------");
                mVideoDisplayView.pause();
            }
        }
    };

    private BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (mCanDisplayCustomUI && AudioManager.VOLUME_CHANGED_ACTION.equals(intent.getAction())) {
                int streamType = intent.getIntExtra(AudioManager.EXTRA_VOLUME_STREAM_TYPE, -1);
                int streamValue = intent.getIntExtra(AudioManager.EXTRA_VOLUME_STREAM_VALUE, -1);
                if (AudioManager.STREAM_MUSIC == streamType) {
                    displayCurrentVolumeView(streamValue);
                }
            }
        }
    };

    private void registerBroadcast() {
        if (!mAlreadyReceiver && ConfigUtil.USE_CUSTOM_VOLUME_UI) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(AudioManager.VOLUME_CHANGED_ACTION);
            registerReceiver(mReceiver, intentFilter);
            mAlreadyReceiver = true;
        }
    }

    private static boolean uriSupportsBookmarks(Uri uri) {
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        return ("content".equalsIgnoreCase(scheme) && MediaStore.AUTHORITY
                .equalsIgnoreCase(authority));
    }

    public Integer getBookmark(Uri uri) {
        if (!uriSupportsBookmarks(uri)) {
            return null;
        }
        final Integer bookmark = DBUtils.getBookmark(this, uri);
        return bookmark;
    }

    private int getCursorInteger(Cursor cursor, int index) {
        try {
            return cursor.getInt(index);
        } catch (SQLiteException e) {
            return 0;
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setBookmark(int bookmark) {
        if (!uriSupportsBookmarks(mUri)) {
            return;
        }

        ContentValues values = new ContentValues();
        values.put(Video.VideoColumns.BOOKMARK, Integer.toString(bookmark));
        try {
            getContentResolver().update(mUri, values, null, null);
            LOG("setBookmark successed");
        } catch (SecurityException ex) {
            // Ignore, can happen if we try to set the bookmark on a read-only
            // resource
            // such as a video attached to GMail.
        } catch (SQLiteException e) {
            // ignore. can happen if the content doesn't support a bookmark
            // column.
        } catch (UnsupportedOperationException e) {
            // ignore. can happen if the external volume is already detached.
        }
    }

    @Override
    public void onPause() {
        LOG("================onPause()=================");
        position = mVideoDisplayView.getCurrentPosition();
        this.overridePendingTransition(-1, -1);
        super.onPause();
        if (mAlreadyReceiver) {
            unregisterReceiver(mReceiver);
            mAlreadyReceiver = false;
        }
        if (!isInMultiWindowMode()) {
            doPause();
        }
    }

    private void doPause() {
        mWasPlayingWhenPaused = mVideoDisplayView.isPlaying();
        LOG("doPause mWasPlayingWhenPaused=" + mWasPlayingWhenPaused);
        position = mVideoDisplayView.getCurrentPosition();
        if (ConfigUtil.SET_FIX_FREQUENCY) {
            try {
                Utils.setGovernorMode(Utils.INTERACTIVE_MODE);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
//		m3uPlaylist = null;
//		m3uplayindex = -1; // end
        // if(mVideoDisplayView != null){ //解决待机无法唤醒问题
        // mVideoDisplayView.pause();
        // mVideoDisplayView.StopPlay();
        // }

        progress_Handler.removeMessages(SHOW_PROCESS_FLAG);
        progress_Handler.removeMessages(HIDE_PROCESS_FLAG);
        mVideoDisplayView.pause();
        LOG("Enter onPause()----position:" + position + ",mWasPlayingWhenPaused:" + mWasPlayingWhenPaused);
    }

    @Override
    public void onResume() {
        super.onResume();
        LOG("=====================Enter VideoPlayActivity onResume()======================");
        //broadcast
        registerBroadcast();

        if (mIsActivityStop || !isInMultiWindowMode()) {
            mIsActivityStop = false;
            doResume();
        }
    }

    private void doResume() {
        if (ConfigUtil.SET_FIX_FREQUENCY) {
            try {
                Utils.setGovernorMode(Utils.USERSPACE_MODE);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Utils.setSpeedFreq(ConfigUtil.FIX_FREQUENCY_VALUE);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        isActivityRunning = true;
        DBUtils.setOriBacklight(mContext, mBrightMode);
        try {
            unregisterReceiver(mScreencloseReceiver);
        } catch (Exception e) {
        }
        registerReceiver(mScreencloseReceiver, new IntentFilter(
                Intent.ACTION_SCREEN_OFF));

        if (ConfigUtil.ISDISABLEKEYGUARD) {
            KeyguardUnLock();
        }

        LOG("-----------------------position:" + position + ", " + mWasPlayingWhenPaused);
        mVideoDisplayView.seekTo(position);

        if (mVideoDisplayView != null) {
            if (mWasPlayingWhenPaused) {
                mVideoDisplayView.start();
            } else {
                mVideoDisplayView.pause();
            }
        }
        hideSystemUI();
        getWindow().getDecorView().getRootView().setBackgroundColor(R.color.black);
        mHandler.postDelayed(mHideSystemUI, 3000);
        if (null != mCurrentVolumeView) {
            mCurrentVolumeView.setVisibility(View.GONE);
        }
    }

    void hideSystemUI() {
        getWindow().getDecorView().getRootView().setSystemUiVisibility(
                View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                        | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION // hide nav bar
                        | View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
                        | View.SYSTEM_UI_FLAG_LOW_PROFILE);
    }

    public Runnable mHideSystemUI = new Runnable() {
        public void run() {
            hideSystemUI();
        }
    };

    public boolean getWasPlayingWhenPaused() {
        return mWasPlayingWhenPaused;
    }

    public void updatePlayingWhenPaused(boolean status) {
        Log.v(TAG, "updatePlayingWhenPaused=" + status);
        mWasPlayingWhenPaused = status;
    }

    public boolean getIsForceDoStartPlay() {
        return mForceDoStartPlay;
    }

    public void updateForceDoStartPlay(boolean status) {
        Log.v(TAG, "updateForceDoStartPlay=" + status);
        mForceDoStartPlay = status;
    }

    public void refreshWindow() {
        getWindow().getDecorView().requestLayout();
    }

    public void SaveVideoMark() {
        if (DBUtils.getBookmark(this, mUri) != null
                || DBUtils.getBookmark(this, mUri) == 0) {
            LOG(">>>>>>>>>>>>current pos:"
                    + mVideoDisplayView.getCurrentPosition());
            DBUtils.setBookmark(this, DBUtils.getCurrentCursor(this, mUri),
                    mVideoDisplayView.getCurrentPosition());
        }

    }

    @Override
    protected void onStart() {
//		((AudioManager) getSystemService(AUDIO_SERVICE)).requestAudioFocus(
//				null, AudioManager.STREAM_MUSIC,
//				AudioManager.AUDIOFOCUS_GAIN_TRANSIENT);
        LOG("==================Enter onStart====================");
        super.onStart();

        if (Build.VERSION.SDK_INT >= ConfigUtil.ANDROID_SDK_VERSION_R) {
            registMediaBroadcast();
        }
    }

    @Override
    public void onStop() {
        LOG("==================Enter onStop====================");
//		((AudioManager) getSystemService(AUDIO_SERVICE))
//				.abandonAudioFocus(null);
        // android.os.Debug.stopMethodTracing();
        if (isInMultiWindowMode()) {
            mIsActivityStop = true;
            doPause();
        }
        super.onStop();
        if (null != mMediaReceiver) {
            Log.v(TAG, "VideoPlayActivity unregisterReceiver mMediaReceiver");
            unregisterReceiver(mMediaReceiver);
            mMediaReceiver = null;
        }

        if (ConfigUtil.ISENABLESUBTITLE) { // 原来在onpause里，调到此处解决待机唤醒无法再播字幕问题
            // stard
            SubContentUtil.stopDecodeFlag = true;
        }
        subtitleHandler.removeMessages(VideoPlayActivity.HIDE_IMGSUBTITLE);
        subtitleHandler.removeMessages(VideoPlayActivity.HIDE_SUBTITLE);
        subtitleHandler.removeMessages(VideoPlayActivity.SHOW_SUBTITLE);
        subtitleHandler.removeMessages(VideoPlayActivity.SHOW_IMGSUBTITLE);
        mVideoDisplayView.runSubtitleThread = false;

        initialStatus();
        // setBrightnessBack(mOldBrightness);
        /*
         * audioMa.setStreamVolume(AudioManager.STREAM_MUSIC, mOldVolume, 0);
         *
		 * Settings.System.putInt(getContentResolver(),
		 * SCREEN_OFF_TIMEOUT,timeoutmode );
		 * Settings.System.putInt(getContentResolver(),
		 * Settings.System.STAY_ON_WHILE_PLUGGED_IN,screenOn); /* ������ ʹ��
		 * HDMI, �� ...
		 */
        //
        // if ( null != mHdmiMgr ) {
        // LOG("onStop() : To disable HDMI output for activity being stopped.");
        // disableHdmiOutput();
        // mHdmiMgr = null;
        // }

        // if ( null != mTvOutMgr ) {
        // disableTvOut();
        // mTvOutMgr = null;
        // }

        // releaseWakeLock();
        if (ConfigUtil.ISDISABLEKEYGUARD) {
            KeyguardLock();
        }
        hh.removeMessages(1);
        hh.sendEmptyMessageDelayed(1, 2000);
        // hh.sendEmptyMessageDelayed(1, 15000);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        LOG("=================Enter VideoPlayActivity OnDestroy============");
        isActivityRunning = false;
//		if (mStorageManager != null) {
//			mStorageManager.unregisterListener(mStorageListener);
//		}
        if (mVideoDisplayView != null) {
            mVideoDisplayView.pause();
            mVideoDisplayView.StopPlay();
        }
        try {
            unregisterReceiver(mScreencloseReceiver);
//			unregisterReceiver(mReceiver);
        } catch (Exception e1) {
        }
        try {
            unregisterReceiver(mShutDownReceiver);
        } catch (Exception e) {
        }
        try {
            unregisterReceiver(dismissReceiver);
        } catch (Exception e) {
        }

        // if ( null != mHdmiMgr ) {
        // try {
        // unregisterReceiver(mHdmiBroadcastReceiver);
        // } catch (Exception e) {
        // }
        // LOG("onDestroy() : To disable HDMI facility for activity being destroyed.");
        // mHdmiMgr.enableHdmiFacility(false);
        // }
        // if( null != mTvOutMgr ){
        // disableTvOut();
        // }
        initialStatus();
        if (null != mHandler) {
            mHandler.removeMessages(HIDE_CURRENT_VOLUME);
        }

    }

    public void initialStatus() {
        if (mBrightMode != SYSBRIGHT) {
            DBUtils.setbackBacklight(this, mBrightMode);
        }
//		if (mVolumeMode != SYSBRIGHT) {
//			DBUtils.setVolume(this, mVolumeMode);
//		}
        // Settings.System.putInt(getContentResolver(),
        // SCREEN_OFF_TIMEOUT,timeoutmode );
        Settings.System.putInt(getContentResolver(),
                Settings.System.STAY_ON_WHILE_PLUGGED_IN, screenOn);
        DBUtils.setMode(mContext, mAutomaticMode ? Settings.System.SCREEN_BRIGHTNESS_MODE_AUTOMATIC : Settings.System.SCREEN_BRIGHTNESS_MODE_MANUAL);
    }

    public boolean onError(MediaPlayer player, int arg1, int arg2) {
        Log.e(TAG, "onError what=" + arg1 + ", extra=" + arg2);
        mHandler.removeCallbacksAndMessages(null);
        mProgressView.setVisibility(View.GONE);
        return false;
    }

    public void onCompletion(MediaPlayer mp) {
        Log.v(TAG, "onCompletion mFinishOnCompletion=" + mFinishOnCompletion);
        if (mFinishOnCompletion) {
            finish();
        }
    }

    @Override
    public void displaySubTitleView(boolean show) {
        mSubtitleView.setVisibility(show ? View.VISIBLE : View.GONE);
    }

    @Override
    public void displayCurrentVolume() {
        if (mCanDisplayCustomUI) {
            int current = mAudioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
            displayCurrentVolumeView(current);
        }
    }

    public void displayCurrentVolumeView(int currentVolume) {
        if (null == mCurrentVolumeView) {
            mCurrentVolumeView = (ProgressBar) findViewById(R.id.pb_volume);
        }
        int maxVolume = mAudioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
        if (-1 == currentVolume || currentVolume > maxVolume) {
            return;
        }
        mCurrentVolumeView.setProgress(100 * currentVolume / maxVolume);
        mCurrentVolumeView.setVisibility(View.VISIBLE);
        mHandler.removeMessages(HIDE_CURRENT_VOLUME);
        mHandler.sendEmptyMessageDelayed(HIDE_CURRENT_VOLUME, 2000);
    }

    public void DisplayHelpView() {
        mHelpView = (View) findViewById(R.id.layout_help);
        mHelpView.setOnClickListener(mCloseListener);

        TextView tv_helptitle = (TextView) mHelpView
                .findViewById(R.id.help_title);
        tv_helptitle.setText(getText(R.string.text_helptitle));

        TextView tv_helpcolse = (TextView) mHelpView
                .findViewById(R.id.help_close);
        tv_helpcolse.setText(R.string.text_helpcolse);
        tv_helpcolse.setTextSize(20);
        TextView tv_bookmarkhelp = (TextView) mHelpView
                .findViewById(R.id.bookmarkhelp_text);
        tv_bookmarkhelp.setText(R.string.text_bookmarkhelp);

        TextView tv_prehelp = (TextView) mHelpView
                .findViewById(R.id.prehelp_text);
        tv_prehelp.setText(R.string.text_prehelp);

        TextView tv_pausehelp = (TextView) mHelpView
                .findViewById(R.id.pausehelp_text);
        tv_pausehelp.setText(R.string.text_pausehelp);

        TextView tv_nexthelp = (TextView) mHelpView
                .findViewById(R.id.nexthelp_text);
        tv_nexthelp.setText(R.string.text_nexthelp);

        TextView tv_brighthelp = (TextView) mHelpView
                .findViewById(R.id.brighthelp_text);
        tv_brighthelp.setText(R.string.text_brighthelp);

        TextView tv_screensizehelp = (TextView) mHelpView
                .findViewById(R.id.screensizehelp_text);
        tv_screensizehelp.setText(R.string.text_screensizehelp);

        TextView tv_returnhelp = (TextView) mHelpView
                .findViewById(R.id.returnhelp_text);
        tv_returnhelp.setText(R.string.text_returnhelp);

        TextView tv_othershelp = (TextView) mHelpView
                .findViewById(R.id.othershelp_text);
        tv_othershelp.setText(R.string.text_othershelp);

        TextView tv_help_more = (TextView) mHelpView
                .findViewById(R.id.help_more);
        tv_othershelp.setText(R.string.text_help_more);
        mHandler.removeMessages(HIDE_HELPVIEW);
        mHelpView.setVisibility(View.VISIBLE);
        mVideoDisplayView.setEnable(false);
    }

    private View.OnClickListener mCloseListener = new View.OnClickListener() {
        public void onClick(View v) {
            mHelpView.setVisibility(View.GONE);
            /* ʹ�ܵ���menubar */
            mVideoDisplayView.setEnable(true);
            if (ConfigUtil.IS_PAUSE_ONDIALOG) {
                if (mVideoDisplayView.isPlaying() == false)
                    mVideoDisplayView.start();
            }
        }
    };

    private View inflateView(int resource) {

        LayoutInflater vi = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        return vi.inflate(resource, null);
    }

    public void Finish() {
        /*
         * Intent i = new Intent(); i.setClass(getBaseContext(),
		 * RockVideoPlayer.class); startActivity(i);
		 */
        /*
         * if(DBUtils.getBookmark(this,mUri)!= null ||
		 * DBUtils.getBookmark(this,mUri) == 0){
		 * DBUtils.setBookmark(this,DBUtils
		 * .getCurrentCursor(this,mUri),mVideoDisplayView.getCurrentPosition());
		 * }
		 */
        mVideoDisplayView.StopPlay();
        // android.os.Process.killProcess(android.os.Process.myPid());
        finish();
    }

    public void setUri(Uri uri) {
        mUri = uri;
        mUriPath = getCurrentVideoStoragePath();
    }

    public void dismissLoading() {
        mProgressView.setVisibility(View.GONE);
        mPercentView.setVisibility(View.GONE);
        /*
         * if(mLoadDialog != null) mLoadDialog.dismiss();
		 */
    }

    //
    private void disableHdmiOutput() {
        if (!mOutputToHdmi) {
            return;
        }

        // if ( null != mHdmiMgr ) {
        // //* ���� HDMI ���.
        // mHdmiMgr.enableHdmiOutput(false, 0); // �ٶ�ʧ�ܼ�����. "0" : dummy.
        // //* ����״̬��ʶ.
        // mOutputToHdmi = false;
        // }
    }

    // **
    // * ʹ�� HDMI ���.
    // * @param resolution
    // * Ŀ��ֱ���.
    // *
    private void enableHdmiOutput(int resolution) {
        if (mOutputToHdmi) {
            return;
        }

        // if ( null != mHdmiMgr ) {
        // //* ���� UI ���.
        // hideMediaControls();
        // //* ʹ�� HDMI ���.
        // mHdmiMgr.enableHdmiOutput(true, resolution); // �ٶ�ʧ�ܼ� faital,
        // �����ر���ʧ��.
        // //* ����״̬��ʶ.
        // mOutputToHdmi= true;
        // }
    }

    //
    private void hideMediaControls() {
        mVideoDisplayView.hideMediaControls();
    }

    // ============================
    // HDMI broadcast receiver.
    // ============================
    //
    private final BroadcastReceiver mHdmiBroadcastReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();

            // * ���� HDMI ״̬�仯, �� ...
            // if ( action.equals(HdmiManager.HDMI_STATE_CHANGED_ACTION) ) {
            // //* ��ȡ HDMI ��״̬.
            // int state = intent.getIntExtra(HdmiManager.EXTRA_HDMI_STATE,
            // HdmiManager.HDMI_STATE_DISCONNECTED);
            // LOG("mHdmiBroadcastReceiver.onReceive() : Received broadcast : HDMI state changed to "
            // + HdmiManager.convertHdmiStateToStr(state) );
            //
            // //* �� HDMI ��״̬�� "disconnected", �� ...
            // if ( (HdmiManager.HDMI_STATE_DISCONNECTED == state) ) {
            // //* �رտ��ܵ� HDMI menu.
            // closeOptionsMenu();
            //
            // //* �� "this" ��ʹ�� HDMI �����Ƶ, �� ...
            // if ( mOutputToHdmi ) {
            // //* HDMI service �Ѿ��Զ� ������ HDMI ���, �� ��ʶ.
            // mOutputToHdmi = false;
            // }
            // }
            // }
        }
    };

    //

    class ChoiceListAdapter extends ArrayAdapter {
        private final LayoutInflater mInflater;
        int resource;

        public ChoiceListAdapter(Context context, int ResourceId,
                                 ArrayList<ChoiceItem> items) {
            // LOG("Enter ChoiceListAdapter() context / ResourceId /items = " +
            // context + "/ " + ResourceId + " /" + items);
            super(context, ResourceId, items);

            resource = ResourceId;
            mInflater = LayoutInflater.from(context);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            LinearLayout ChoiceView;
            final ChoiceItem info = (ChoiceItem) getItem(position);
            if (convertView == null) {
                ChoiceView = new LinearLayout(getContext());
                String inflater = Context.LAYOUT_INFLATER_SERVICE;
                mInflater.inflate(resource, ChoiceView, true);
                // convertView = mInflater.inflate(R.layout.video_item_land,
                // parent, false);
            } else {
                ChoiceView = (LinearLayout) convertView;
            }
            // -----------------------------

            // -----------------------------

            // final TextView textView = (TextView) convertView;
            // textView.setCompoundDrawablesWithIntrinsicBounds(info.bitmap,null,null,null);
            // textView.setText(info.videoname);
            ViewHolder vh = new ViewHolder();
            vh.choiceText = (TextView) ChoiceView
                    .findViewById(R.id.choice_content);
            ChoiceView.setTag(vh);
            // vh.setTextColor(R.color.deepbrown);
            vh.choiceText.setText(info.content);
            return ChoiceView;
        }

    }

    class ChoiceItem {
        String content;
    }

    class ViewHolder {
        TextView choiceText;
    }

    //
    public void DisplayTvout() {
        TVOutAlert = new AlertDialog.Builder(this)
                // builder.setTitle(str5);
                .setInverseBackgroundForced(true).setAdapter(
                        (ListAdapter) new ChoiceListAdapter(this,
                                R.layout.choice_item, addTVOutChoices()),
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int item) {
                                if (ConfigUtil.IS_ENABLE_TVOUTYBPR) {
                                    switch (item) {
                                        case sTVOUT_Cvbs_PAL:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Cvbs_PAL;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case sTVOUT_Cvbs_NTSC:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Cvbs_NTSC;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case sTVOUT_Ypbpr480:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Ypbpr480;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case sTVOUT_Ypbpr576:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Ypbpr576;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case sTVOUT_Ypbpr720:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Ypbpr720;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case 5:
                                            TVOutAlert.dismiss();
                                            break;
                                        default:
                                            TVOutAlert.dismiss();
                                            break;
                                    }
                                } else {
                                    switch (item) {
                                        case sTVOUT_Cvbs_PAL:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Cvbs_PAL;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case sTVOUT_Cvbs_NTSC:
                                            // mTVOutMode =
                                            // TvOutManager.TVOUT_Cvbs_NTSC;
                                            // enableTVOut(mTVOutMode);
                                            TVOutAlert.dismiss();
                                            break;
                                        case 2:
                                            TVOutAlert.dismiss();
                                            break;
                                        default:
                                            TVOutAlert.dismiss();
                                            break;
                                    }
                                }

                            }
                        }).setTitle(R.string.selection_tvout_title).show();
    }

    private ArrayList addTVOutChoices() {
        Resources r = this.getResources();
        final String str1 = r.getString(R.string.selection_tvout_Cvbs_PAL);
        final String str2 = r.getString(R.string.selection_tvout_Cvbs_NTSC);
        final String str3 = r.getString(R.string.selection_tvout_Ypbpr480);
        final String str4 = r.getString(R.string.selection_tvout_Ypbpr576);
        final String str5 = r.getString(R.string.selection_tvout_Ypbpr720);
        final String str6 = r.getString(R.string.alert_close);
        CharSequence[] items = null;
        if (ConfigUtil.IS_ENABLE_TVOUTYBPR)
            items = new CharSequence[]{str1, str2, str3, str4, str5, str6};
        else
            items = new CharSequence[]{str1, str2, str6};
        choiceItems = new ArrayList<ChoiceItem>();
        for (int i = 0; i < items.length; i++) {
            ChoiceItem item = new ChoiceItem();
            item.content = (String) items[i];
            choiceItems.add(item);
        }
        return choiceItems;
    }

    //
    //
    // public void enableTVOut(int mode){
    // LOG("++++++++++++++==enable tvout now");
    // if ( null != mTvOutMgr ) {
    // ʹ�� TvOut, ��ʧ��, ��...
    // if ( mTvOutMgr.enableTvOut(true, mode) != 0 ) {
    // Log.e(TAG, "onOptionsItemSelected() : Faile to enable TvOut.");
    // }
    // else {
    // mOutputToTvOut = true;
    // mVideoDisplayView.mTVOutEnable = true;
    // }
    // }else{
    // LOG("++++++++++++++==tvout is null now");
    // }
    // }
    //
    //
    public void DisplayHdmi() {
        HdmiAlert = new AlertDialog.Builder(this)
                // builder.setTitle(str5);
                .setInverseBackgroundForced(true).setAdapter(
                        (ListAdapter) new ChoiceListAdapter(this,
                                R.layout.choice_item, addHdmiChoices()),
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int item) {
                                switch (item) {
                                    case 0: {
                                        HdmiAlert.dismiss();
                                        LOG("User set to output to HDMI with 720p resolution.");
                                        // * ʹ�� HDMI ���, ��ָ���ֱ���.
                                        // *pause the video
                                        LOG("Pause the video when hdmi start");
                                        mVideoDisplayView.pause();
                                        // enableHdmiOutput(HdmiManager.HDMI_720p);
                                        // * ��ʶ "�Ѿ� consume �˸��¼�".
                                        // *start the video
                                        mVideoDisplayView.start();
                                        LOG("Start the video after hdmi start");
                                    }
                                    break;
                                    case 2:
                                        HdmiAlert.dismiss();
                                        break;
                                    default:
                                        HdmiAlert.dismiss();
                                        break;
                                }
                            }
                        }).setTitle(R.string.selection_hdmi_title).show();
    }

    private ArrayList addHdmiChoices() {
        Resources r = this.getResources();
        final String hdmioutto = r.getString(R.string.output_to_hdmi);
        // final String p576 = r.getString(R.string.hdmi_576p);
        final String p720 = r.getString(R.string.hdmi_720p);
        // StringBuilder sb1 = new StringBuilder();
        // sb1.append(hdmioutto);
        // sb1.append(p576);
        StringBuilder sb2 = new StringBuilder();
        sb2.append(hdmioutto);
        sb2.append(p720);
        // final String str1 = sb1.toString();
        final String str2 = sb2.toString();
        final String str3 = r.getString(R.string.alert_close);
        // final CharSequence[] items = {str1,str2,str3};
        final CharSequence[] items = {str2, str3};
        choiceItems = new ArrayList<ChoiceItem>();
        for (int i = 0; i < items.length; i++) {
            ChoiceItem item = new ChoiceItem();
            item.content = (String) items[i];
            choiceItems.add(item);
        }
        return choiceItems;
    }

    //

    /**
     * for interface View.OnTouchListener.
     */
    // public boolean onTouch(View v, MotionEvent event) {
    // Log.v(TAG, "----------------onTouch----------------");
    // if(ConfigUtil.IS_ENABLE_TVOUT_TOUCH_EXIT){
    // // if ( v == mVideoDisplayView && mOutputToTvOut ) {
    // //
    // LOG("onTouch() : User touched device screen, to disable TvOut output.");
    // // disableTvOut();
    // // //change by wangbo 2011.03.07
    // // //toggleTopBarVisiblity();
    // //
    // // mVideoDisplayView.mTVOutEnable = false;
    // // return true;
    //
    // // }
    // if ( v == mVideoDisplayView && mOutputToHdmi ) {
    // LOG("onKey() : User press a key. to disable Hdmi output.");
    // disableHdmiOutput();
    // mVideoDisplayView.mTVOutEnable = false;
    // return true;
    // }
    // }
    // if (mVideoDisplayView.isPrepare()) {
    // // toggleMediaControlsVisiblity();
    // mGestureDetector.onTouchEvent(event);
    // mScaleDetector.onTouchEvent(event);
    // }
    // return true;
    // }
    //*************************************************************
    private float new_x, new_y;// 滑动时，记录前一次的位置
    private float xx, yy;// 记录滑动过程中变化的距离
    private int light_num;// 初始亮度获取
    private int lights;// 变化亮度
    // /手势操作视频进度，声音进度
    private float down_x;// 点击时X、Y轴的位置
    private float down_y;
    private float move_x;// 滑动时X、Y轴的位置
    private float move_y;
    private float x;// 滑动后X、Y轴变化的距离
    private float y;
    private int maxVolume;
    private static boolean touch_flag = false;
    private int per = 0;// 手势纵向移动时变化的声音
    private int pers = 0;// 中间变量，判断什么时候声音加1

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (mVideoDisplayView.isPrepare()) {
            // toggleMediaControlsVisiblity();
            mGestureDetector.onTouchEvent(event);
            mScaleDetector.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                if (mVideoDisplayView.isPrepare()) {
                    down_x = event.getX();// 点击屏幕的初始坐标
                    down_y = event.getY();
                    new_x = down_x;
                    new_y = down_y;

                    move_x = down_x;
                    move_y = down_y;
                }
                break;
            case MotionEvent.ACTION_MOVE:
                if (MOVE_TO_ADJUST_VOLUME && mVideoDisplayView.isPrepare()) {
                    new_x = move_x;
                    new_y = move_y;

                    move_x = event.getX();// 移动时的坐标
                    move_y = event.getY();

                    x = move_x - down_x;// 前后变化距离
                    y = move_y - down_y;

                    xx = move_x - new_x;
                    yy = move_y - new_y;
                    DisplayMetrics display = getResources().getDisplayMetrics();//屏幕信息
                    AudioManager audioManager = (AudioManager) mContext.getSystemService(Context.AUDIO_SERVICE);
                    maxVolume = audioManager.getStreamMaxVolume(AudioManager.STREAM_SYSTEM);//最大音量
                    int percent = display.heightPixels / maxVolume;// 计算一个声音与屏幕高度的比例
                    if (Math.abs(x) > 10 || Math.abs(y) > 10) {// 如果滑动，则不监听点击事件
                        touch_flag = true;
                    }
                    if (yy > 0 && Math.abs(y) > Math.abs(x)) {// 纵向滑动，改变声音的大小，、、减小声音
                        if (down_x > (display.widthPixels / 2)) {// 屏幕左面滑动调节音量
                            per = (int) (yy * 30) / percent;
                            if (per != pers) {
                                pers = per;
                                // 同步更新声音进度条的进度
                                DBUtils.volumeAdjust(mContext, mVideoDisplayView.getVolumeMode(), Def.VOLUMEMINUS);
                            }
                        }
                    } else if (yy < 0 && Math.abs(y) > Math.abs(x)) {// 增大声音
                        if (down_x > (display.widthPixels / 2)) {// 屏幕左面滑动调节音量
                            per = (int) (yy * 30) / percent;
                            if (per != pers) {
                                DBUtils.volumeAdjust(mContext, mVideoDisplayView.getVolumeMode(), Def.VOLUMEPLUS);
                                pers = per;
                            }
                        }
                    }
                }
                //*****************************************************************************************
                break;
            case MotionEvent.ACTION_UP:
                if (mVideoDisplayView.isPrepare()) {
                    mVideoDisplayView.onFlingOffset();
                }
                break;
        }
        return true;
    }

    //
    public void toggleTopBarVisiblity() {
        if (this.isTopViewShow()) {
            this.hideTopView();
        } else {
            this.showTopView();
        }
    }

    //

    /**
     * for View.OnKeyListener.
     */
    public boolean onKey(View v, int keyCode, KeyEvent event) {

        LOG("onKey() : Entered, keyCode = " + keyCode);

		/* �������� View �� "mVideoDisplayView", �� ������� TvOut, �� ... */
        //
        // if ( v == mVideoDisplayView && mOutputToTvOut ) {
        // LOG("onKey() : User press a key. to disable TvOut output.");
        // //* ���� TvOut ���.
        // disableTvOut();
        // mVideoDisplayView.mTVOutEnable = false;
        // // ��ʶ "�Ѿ� consume ���¼�".
        // return true;
        // }
        //
        /* �������� View �� "mVideoDisplayView", �� ������� TvOut, �� ... */
        //
        if (v == mVideoDisplayView && mOutputToHdmi) {
            LOG("onKey() : User press a key. to disable Hdmi output.");
            // * ���� TvOut ���.
            disableHdmiOutput();
            mVideoDisplayView.mTVOutEnable = false;
            // ��ʶ "�Ѿ� consume ���¼�".
            return true;
        }
        //
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        // if(event.getRepeatCount() > 0){ //注释掉解决长按音量物理键无法连续减少或增加音量
        // return true;
        // }
        int keyCode = event.getKeyCode();
        if (keyCode == KeyEvent.KEYCODE_ENDCALL) {
            if (mOutputToTvOut) {
                // disableTvOut();
                // mVideoDisplayView.mTVOutEnable = false;
                // return true;
            } else {
                return false;
            }
        }
        //
        return super.dispatchKeyEvent(event);
    }

    //
    private void disableTvOut() {
        // if ( null != mTvOutMgr ) {
        // mTvOutMgr.enableTvOut(false, 0);
        // }
        mOutputToTvOut = false;
        // mTopView.setVisibility(View.GONE);
        mVideoDisplayView.mTVOutEnable = false;
    }

    //
    //
    public void TopBar_next(int count, int delay) {
        // TODO Auto-generated method stub
        mVideoDisplayView.pause();
        mStartSeekPos = mVideoDisplayView.getDuration();
        if (count < 6) {
            delay = delay * 25;
        } else {
            delay = 75000 + (delay - 3000) * 40;
        }
        long newpos = mStartSeekPos + delay;
        long duration = mVideoDisplayView.getDuration();
        if (newpos >= duration) {
            newpos = duration - 2000;
        }
        if (mVideoDisplayView.isSeekComplete()) {
            mVideoDisplayView.setSeekComplete(false);
            mVideoDisplayView.seekTo((int) newpos);
        }
        // ���seekǰ״̬�����ò���״̬
        if (!mPauseStatus) {
            mVideoDisplayView.start();
        }
    }

    public void TopBar_prev(int count, int delay) {
        // TODO Auto-generated method stub
        mVideoDisplayView.pause();
        mStartSeekPos = mVideoDisplayView.getDuration();
        if (count < 6) {
            delay = delay * 25;
        } else {
            delay = 75000 + (delay - 3000) * 40;
        }
        long newpos = mStartSeekPos - delay;
        if (newpos < 0) {
            newpos = 0;
        }
        if (mVideoDisplayView.isSeekComplete()) {
            mVideoDisplayView.setSeekComplete(false);
            mVideoDisplayView.seekTo((int) newpos);
        }
        if (!mPauseStatus) {
            mVideoDisplayView.start();
        }
    }

    public void TopBar_return() {
        // TODO Auto-generated method stub
        mVideoDisplayView.pause();
        // ���� TvOut ���.
        disableTvOut();
        mVideoDisplayView.start();
    }

    public void showTopView() {
        showTopView(sDefaultTimeout);
    }

    public void showTopView(int timeout) {/*
                                         * this.setProgress(); if(mTopView !=
										 * null){
										 * mTopView.setVisibility(View.VISIBLE);
										 * mTopViewShow = true; }
										 * updatePausePlay();
										 * mHandler.sendEmptyMessage(SHOWTIME);
										 * Message msg = new Message(); msg.what
										 * = TopView_FADEOUT; if (timeout != 0)
										 * {
										 * mHandler.removeMessages(TopView_FADEOUT
										 * ); mHandler.sendMessageDelayed(msg,
										 * timeout); }
										 */
    }

    public void hideTopView() {/*
                                 * if (mTopViewShow) {
								 * mHandler.removeMessages(SHOWTIME);
								 * if(mTopView!=null)
								 * mTopView.setVisibility(View.INVISIBLE); }
								 * mTopViewShow = false;
								 */
    }

    public boolean isTopViewShow() {
        return mTopViewShow;
    }

    public void TopBar_home() {
        // TODO Auto-generated method stub
        // * ���� TvOut ���.
        disableTvOut();
        mVideoDisplayView.pause();
        Intent i = new Intent();
        i.setAction(Intent.ACTION_MAIN);
        i.addCategory(Intent.CATEGORY_HOME);
        mContext.startActivity(i);
    }

    public void TopBar_pause() {
        // TODO Auto-generated method stub
        doPauseResume();
    }

    private void doPauseResume() {
        if (mVideoDisplayView.isPlaying()) {
            mVideoDisplayView.pause();
            mPauseStatus = true;
        } else {
            mVideoDisplayView.start();
            mPauseStatus = false;
        }
        updatePausePlay();
        // *
        // if(mStatusBar != null)
        // mStatusBar.updateInfo();
    }

    private void updatePausePlay() {
        if (mTopBar == null)
            return;

        TopBarButton button = (TopBarButton) mTopBar.getButton(TOPBAR_PAUSE);
        if (button == null)
            return;

        if (mVideoDisplayView.isPlaying()) {
            button.setBackgroundResource(R.drawable.pause_btn);
        } else {
            button.setBackgroundResource(R.drawable.play_btn);
        }
    }

    public void TopBar_volume(int mode) {
        // TODO Auto-generated method stub
        DBUtils.volumeAdjust(mContext, mVolumeMode, mode);
    }

    //
    public int getBrightMode() {
        return mBrightMode;
    }

    private Handler hideStatusBarHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    // IWindowManager mWindowManager =
                    // IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                    // try {
                    // if(mWindowManager.checkTempShowStatusBar()){
                    // // Log.i("onTouchEvent",
                    // "set to hide temp setTempShowStatusBar");
                    // if(!mWindowManager.setTempShowStatusBar(false)){
                    // hideStatusBarHandler.removeMessages(1);
                    // hideStatusBarHandler.sendEmptyMessageDelayed(1, 3000);
                    // }
                    // }
                    // } catch (Exception e) {
                    // e.printStackTrace();
                    // }
                    break;
            }
        }
    };

    // @Override
    // public boolean onKeyDown(int keyCode, KeyEvent event){
    // LOG(">>>>>>>>>>>>>>>>>>>>>on keydown:" + keyCode);
    // if (keyCode == KeyEvent.KEYCODE_MENU) {
    // if (mVideoDisplayView != null
    // && mVideoDisplayView.getVideoController() != null) {
    // mVideoDisplayView.toggleMediaControlsVisiblity();
    // }
    // }
    // return super.onKeyDown(keyCode, event);
    // }
    @Override
    public void onSystemUiVisibilityChange(int arg0) {
        // TODO Auto-generated method stub
        /*if (arg0 != View.SYSTEM_UI_FLAG_SHOW_FULLSCREEN) {
            getWindow().getDecorView().setSystemUiVisibility(
					View.SYSTEM_UI_FLAG_SHOW_FULLSCREEN);
		}
		LOG("onSystemUivisibitilychange arg0=" + arg0);*/

    }

    // @Override
    // public void onClick(View v) {
    // // TODO Auto-generated method stub
    // LOG("<----------------onClick-----------------");
    // mVideoDisplayView.toggleMediaControlsVisiblity();
    // }

    private class MyScaleListener extends
            ScaleGestureDetector.SimpleOnScaleGestureListener {

        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            if (Float.isNaN(scale) || Float.isInfinite(scale))
                return true;
            // Log.v(TAG, "-------------onScale---------------scale:" + scale);
//			 if(mVideoDisplayView.isPrepare()){
//			 mVideoDisplayView.setScreenSizeScale(scale);
//			 }
            return true;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            // Log.v(TAG, "-------------onScaleBegin---------------");
            return true;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector detector) {
            // Log.v(TAG, "-------------onScaleEnd---------------");
        }
    }

    private class MyGestureListener extends
            GestureDetector.SimpleOnGestureListener {
        @Override
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float dx,
                                float dy) {
            // Log.v(TAG,
            // "-----------onScroll--------------------dx:"+dx+",dy:"+dy);
            if (mVideoDisplayView.isPrepare()) {
                mVideoDisplayView.setOffset(dx, dy);
            }
            return true;
        }

        @Override
        public boolean onSingleTapUp(MotionEvent e) {
            // Log.v(TAG, "------------onSingleTapUp-------------------");
//			if (mVideoDisplayView.isPrepare()) {
            mVideoDisplayView.toggleMediaControlsVisiblity();
//			}
            return true;
        }

        @Override
        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
                               float velocityY) {
            // Log.v(TAG,
            // "--------------onFling-----------------velocityX:"+velocityX
            // +",velocityY:"+velocityY);
            return true;
        }

        @Override
        public boolean onDoubleTap(MotionEvent e) {
            // Log.v(TAG, "------------onDoubleTap-------------------");
            return true;
        }
    }
}
