/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.rk.RockVideoPlayer;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.rk.RockVideoPlayer.DBUtils.Def;
import android.rk.RockVideoPlayer.R.string;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;
import android.content.Intent;
import android.content.Context;

public class VideoController extends FrameLayout
        implements View.OnClickListener {
    private Context context = getContext();
    private static final String TAG = "VideoController";
    //	private static final boolean DEBUG = true;
    private static final boolean DEBUG = false;

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        } else {
            if (DebugUtil.isDebugFileExist())
                Log.d(TAG, msg);
        }
    }

    private ViewGroup mControllerView;
    private Handler mUiHandler = new Handler();
    private BookMarkRunnable mBookMarkRunnable = new BookMarkRunnable();
    private VideoPlayerControl mPlayer;
    //private WindowManager       mWindowManager;
    private ProgressBar mProgress;
    private TextView mEndTime, mCurrentTime, mVedioName;
    private boolean mShowing;
    private boolean mDragging = false;
    private static final int sDefaultTimeout = 4000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private static final int SHOW_FAST = 3;
    static StringBuilder mFormatBuilder;
    static Formatter mFormatter;
    private ImageView mPauseButton;
    private ImageView mNextButton;
    private ImageView mPreButton;
    private ImageView mBookmarkButton;
    private ImageView mReturnButton;
    private ImageView mPlayWindow;
    public ImageView mScreenBrightButton;
    private ImageView mScreenModeButton;
    private ImageView mAboutButton;
    private ImageView mVolumeMinus;
    private ImageView mVolumePlus;
    // private final int VOLUMEPLUS = Def.VOLUMEPLUS;
    // private final int VOLUMEMINUS = Def.VOLUMEMINUS;
    private long mStartSeekPos = 0;
    private long mLastSeekEventTime;
    public long mSeekTime;
    private int ScreenBrightnessMode;
    private static final int BRIGHT_LEVEL_ONE = 0;
    private static final int BRIGHT_LEVEL_TWO = 1;
    private static final int BRIGHT_LEVEL_THREE = 2;
    private static final int BRIGHT_LEVEL_FOUR = 3;
    private static final int BRIGHT_LEVEL_FIVE = 4;
    private static final int BRIGHT_LEVEL_SIX = 5;
    private static final int BRIGHT_LEVEL_SEVEN = 6;
    private static final int BRIGHT_LEVEL_EIGHT = 7;
    //private int                 mBrightMode;
    public static final int SCREEN_MODE_ORIGINAL = 0;
    public static final int SCREEN_MODE_169 = 1;
    public static final int SCREEN_MODE_43 = 2;
    public static final int SCREEN_MODE_FULL = 3;
    private int mBrightness;

    public int ScreenSizeMode;
    //  private boolean mEnable = true;
    private boolean mPauseStatus = false;

    private ArrayList<String> mSelectItems = new ArrayList<String>(9);
    ;
    private AlertDialog AboutDialog;
    private final int HIDE_ABOUTVIEW = 4;
    private boolean mShowChildDialog;

    // private int AboutCount = 5;
    private class BookMarkRunnable implements Runnable {

        @Override
        public void run() {
            // TODO Auto-generated method stub
            int currentPos = mPlayer.getCurrentPosition();
            if (currentPos == -1) {
                return;
            }
            //beacuse delay
            mPlayer.setBookmark(currentPos - 2000 > 0 ? (currentPos - 2000) : currentPos);
            if (ConfigUtil.IS_ENABLE_BOOKMARK_CAPTURE && !"http".equalsIgnoreCase(mPlayer.getCurrentUri().getScheme()) && !"rtsp".equalsIgnoreCase(mPlayer.getCurrentUri().getScheme())) {
//    			writeCaptureFlagFile();
//    			mPlayer.pause();
//        		show(sDefaultTimeout);
//        		updatePausePlay();
//        		thumbHandler.removeMessages(0);
//        		Message msg = new Message();
//        		msg.what = 0;
//        		LOG(">>>>>>>>>>>>>>>>>..send msg to capture");
//        		thumbHandler.sendMessageDelayed(msg, 200L);
            }
        }

    }

    public interface VideoPlayerControl {
        void start();

        void prev(int mode);

        void next(int mode);

        void pause();

        void displayVolume();

        void deleteBookmark();

        int getDuration();

        int getCurrentPosition();

        void seekTo(int pos);

        boolean isPlaying();

        int getBufferPercentage();

        int setScreenBright(int ScreenBright);

        int setScreenMode(int ScreenMode);

        boolean Capture();

        void setBookmark(int bookmark);

        Uri getCurrentUri();

        void setScreenSize(int width, int height);

        int getDefaultWidth();

        int getDefaultHeight();

        void Finish();

        void DisplayHelpView();

        void PlayFormBeginning();

        void setEnable(boolean mode);

        boolean isSeekComplete();

        void setSeekComplete(boolean mode);

        void hideController();

        int getRepeatMode();

        void DisplayRepeat();

        void SetScreenSizeClickMode(boolean mode);

        //
        void DisplayTvout();

        //
        //
        void DisplayHdmi();

        //
        int getBrightMode();

        int getVolumeMode();

        void setSubtitle();

        void setAudioTrack();

        void playWindow();

        boolean isShowSubTitle();

        void setSelectSubDialog();

        void updatePlayPauseStatus(boolean play);

        void refreshWindow();
    }

    ;

    public VideoController(Context context, int brightness) {
        this(context, null, brightness, -1);
    }

    public VideoController(Context context, ViewGroup attachView, int brightness, int layoutRes) {
        super(context);
        int res = layoutRes;
        if (res == -1) {
            if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                res = R.layout.media_controller;
            } else {
                res = R.layout.media_controller_port;
            }
        }
        RelativeLayout.LayoutParams ll = new RelativeLayout.LayoutParams(LayoutParams.MATCH_PARENT,
                LayoutParams.WRAP_CONTENT);
        this.setLayoutParams(ll);
        mControllerView = attachView;
        mBrightness = brightness;
        inflateLayout(context, res);
        requestFocus();
    }

    private void inflateLayout(Context context, int layoutRes) {
        ScreenSizeMode = DBUtils.getScreenValue(context);
        LayoutInflater factory = LayoutInflater.from(context);
        mControllerView.removeAllViews();
        factory.inflate(layoutRes, mControllerView);
        LOG("Enter inflateLayout");

        mPreButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_pre);
        ((android.rk.RockVideoPlayer.RepeatingImageButton) mPreButton).setRepeatListener(mRewListener, 260);
        mPreButton.setOnClickListener(this);

        mNextButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_next);
        ((android.rk.RockVideoPlayer.RepeatingImageButton) mNextButton).setRepeatListener(mFfwdListener, 260);
        mNextButton.setOnClickListener(this);

        mVolumeMinus = (ImageView) mControllerView.findViewById(R.id.menubar_button_volumeminus);
        ((android.rk.RockVideoPlayer.RepeatingImageButton) mVolumeMinus).setRepeatListener(mVolumeMinusListener, 260);
        mVolumeMinus.setOnClickListener(this);

        mVolumePlus = (ImageView) mControllerView.findViewById(R.id.menubar_button_volumeplus);
        ((android.rk.RockVideoPlayer.RepeatingImageButton) mVolumePlus).setRepeatListener(mVolumePlusListener, 260);
        mVolumePlus.setOnClickListener(this);

        mPauseButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_play);
        mPauseButton.setOnClickListener(this);

        mBookmarkButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_bookmark);
        mBookmarkButton.setOnClickListener(this);
        if (!ConfigUtil.IS_SHOW_BOOKMARK_SETTING) {
            mBookmarkButton.setVisibility(View.GONE);
        }

        mReturnButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_return);
        mReturnButton.setOnClickListener(this);
        mPlayWindow = (ImageView) mControllerView.findViewById(R.id.menubar_button_playwindow);
        mPlayWindow.setVisibility(View.INVISIBLE);
        mPlayWindow.setOnClickListener(this);

        mScreenBrightButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_bright);
        mScreenBrightButton.setOnClickListener(this);

        ScreenBrightnessMode = DBUtils.getBacklightMode(mContext);
        mScreenModeButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_screenmode);
        mScreenModeButton.setOnClickListener(this);

        mAboutButton = (ImageView) mControllerView.findViewById(R.id.menubar_button_settings);
        mAboutButton.setOnClickListener(this);

        mProgress = (ProgressBar) mControllerView.findViewById(R.id.mediacontroller_progress);
        if (mProgress instanceof SeekBar) {
            SeekBar seeker = (SeekBar) mProgress;
            seeker.setOnSeekBarChangeListener(mSeekListener);
        }
        mProgress.setMax(1000);
        mVedioName = (TextView) mControllerView.findViewById(R.id.movie_title);
        mEndTime = (TextView) mControllerView.findViewById(R.id.time_total);
        mCurrentTime = (TextView) mControllerView.findViewById(R.id.time_current);
        mFormatBuilder = new StringBuilder();
        mFormatter = new Formatter(mFormatBuilder, Locale.getDefault());

        addSelectItems();
    }

    public void setVedioName(String name) {
        mVedioName.setText(name);
    }

    private void addSelectItems() {

        Resources r = getContext().getResources();
        final String str0 = r.getString(R.string.Select_Sub_title);
        final String str1 = r.getString(R.string.resume_playing_restart);
        final String str2 = r.getString(R.string.alert_deletebookmark);
        final String str3 = r.getString(R.string.alert_repeatmode);
        final String str4 = r.getString(R.string.Subtitle_Select);
        final String str5 = r.getString(R.string.Audio_Track_Select);
        //final String str6 = r.getString(R.string.alert_tvout);
        //final String str7 = r.getString(R.string.alert_hdmi);
        final String str8 = r.getString(R.string.alert_help);
        final String str9 = r.getString(R.string.alert_close);
        if (ConfigUtil.IS_SHOW_BOOKMARK_SETTING) {
            mSelectItems.add(str1);
            mSelectItems.add(str2);
        }
        mSelectItems.add(str3);
        if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
            mSelectItems.add(str0);
            mSelectItems.add(str4);
            mSelectItems.add(str5);
        }
        mSelectItems.add(str8);
        mSelectItems.add(str9);

    }


    /*package*/
    public void setMediaPlayer(VideoPlayerControl player) {
        mPlayer = player;
        updatePausePlay();
        mBrightness = DBUtils.getBacklight(mContext, Def.MODE_SYSTEM);
        LOG("VideoController : mBrightness = " + DBUtils.getBacklight(mContext, mPlayer.getBrightMode()));
        //int mode = DBUtils.getBacklightMode(mContext);
        CheckAndsetBrihtness(mBrightness);
        //setScreenBrightness(mode,true);

    }

    /*package*/
    public void removeBookmarkRunnable() {
        if (mUiHandler != null) {
            mUiHandler.removeCallbacks(mBookMarkRunnable);
        }
    }

    public void onClick(View v) {
        Log.v(TAG, "Enter onClick()" + "and v = " + v);
        switch (v.getId()) {
            case R.id.menubar_button_pre:
                mPlayer.prev(mPlayer.getRepeatMode());
                break;
            case R.id.menubar_button_next:
                mPlayer.next(mPlayer.getRepeatMode());
                break;
            case R.id.menubar_button_volumeminus:
                show(sDefaultTimeout);
                if (ConfigUtil.USE_CUSTOM_VOLUME_UI) {
                    VideoPlayActivity.mCanDisplayCustomUI = true;
                    mPlayer.displayVolume();
                }
                DBUtils.volumeAdjust(mContext, mPlayer.getVolumeMode(), Def.VOLUMEMINUS);
                break;
            case R.id.menubar_button_volumeplus:
                show(sDefaultTimeout);
                if (ConfigUtil.USE_CUSTOM_VOLUME_UI) {
                    VideoPlayActivity.mCanDisplayCustomUI = true;
                    mPlayer.displayVolume();
                }
                DBUtils.volumeAdjust(mContext, mPlayer.getVolumeMode(), Def.VOLUMEPLUS);
                break;
            case R.id.menubar_button_play:
                show(sDefaultTimeout);
                doPauseResume();
                break;
            case R.id.menubar_button_bookmark:
                LOG("Button setBookmaik pressed");
                //why delay ..avoid the muti touch
                show(sDefaultTimeout);
                mUiHandler.removeCallbacks(mBookMarkRunnable);
                mUiHandler.postDelayed(mBookMarkRunnable, 500);
                break;
            case R.id.menubar_button_return:
                hide();
                if (mPlayer != null) {
                    mPlayer.Finish();
                }
                break;
            case R.id.menubar_button_playwindow:
                hide();
                if (mPlayer != null) {
                    mPlayer.playWindow();
                }
                break;
            case R.id.menubar_button_bright:
                show(sDefaultTimeout);
                if (ScreenBrightnessMode == BRIGHT_LEVEL_EIGHT) {
                    ScreenBrightnessMode = BRIGHT_LEVEL_ONE;
                } else {
                    ScreenBrightnessMode++;
                }
                setScreenBright(ScreenBrightnessMode);

                break;
            case R.id.menubar_button_screenmode:
                show(sDefaultTimeout);
                LOG("Enter mScreenModeListener and ScreenSizeMode = " + ScreenSizeMode);
                mPlayer.SetScreenSizeClickMode(true);
                if (ScreenSizeMode == SCREEN_MODE_FULL) {
                    ScreenSizeMode = SCREEN_MODE_ORIGINAL;
                } else {
                    ScreenSizeMode++;
                }
                setScreen(ScreenSizeMode);

                break;
            case R.id.menubar_button_settings:
                LOG(">>>>>>>>>>>>>>>>start show aboutview");
                long starttime = System.currentTimeMillis();
                mHandler.removeMessages(FADE_OUT);//hide();
                mHandler.removeMessages(HIDE_ABOUTVIEW);
                showAboutDialog();
                long endtime = System.currentTimeMillis();
                LOG(">>>>>>>>>>>>>>>>show aboutview:" + (endtime - starttime) + " ms");
                //zyy ask me to disable it in m7
//			        	Message msg = mHandler.obtainMessage(HIDE_ABOUTVIEW);
//			        	mHandler.sendMessageDelayed(msg, TIME_MIDDLE);

                break;
            default:
                break;
        }
    }

    /**
     * Show the controller on screen. It will go away
     * automatically after 3 seconds of inactivity.
     */
    public void show() {
        show(sDefaultTimeout);
    }

    /**
     * Show the controller on screen. It will go away
     * automatically after 'timeout' milliseconds of inactivity.
     *
     * @param timeout The timeout in milliseconds. Use 0 to show
     *                the controller until hide() is called.
     */
    public void show(int timeout) {
        if (!mShowing) {
            LOG(" ######################## video is show ########################");
            setProgress();
            if (mControllerView != null) {
                if (Build.VERSION.SDK_INT >= 30 && null != mPlayer) {
                    //fix controllview incomplete display after power off and on with disable lockscreen in android11
                    mPlayer.refreshWindow();
                }
                mControllerView.setVisibility(View.VISIBLE);
            }
            mShowing = true;
        }
        updatePausePlay();

        // cause the progress bar to be updated even if mShowing
        // was already true.  This happens, for example, if we're
        // paused with the progress bar showing the user hits play.
        mHandler.sendEmptyMessage(SHOW_PROGRESS);

        Message msg = mHandler.obtainMessage(FADE_OUT);
        if (timeout != 0) {
            mHandler.removeMessages(FADE_OUT);
            mHandler.removeMessages(SHOW_FAST);
            mHandler.sendMessageDelayed(msg, timeout);
        }
    }

    public void showfast(int timeout) {
        if (!mShowing) {
            setProgress(mSeekTime);
            if (mControllerView != null) {
                mControllerView.setVisibility(View.VISIBLE);
            }
            mShowing = true;
        }
        updatePausePlay();

        // cause the progress bar to be updated even if mShowing
        // was already true.  This happens, for example, if we're
        // paused with the progress bar showing the user hits play.
        mHandler.sendEmptyMessage(SHOW_FAST);

        Message msg = mHandler.obtainMessage(FADE_OUT);
        if (timeout != 0) {
            mHandler.removeMessages(FADE_OUT);
            mHandler.removeMessages(SHOW_PROGRESS);
            mHandler.sendMessageDelayed(msg, timeout);
        }
    }

    public boolean isShowing() {
        return mShowing;
    }

    /**
     * Remove the controller from the screen.
     */
    public void hide() {
        if (mShowing) {
            try {
                LOG(" @@@@@@@@@@ video is hide @@@@@@@@@@");
                mHandler.removeMessages(SHOW_PROGRESS);
                mHandler.removeMessages(SHOW_FAST);

                //setVisibility(View.INVISIBLE);
                if (mControllerView != null) {
                    // 	mControllerView.setVisibility(View.GONE);
                    mControllerView.setVisibility(View.GONE);
                }
            } catch (IllegalArgumentException ex) {
                Log.w("VideoController", "already removed");
            }
            mShowing = false;
        }
    }

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            int pos;
            switch (msg.what) {
                case FADE_OUT:
                    hide();
                    break;
                case SHOW_PROGRESS:
                    pos = setProgress();
                    if (mShowing && null != mPlayer && mPlayer.isPlaying()) {
                        msg = obtainMessage(SHOW_PROGRESS);
                        sendMessageDelayed(msg, 1000 - (pos % 1000));
                    }
                    break;
                case SHOW_FAST:
                    setProgress(mSeekTime);
                    if (mShowing && mPlayer.isPlaying()) {
                        msg = obtainMessage(SHOW_FAST);
                        sendMessageDelayed(msg, 200);
                    }
                    break;
                case HIDE_ABOUTVIEW:
                    AboutDialog.dismiss();
                    if (mPlayer.isPlaying() == false)
                        mPlayer.start();
                    break;
            }
        }
    };

    public String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;

        int seconds = totalSeconds % 60;
        int minutes = (totalSeconds / 60) % 60;
        int hours = totalSeconds / 3600;

        mFormatBuilder.setLength(0);
                  /*
                  if (hours > 0) {
		              return mFormatter.format("%02d:%02d:%02d", hours, minutes, seconds).toString();
		          } else {
		              return mFormatter.format("%02d:%02d", minutes, seconds).toString();
		          }
		          */
        return mFormatter.format("%02d:%02d:%02d", hours, minutes, seconds).toString();
    }

    private int setProgress() {
        LOG(">>>>>>>>>>>>Enter setProgress()<<<<<<<<<<");
        if (mPlayer == null) {
            return 0;
        }

        LOG("mPlayer/mDragging" + mPlayer + "/" + mDragging);

        int position = mPlayer.getCurrentPosition();
        int duration = mPlayer.getDuration();
        LOG("position:" + position + " duration:" + duration);
        if (mProgress != null) {
            if (duration > 0) {
                // use long to avoid overflow
                long pos = 1000L * position / duration;
                mProgress.setProgress((int) pos);
            }
            int percent = mPlayer.getBufferPercentage();
            mProgress.setSecondaryProgress(percent * 10);
        }

        if (mEndTime != null)
            mEndTime.setText(stringForTime(duration));
        if (mCurrentTime != null)
            mCurrentTime.setText(stringForTime(position));
        return position;
    }

    /*���ý�����ϵ�ʱ�䣬����ʱ��ΪҪ���óɵ�ʱ��*/
    private int setProgress(long time) {
        if (mPlayer == null || mDragging) {
            return 0;
        }
        //int position = mPlayer.getCurrentPosition();
        int position = (int) time;
        int duration = mPlayer.getDuration();
        if (mProgress != null) {
            if (duration > 0) {
                // use long to avoid overflow
                long pos = 1000L * position / duration;
                mProgress.setProgress((int) pos);
            }
            int percent = mPlayer.getBufferPercentage();
            mProgress.setSecondaryProgress(percent * 10);
        }

        if (mEndTime != null)
            mEndTime.setText(stringForTime(duration));
        if (mCurrentTime != null)
            mCurrentTime.setText(stringForTime(position));
        return position;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        LOG("<-------------------onTouchEvent---------------->");
        if (mShowing && event.getAction() == MotionEvent.ACTION_DOWN) {
            hide();
        } else {
            show(sDefaultTimeout);
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        show(sDefaultTimeout);
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        LOG(">>>>>>>>>keyCode:" + keyCode + "<<<<<<<<<");
        if (event.getRepeatCount() == 0 && event.getAction() == event.ACTION_DOWN && (
                keyCode == KeyEvent.KEYCODE_HEADSETHOOK ||
                        keyCode == KeyEvent.KEYCODE_MEDIA_PLAY_PAUSE ||
                        keyCode == KeyEvent.KEYCODE_SPACE)) {
            doPauseResume();
            show(sDefaultTimeout);
            return true;
        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_STOP) {
            if (mPlayer.isPlaying()) {
                mPlayer.pause();
                updatePausePlay();
            }
            return true;
        } else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
            // don't show the controls for volume adjustment
            DBUtils.volumeAdjust(mContext, mPlayer.getVolumeMode(), Def.VOLUMEMINUS);
            return true;
        } else if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
            DBUtils.volumeAdjust(mContext, mPlayer.getVolumeMode(), Def.VOLUMEPLUS);
            return true;
        } else if (keyCode == KeyEvent.KEYCODE_BACK || keyCode == KeyEvent.KEYCODE_MENU) {
            hide();
            //return true;
            return false;
        } else if (keyCode == KeyEvent.KEYCODE_HOME) {
            LOG(">>>>>>>>>BUTTON_HOME CLICKED <<<<<<<<<");
            DBUtils.setbackBacklight(mContext, mPlayer.getBrightMode());
            DBUtils.setbackVolume(mContext, mPlayer.getBrightMode());
            return false;
        } else {
            show(sDefaultTimeout);
        }
        return super.dispatchKeyEvent(event);
    }

    private View.OnClickListener mPauseListener = new View.OnClickListener() {
        public void onClick(View v) {
            doPauseResume();
            show(sDefaultTimeout);
        }
    };

    private void updatePausePlay() {
        if (null == mPlayer) {
            return;
        }
        if (mPlayer.isPlaying()) {
            mPauseButton.setImageResource(R.drawable.video_button_pause);
        } else {
            mPauseButton.setImageResource(R.drawable.video_button_play);
        }
    }

    private void updatePausePlay(boolean playing) {
        if (playing) {
            mPauseButton.setImageResource(R.drawable.video_button_pause);
        } else {
            mPauseButton.setImageResource(R.drawable.video_button_play);
        }
    }

    private void doPauseResume() {
        if (mPlayer.isPlaying()) {
            mPlayer.pause();
            mPlayer.updatePlayPauseStatus(false);
        } else {
            mPlayer.start();
            mPlayer.updatePlayPauseStatus(true);
        }
        updatePausePlay();
    }

    private OnSeekBarChangeListener mSeekListener = new OnSeekBarChangeListener() {
        long duration;

        public void onStartTrackingTouch(SeekBar bar) {
            LOG("<--------------onStartTrackingTouch--------------->");
            if (VideoDisplayView.isEnableSeek == false)
                return;
            setProgress();
            //show(3600000);
//		        	show(sDefaultTimeout);
            mHandler.removeMessages(FADE_OUT);
            mHandler.removeMessages(SHOW_FAST);
            //show(0);
            duration = mPlayer.getDuration();
            mPauseStatus = !mPlayer.isPlaying();
            //mPlayer.pause();
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromtouch) {
            LOG("<-----------------onProgressChanged------------>progress" + progress + " fromtouch=" + fromtouch);
            if (fromtouch) {
                if (VideoDisplayView.isEnableSeek == false)
                    return;
//		            	show(sDefaultTimeout);
                mDragging = true;
                duration = mPlayer.getDuration();
                long newposition = (duration * progress) / 1000L;
                //mPlayer.seekTo((int) newposition);
                if (mCurrentTime != null)
                    mCurrentTime.setText(stringForTime((int) newposition));
                if (mEndTime != null) {
                    mEndTime.setText(stringForTime((int) duration));
                }
                // mPlayer.start();
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            LOG("<------------------onStopTrackingTouch--------------->");
            if (VideoDisplayView.isEnableSeek == false)
                return;

            mDragging = false;
            int progress = mProgress.getProgress();
            duration = mPlayer.getDuration();
            long newposition = (duration * progress) / 1000L;
            if (newposition >= duration) {
                newposition = duration - 2000;
            }
            mPlayer.seekTo((int) newposition);
            mSeekTime = mPlayer.getCurrentPosition();
            if (mCurrentTime != null)
                mCurrentTime.setText(stringForTime((int) newposition));
            if (mEndTime != null) {
                mEndTime.setText(stringForTime((int) duration));
            }
            setProgress();
            mPlayer.start();
            try {
                Thread.sleep(50);
            } catch (Exception e) {
            }
            if (mPauseStatus) {
                mPlayer.pause();
            }
            //updatePausePlay();
            show(sDefaultTimeout);
            updatePausePlay(!mPauseStatus);
        }
    };

    private void showTime() {
        long duration;
        long nowtime;
        if (mPlayer != null) {
            duration = mPlayer.getDuration();
            nowtime = mPlayer.getCurrentPosition();
            if (mCurrentTime != null)
                mCurrentTime.setText(stringForTime((int) nowtime));
            if (mEndTime != null)
                mEndTime.setText(stringForTime((int) duration));
        }
    }

    private RepeatingImageButton.RepeatListener mRewListener =
            new RepeatingImageButton.RepeatListener() {
                public void onRepeat(View v, long howlong, int repcnt) {
                    if (VideoDisplayView.isEnableSeek == false)
                        return;
                    scanBackward(repcnt, howlong);
                    //show((int)howlong + 1000);
                    showfast(sDefaultTimeout);
                }

                public void isClick(boolean click) {
                    // TODO Auto-generated method stub
                    mPauseStatus = !mPlayer.isPlaying();
                    mPlayer.setEnable(click);
                    //setShortClickButtonMode(click);
                }

                public void doAfterLongclick() {
                    mPlayer.start();
                    try {
                        Thread.sleep(50);
                    } catch (Exception e) {
                    }
                    if (mPauseStatus) {
                        mPlayer.pause();
                    }
                    show(sDefaultTimeout);
                    mPlayer.setEnable(true);
                }

                public void doBeginLongclick() {
                    // TODO Auto-generated method stub
                    /*�ڳ�����ʼʱ�趨mSeekTime��ֵ*/
                    mSeekTime = mPlayer.getCurrentPosition();
                }
            };

    private RepeatingImageButton.RepeatListener mFfwdListener =
            new RepeatingImageButton.RepeatListener() {
                public void onRepeat(View v, long howlong, int repcnt) {
                    if (VideoDisplayView.isEnableSeek == false)
                        return;
                    scanForward(repcnt, howlong);
                    //show((int)howlong + 1000);
                    showfast(sDefaultTimeout);
                }

                public void isClick(boolean click) {
                    // TODO Auto-generated method stub
                    mPauseStatus = !mPlayer.isPlaying();
                    mPlayer.setEnable(click);
                    //setShortClickButtonMode(click);
                }

                public void doAfterLongclick() {
                    mPlayer.start();
                    try {
                        Thread.sleep(50);
                    } catch (Exception e) {
                    }
                    if (mPauseStatus) {
                        mPlayer.pause();
                    }
                    mPlayer.setEnable(true);
                    show(sDefaultTimeout);
                }

                public void doBeginLongclick() {
                    /*�ڳ�����ʼʱ�趨mSeekTime��ֵ*/
                    mSeekTime = mPlayer.getCurrentPosition();

                }
            };

    private void scanBackward(int repcnt, long delta) {
        LOG("Enter scanBackward()");
        if (mPlayer == null) return;
        if (repcnt == 0) {
            mStartSeekPos = mPlayer.getCurrentPosition();
            mLastSeekEventTime = 0;
            // mSeeking = false;
        } else {
            // mSeeking = true;
            if (delta < 3000) {
                // seek at 10x speed for the first 5 seconds
                delta = delta * 25;
                //delta = 6000;
            } else {
                // seek at 40x after that
                delta = 75000 + (delta - 3000) * 40;
                //delta = 6000;
            }
            long newpos = mStartSeekPos - delta;
            if (newpos < 0) {
                            /*
                             long duration = mPlayer.getDuration();
			                    mStartSeekPos += duration;
			                    newpos += duration;	  
			                    */
                mPlayer.pause();
                newpos = 0;

            }
            if (((delta - mLastSeekEventTime) > 250) || repcnt < 0) {
                if (mPlayer.isSeekComplete()) {
                    mPlayer.setSeekComplete(false);
                    mPlayer.seekTo((int) newpos);
                    mLastSeekEventTime = delta;
                }
                mSeekTime = newpos;
            }

        }
    }

    private void scanForward(int repcnt, long delta) {
        if (mPlayer == null)
            return;
        if (repcnt == 0) {
            mStartSeekPos = mPlayer.getCurrentPosition();
            mLastSeekEventTime = 0;
            //mSeeking = false;
        } else {
            // mSeeking = true;
            if (delta < 3000) {
                // seek at 10x speed for the first 5 seconds
                delta = delta * 25;
                //delta = 6000;
            } else {
                // seek at 40x after that
                delta = 75000 + (delta - 3000) * 40;
                //delta = 6000;
            }
            long newpos = mStartSeekPos + delta;
            long duration = mPlayer.getDuration();
            if (newpos >= duration) {
                            /*
                            mStartSeekPos -= duration; // is OK to go negative
		                    newpos -= duration;
		                    */
                mPlayer.pause();
                newpos = duration - 2000;
            }
            if (((delta - mLastSeekEventTime) > 250) || repcnt < 0) {
                if (mPlayer.isSeekComplete()) {
                    mPlayer.setSeekComplete(false);
                    mPlayer.seekTo((int) newpos);
                    mLastSeekEventTime = delta;
                }
                mSeekTime = newpos;
            }

        }

    }

    private void writeCaptureFlagFile() {
        File thumbfolder = new File("/flash/.videothumbs");
        if (thumbfolder.exists() == false) {
            try {
                thumbfolder.mkdir();
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        File captureFile = new File("/flash/videocapture");
        if (captureFile.exists() == false) {
            try {
                captureFile.createNewFile();
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    private void deleteCaptureFlagFile() {
        File file = new File("/flash/videocapture");
        if (file.exists()) {
            file.delete();
        }

        File bmpfile = new File("/flash/vcapture.bmp");
        if (bmpfile.exists()) {
            bmpfile.delete();
        }
    }

    public void saveMyBitmap(Bitmap mBitmap) throws IOException {
        LOG(">>>>>>>>>>>>>>>>>>>mPlayer.getCurrentUri():" + mPlayer.getCurrentUri());
        String videoPath = DBUtils.getVideoPath(mContext, mPlayer.getCurrentUri());
        if (videoPath == null)
            return;
        File f = new File("/flash/.videothumbs/" + videoPath.hashCode() + ".jpg");
        f.createNewFile();
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(f);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        mBitmap.compress(Bitmap.CompressFormat.JPEG, 100, fOut);
        try {
            fOut.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fOut.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long forJava(File f1, File f2) throws Exception {
        long time = new Date().getTime();
        int length = 2097152;
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buffer = new byte[length];
        while (true) {
            int ins = in.read(buffer);
            if (ins == -1) {
                in.close();
                out.flush();
                out.close();
                return new Date().getTime() - time;
            } else
                out.write(buffer, 0, ins);
        }
    }

    private Handler updatePauseHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            mPlayer.start();
            show(sDefaultTimeout);
            updatePausePlay();
        }
    };

    private static Object synobj = new Object();
    private Handler thumbHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            new Thread() {
                public void run() {
                    // TODO Auto-generated method stub
                    synchronized (synobj) {
                        LOG(">>>>>>>>>>>>>>>>..start capture thread");
                        long starttime = System.currentTimeMillis();
                        while (true) {
                            if ((System.currentTimeMillis() - starttime) > 3 * 60 * 1000L)
                                break;

                            if (new File("/flash/vcapture.bmp").exists()) {
                                Bitmap orgBmp = BitmapFactory.decodeFile("/flash/vcapture.bmp");
                                if (orgBmp == null)
                                    continue;
                                Bitmap thumbBmp = Bitmap.createScaledBitmap(orgBmp, 128, 128, false);
                                if (thumbBmp == null)
                                    continue;
                                try {
                                    saveMyBitmap(thumbBmp);
                                } catch (IOException e) {
                                    // TODO Auto-generated catch block
                                    e.printStackTrace();
                                }

                                thumbBmp.recycle();
                                orgBmp.recycle();
                                break;
                            }

                            try {
                                Thread.sleep(500L);
                            } catch (InterruptedException e) {
                                // TODO Auto-generated catch block
                                e.printStackTrace();
                            }
                        }

//		    					mPlayer.start();
                        updatePauseHandler.sendEmptyMessage(0);
                        deleteCaptureFlagFile();
                    }
                }
            }.start();
        }
    };


    private RepeatingImageButton.RepeatListener mVolumeMinusListener =
            new RepeatingImageButton.RepeatListener() {
                public void onRepeat(View v, long howlong, int repcnt) {
                    Message msg = volumeHandler.obtainMessage(Def.VOLUMEPLUS);
                    volumeHandler.sendMessage(msg);
                }

                public void isClick(boolean click) {
                    // TODO Auto-generated method stub
                    mPlayer.setEnable(click);
                    //setShortClickButtonMode(click);
                }

                public void doAfterLongclick() {
                    // TODO Auto-generated method stub

                }

                public void doBeginLongclick() {
                    // TODO Auto-generated method stub

                }
            };

    private RepeatingImageButton.RepeatListener mVolumePlusListener =
            new RepeatingImageButton.RepeatListener() {
                public void onRepeat(View v, long howlong, int repcnt) {
                    Message msg = volumeHandler.obtainMessage(Def.VOLUMEMINUS);
                    volumeHandler.sendMessage(msg);
                }

                public void isClick(boolean click) {
                    // TODO Auto-generated method stub
                    mPlayer.setEnable(click);
                    //	setShortClickButtonMode(click);
                }

                public void doAfterLongclick() {
                    // TODO Auto-generated method stub

                }

                public void doBeginLongclick() {
                    // TODO Auto-generated method stub

                }
            };
    Handler volumeHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case Def.VOLUMEPLUS: {
                    LOG("VolumeMinus Clicked!");
                    if (ConfigUtil.USE_CUSTOM_VOLUME_UI) {
                        VideoPlayActivity.mCanDisplayCustomUI = true;
                        mPlayer.displayVolume();
                    }
                    DBUtils.volumeAdjust(mContext, mPlayer.getVolumeMode(), Def.VOLUMEMINUS);
                    show(sDefaultTimeout);
                }
                break;
                case Def.VOLUMEMINUS: {
                    LOG("VolumePlus Clicked!");
                    if (ConfigUtil.USE_CUSTOM_VOLUME_UI) {
                        VideoPlayActivity.mCanDisplayCustomUI = true;
                        mPlayer.displayVolume();
                    }
                    DBUtils.volumeAdjust(mContext, mPlayer.getVolumeMode(), Def.VOLUMEPLUS);
                    show(sDefaultTimeout);
                }
                break;
            }
        }
    };


    private void setScreenBright(int mode) {
        setScreenBrightness(mode, true);
        //setSrcByMode(mode);
    }

    private void setScreenBrightness(int mode, boolean write) {
        LOG("setscreenbrightness mode=" + mode + " write=" + write);
        switch (mode) {
            case BRIGHT_LEVEL_ONE:
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 118);
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_ONE, 60);
                }
                mScreenBrightButton.setImageResource(R.drawable.video_bright1);
                //ScreenBrightnessMode = 0;
                break;
            case BRIGHT_LEVEL_TWO:
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 150);
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_TWO, 85);
                }
                mScreenBrightButton.setImageResource(R.drawable.video_bright2);
                //ScreenBrightnessMode = 1;
                break;
            case BRIGHT_LEVEL_THREE:
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_THREE, 105);
                }
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 182);
                mScreenBrightButton.setImageResource(R.drawable.video_bright3);
                break;
            case BRIGHT_LEVEL_FOUR:
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_FOUR, 130);
                }
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 214);
                mScreenBrightButton.setImageResource(R.drawable.video_bright4);
                break;
            case BRIGHT_LEVEL_FIVE:
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 255);
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_FIVE, 160);
                }
                mScreenBrightButton.setImageResource(R.drawable.video_bright5);
                break;
            case BRIGHT_LEVEL_SIX:
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 255);
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_SIX, 192);
                }
                mScreenBrightButton.setImageResource(R.drawable.video_bright6);
                break;
            case BRIGHT_LEVEL_SEVEN:
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 255);
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_SEVEN, 225);
                }
                mScreenBrightButton.setImageResource(R.drawable.video_bright7);
                break;
            case BRIGHT_LEVEL_EIGHT:
                //DBUtils.setBacklight(mContext, mPlayer.getBrightMode(), 255);
                if (write) {
                    DBUtils.setBacklightValueAndMode(mContext, mPlayer.getBrightMode(), BRIGHT_LEVEL_EIGHT, 255);
                }
                mScreenBrightButton.setImageResource(R.drawable.video_bright8);
                break;
        }
        ScreenBrightnessMode = mode;
    }

    private int CheckAndsetBrihtness(int brightness) {
        if (0 < mBrightness && mBrightness <= 60) {
            mScreenBrightButton.setImageResource(R.drawable.video_bright1);
            ScreenBrightnessMode = BRIGHT_LEVEL_ONE;
        } else if (60 < mBrightness && mBrightness <= 85) {
            ScreenBrightnessMode = BRIGHT_LEVEL_TWO;
            mScreenBrightButton.setImageResource(R.drawable.video_bright2);
        } else if (85 < mBrightness && mBrightness <= 105) {
            ScreenBrightnessMode = BRIGHT_LEVEL_THREE;
            mScreenBrightButton.setImageResource(R.drawable.video_bright3);
        } else if (105 < mBrightness && mBrightness <= 130) {
            ScreenBrightnessMode = BRIGHT_LEVEL_FOUR;
            mScreenBrightButton.setImageResource(R.drawable.video_bright4);
        } else if (130 < mBrightness && mBrightness <= 160) {
            ScreenBrightnessMode = BRIGHT_LEVEL_FIVE;
            mScreenBrightButton.setImageResource(R.drawable.video_bright5);
        } else if (160 < mBrightness && mBrightness <= 192) {
            ScreenBrightnessMode = BRIGHT_LEVEL_SIX;
            mScreenBrightButton.setImageResource(R.drawable.video_bright6);
        } else if (192 < mBrightness && mBrightness <= 225) {
            ScreenBrightnessMode = BRIGHT_LEVEL_SEVEN;
            mScreenBrightButton.setImageResource(R.drawable.video_bright7);
        } else if (225 < mBrightness && mBrightness <= 255) {
            ScreenBrightnessMode = BRIGHT_LEVEL_EIGHT;
            mScreenBrightButton.setImageResource(R.drawable.video_bright8);
        }
        return ScreenBrightnessMode;
    }


    public void setScreen(int ScreenSizeMode) {
        setButtonSrcByMode(ScreenSizeMode);
        setScreensize(ScreenSizeMode, true);
    }

    public void setScreensize(int mode, boolean write) {
        if (mPlayer != null) {
            mPlayer.setScreenMode(mode);
        }
        switch (mode) {
            case SCREEN_MODE_ORIGINAL:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_original);
                break;
            case SCREEN_MODE_169:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_169);
                break;
            case SCREEN_MODE_43:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_43);
                break;
            case SCREEN_MODE_FULL:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_full);
                break;
        }
        ScreenSizeMode = mode;
        if (write) {
            DBUtils.setScreenValue(mContext, mode);
        }
    }

    public void setButtonSrcByMode(int mode) {
        if (mScreenModeButton == null) {
            return;
        }
        switch (mode) {
            case 0:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_original);
                ScreenSizeMode = 0;
                break;
            case 1:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_169);
                ScreenSizeMode = 1;
                break;
            case 2:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_43);
                ScreenSizeMode = 2;
                break;
            case 3:
                mScreenModeButton.setImageResource(R.drawable.video_screenmode_full);
                ScreenSizeMode = 3;
                break;
        }
    }

    public void showAboutDialog() {
        if (ConfigUtil.IS_PAUSE_ONDIALOG) {
            new Thread() {
                @Override
                public void run() {
                    // TODO Auto-generated method stub
                    if (mPlayer.isPlaying())
                        mPlayer.pause();
                }
            }.start();
        }
        DialogInterface.OnDismissListener dismissListener = new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                Intent dismissHide = new Intent();
                dismissHide.setAction("action.dismiss.hide");
                context.sendBroadcast(dismissHide);
                mHandler.removeMessages(FADE_OUT);
                if (!mShowChildDialog) {
                    mShowChildDialog = false;
                    Message msg = mHandler.obtainMessage(FADE_OUT);
                    mHandler.removeMessages(SHOW_FAST);
                    mHandler.sendMessageDelayed(msg, sDefaultTimeout);
                }
            }
        };

        String[] items = new String[mSelectItems.size()];
        mSelectItems.toArray(items);

        DialogInterface.OnClickListener itemClickListener = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface arg0, int arg1) {
                // TODO Auto-generated method stub
/*                LOG("<------------abountDialog-----------------index=" + arg1);
                switch (arg1) {
                    case 0:
                        mPlayer.PlayFormBeginning();
                        break;
                    case 1:
                        mPlayer.deleteBookmark();
                        break;
                    case 2:
                        mShowChildDialog = true;
                        mPlayer.DisplayRepeat();
                        break;
                    case 3:
                        if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                            mShowChildDialog = true;
                            mPlayer.setSelectSubDialog();
                        } else {
                            mPlayer.DisplayHelpView();
                        }
                        break;
                    case 4:
                        if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                            mShowChildDialog = true;
                            mPlayer.setSubtitle();
                        } else {
                            AboutDialog.dismiss();
                            if (ConfigUtil.IS_PAUSE_ONDIALOG) {
                                if (mPlayer.isPlaying() == false)
                                    mPlayer.start();
                            }
                        }
                        break;
                    case 5:
                        if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                            mShowChildDialog = true;
                            mPlayer.setAudioTrack();
                        }
                        break;
                    case 6:
                        if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                            mPlayer.DisplayHelpView();
                        }
                        break;
                    case 7:
                        AboutDialog.dismiss();
                        if (ConfigUtil.IS_PAUSE_ONDIALOG) {
                            if (mPlayer.isPlaying() == false)
                                mPlayer.start();
                        }
                        break;
                }*/
                LOG("<------------abountDialog-----------------index=" + arg1 + " item " + mSelectItems.get(arg1));
                if (null == mPlayer) {// monkey
                    Log.w(TAG, "mPlayer is null, maybe monkey");
                    return;
                }
                Resources resources = context.getResources();
                if (resources.getString(R.string.Select_Sub_title).equals(mSelectItems.get(arg1))) {
                    if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                        mShowChildDialog = true;
                        mPlayer.setSelectSubDialog();
                    }
                } else if (resources.getString(R.string.resume_playing_restart).equals(mSelectItems.get(arg1))) {
                    mPlayer.PlayFormBeginning();
                } else if (resources.getString(R.string.alert_deletebookmark).equals(mSelectItems.get(arg1))) {
                    mPlayer.deleteBookmark();
                } else if (resources.getString(R.string.alert_repeatmode).equals(mSelectItems.get(arg1))) {
                    mPlayer.DisplayRepeat();
                } else if (resources.getString(R.string.Subtitle_Select).equals(mSelectItems.get(arg1))) {
                    if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                        mShowChildDialog = true;
                        mPlayer.setSubtitle();
                    }
                } else if (resources.getString(R.string.Audio_Track_Select).equals(mSelectItems.get(arg1))) {
                    if (ConfigUtil.IS_SUPPORT_EMBEDED_SUBTITLE) {
                        mShowChildDialog = true;
                        mPlayer.setAudioTrack();
                    }
                } else if (resources.getString(R.string.alert_help).equals(mSelectItems.get(arg1))) {
                    mPlayer.DisplayHelpView();
                } else if (resources.getString(R.string.alert_close).equals(mSelectItems.get(arg1))) {
                    AboutDialog.dismiss();
                    if (ConfigUtil.IS_PAUSE_ONDIALOG) {
                        if (mPlayer.isPlaying() == false)
                            mPlayer.start();
                    }
                }
            }
        };

        if (null != AboutDialog) {
            AboutDialog.cancel();
        }
        mShowChildDialog = false;
        AboutDialog = new AlertDialog.Builder(getContext()).setItems(items, itemClickListener)
                .setTitle(R.string.resume_playing_title).setOnDismissListener(dismissListener)
                .show();

    }

    public void setDisableWhen3gp() {
        mPreButton.setEnabled(false);
        mNextButton.setEnabled(false);
        mProgress.setEnabled(false);
    }

    public void hideAllDialog() {
        if (null != AboutDialog && AboutDialog.isShowing()) {
            AboutDialog.cancel();
        }
    }

    public void viewDialogDismiss() {
        if (null != mHandler) {
            mHandler.removeMessages(FADE_OUT);
            Message msg = mHandler.obtainMessage(FADE_OUT);
            mHandler.removeMessages(SHOW_FAST);
            mHandler.sendMessageDelayed(msg, sDefaultTimeout);
        }
    }
}

