/*
 * Copyright (C) 2009 The Rockchip Android MID Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.rk.RockVideoPlayer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManager.RunningServiceInfo;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.LoaderManager;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.CursorLoader;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.content.DialogInterface.OnKeyListener;
import android.content.Intent;
import android.content.Loader;
import android.content.res.Configuration;
import android.database.Cursor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaPlayer.OnPreparedListener;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.MediaStore.Video;
import android.rk.RockVideoPlayer.armFreq.util.Utils;
import android.rk.RockVideoPlayer.ui.DeleteFrame;
import android.rk.RockVideoPlayer.ui.Transition3d;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.Toast;
import android.content.pm.PackageManager;
import android.Manifest;

@DebugAnno(isEnableDebug = false)
public class RockVideoPlayer extends Activity implements View.OnCreateContextMenuListener, DBUtils.Def, LoaderManager.LoaderCallbacks<Cursor> {
    final static String TAG = "RockVideoPlayer";
    private static final boolean DEBUG = false;

    public void LOG(String msg) {
        if (DEBUG) {
            Log.d(TAG, msg);
        }
    }

    //now support 2 mode,maybe will have more later.
    //add by fjz(fjz@rock-chips.com)
    public static final int LIST_MODE = 0;
    public static final int GRID_MODE = 1;
    //used by menu
    private static final int LIST_MODE_ID = 0;
    private static final int GRID_MDOE_ID = 1;
    private int mDisplayMode = LIST_MODE;

    private static final String[] PROJECT = new String[]{MediaStore.Video.Media._ID,
            MediaStore.Video.Media.TITLE, MediaStore.Video.Media.DISPLAY_NAME,
            MediaStore.Video.Media.DURATION, MediaStore.Video.Media.MIME_TYPE,
            MediaStore.Video.Media.SIZE, MediaStore.Video.Media.BOOKMARK,
            MediaStore.Video.Media.DATA};

    public enum COL_IND {
        ID(0),
        TITLE(1),
        DISPLAY_NAME(2),
        DURATION(3),
        MIME_TYPE(4),
        SIZE(5),
        BOOKMARK(6),
        DATA(7);
        private int index;

        private COL_IND(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private Context mContext;
    //public  Cursor mVideoCursor;
    private String mSortOrder;
    private GridView mGridView;
    private ListView mListView;
    private int lostSelected = -1;
    private DeleteFrame deleteframe;

    private Transition3d mTransition3d = null;

    private boolean isdelete = false;
    private VideoListAdapter mVideoListAdapter;

    private Uri mCurrentVideoUri;
    private String mCurrentVideoFilename;
    private View MainView;
    static final int DIALOG_DELETE_CHOICE = 1;
    static final int DIALOG_DELETE_CONFIRM = 2;
    private int mLastPosition = 0;
    //private long mItemClickPosition = -1;
    int timeoutmode;
    int screenOn;
    int mOldBrightness;
    private ProgressDialog pd;
    private static BroadcastReceiver mReceiver;
    private BroadcastReceiver mMediaReceiver;
    private Uri mUri;
    private Integer mPlayTime;
//	public View        mProgressView;

    private MediaPlayer mMediaPlayer = null;
    private Player mPlayer = null;
    private IntentFilter intentFilter;

    public RockVideoPlayer() {
        mContext = this;
    }

    private boolean cursorLoader = true;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LOG("<--------------------onCreate----------------->");
        //requestWindowFeature(Window.FEATURE_ACTION_BAR);
        //getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
        //		WindowManager.LayoutParams.FLAG_FULLSCREEN);

        setContentView(R.layout.main_display_land);
        //getWindow().getDecorView().setBackgroundDrawable(null);
        MainView = findViewById(R.id.main_layout);
        mGridView = (GridView) findViewById(R.id.gridview);
        mGridView.setOnItemClickListener(mOnItemClickListener);

        //mGridView.setOnTouchListener(mOnTouchListener);
        mListView = (ListView) findViewById(R.id.listview);
        //mListView.setBackgroundColor(Color.BLACK);
        //mListView.setDrawingCacheEnabled(false);

        mListView.setOnItemLongClickListener(mOnItemLongClickListener);
        mListView.setOnItemClickListener(mOnItemClickListener);

        //mListView.setOnTouchListener(mOnTouchListener);
        //deleteframe = (DeleteFrame)findViewById(R.id.deleteframe);
        //mTransition3d = new Transition3d((ViewGroup)findViewById(R.id.displaylist), mListView, mGridView);
        cursorLoader = true;
        mVideoListAdapter = new VideoListAdapter(this, null, false);
        initLoader();
//		getLoaderManager().initLoader(0, null, this);

        mMediaPlayer = new MediaPlayer();
        mMediaPlayer.setOnPreparedListener(mOnPreparedListener);
        mMediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
        mPlayer = new Player(this);

        intentFilter = new IntentFilter(Intent.ACTION_MEDIA_SCANNER_FINISHED);
        intentFilter.addDataScheme("file");

        registMediaBroadcast();
        mReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {

                String action = intent.getAction();
                LOG("RockVideoPlayer action = " + action);
                if (action.equals(Intent.ACTION_MEDIA_SCANNER_FINISHED)) {
                    if (!cursorLoader) {
                        handler.removeMessages(UPDATE_MSG);
                        handler.sendEmptyMessageDelayed(UPDATE_MSG, 200);
                    }
                }
            }
        };
        LOG("<--------------------onCreate finish----------------->");
    }

    private final int UPDATE_MSG = 0x01;
    private Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case UPDATE_MSG:
                    StringBuilder where = new StringBuilder();
                    where.append(MediaStore.Video.Media._ID + " != ''");
                    where.append(" AND " + MediaStore.Video.Media.MIME_TYPE + " NOT LIKE 'audio%'");
                    Cursor cursor = mContext.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, PROJECT, where.toString(), null, mSortOrder);
                    if (cursor == null || cursor.getCount() == 0) {
                        toastNoVideo();
                    }
                    mVideoListAdapter.swapCursor(null);
                    mVideoListAdapter.swapCursor(cursor);
                    break;
            }
        }

    };

    /*
        @Override
        public boolean onPrepareOptionsMenu(Menu menu) {
            // TODO Auto-generated method stub

            switch(mDisplayMode){
            case LIST_MODE:
                menu.findItem(LIST_MODE_ID).setEnabled(false);
                menu.findItem(GRID_MDOE_ID).setEnabled(true);
                break;
            case GRID_MODE:
                menu.findItem(LIST_MODE_ID).setEnabled(true);
                menu.findItem(GRID_MDOE_ID).setEnabled(false);
                break;
            default:
                break;
            }
            return true;
        }

        @Override
        public boolean onCreateOptionsMenu(Menu menu) {
            // TODO Auto-generated method stub
             menu.add(Menu.NONE, LIST_MODE_ID,Menu.NONE,getResources().getString(R.string.list));
             menu.add(Menu.NONE,GRID_MDOE_ID,Menu.NONE,getResources().getString(R.string.grid));
            return true;
        }
    */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // TODO Auto-generated method stub
        switch (item.getItemId()) {
            case LIST_MODE_ID:
                mDisplayMode = LIST_MODE;
                break;
            case GRID_MDOE_ID:
                mDisplayMode = GRID_MODE;
                break;
            default:
                break;
        }
        VideoDisplayVisible(false);

        return true;
    }

    public void VideoDisplayVisible(boolean animation) {
        LOG("Begin to setListAdapter");

        switch (mDisplayMode) {
            case GRID_MODE:
                if (animation) {
                    mTransition3d.applyRotation(1, 0, 90);
                } else {
                    mGridView.setVisibility(View.VISIBLE);
                    mListView.setVisibility(View.GONE);
                }
                break;
            case LIST_MODE:
                if (animation) {
                    mTransition3d.applyRotation(-1, 0, 90);
                } else {
                    mListView.setVisibility(View.VISIBLE);
                    mGridView.setVisibility(View.GONE);
                }
                break;
            default:
                break;
        }
        mListView.setAdapter(mVideoListAdapter);
        mGridView.setAdapter(mVideoListAdapter);
        mListView.setSelection(mLastPosition);
    }

    public void VideoDisplayVInVisible() {
        MainView.setBackgroundResource(R.drawable.novideofile);
    }

    private void dismissAllDialog() {
        try {
            this.dismissDialog(DIALOG_DELETE_CHOICE);
        } catch (Exception e) {
        }
        try {
            this.dismissDialog(DIALOG_DELETE_CONFIRM);
        } catch (Exception e) {
        }
    }

    @Override
    public void onResume() {
        LOG("<-----------------------------onResume()------------------------->" + mLastPosition);
        super.onResume();
        getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
        /*if (this.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            isPortrait = false;
        }else if (this.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
        	isPortrait = true;
        }*/

        if (VideoDisplayView.bookmarkvideo != null) {
            //mVideoListAdapter.updateBookmarkVideo(VideoDisplayView.bookmarkvideo);
            VideoDisplayView.bookmarkvideo.clear();
        }

        //dismissAllDialog();

		/*String Dilog_tile = getResources().getString(R.string.load_title);
        String Dilog_wait = getResources().getString(R.string.wait);
		pd = ProgressDialog.show(this, Dilog_tile, Dilog_wait, true, false);*/

        VideoDisplayVisible(false);
        //updataAdapter();
        registerReceiver(mReceiver, new IntentFilter(intentFilter));
        LOG("<-----------------------------onResume finish------------------------->");
    }

    private void registMediaBroadcast() {
        IntentFilter intentFilter = new IntentFilter(
                Intent.ACTION_MEDIA_EJECT);
//		intentFilter.addAction(Intent.ACTION_MEDIA_SCANNER_STARTED);
//		intentFilter.addAction(Intent.ACTION_MEDIA_UNMOUNTED);
//		intentFilter.addAction(Intent.ACTION_MEDIA_REMOVED);
        intentFilter.addAction(Intent.ACTION_MEDIA_MOUNTED);
        intentFilter.addAction(Intent.ACTION_MEDIA_SCANNER_FINISHED);
        intentFilter.addDataScheme("file");
        mMediaReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Log.v(TAG, "--------------------------action:" + action);
                if (action.equals(Intent.ACTION_MEDIA_EJECT)) {
//						|| action.equals(Intent.ACTION_MEDIA_MOUNTED)
//						|| action.equals(Intent.ACTION_MEDIA_UNMOUNTED)
//						|| action.equals(Intent.ACTION_MEDIA_REMOVED)) {
//					Toast.makeText(RockVideoPlayer.this, getText(R.string.media_scanning),
//							Toast.LENGTH_SHORT).show();
//					finish();
                    mVideoListAdapter.swapCursor(null);
                    handler.removeMessages(UPDATE_MSG);
                    handler.sendEmptyMessageDelayed(UPDATE_MSG, 200);
                    return;
                }
                else if(action.equals(Intent.ACTION_MEDIA_MOUNTED)||action.equals(Intent.ACTION_MEDIA_SCANNER_FINISHED))
                {
                    handler.removeMessages(UPDATE_MSG);
                    handler.sendEmptyMessageDelayed(UPDATE_MSG, 200);
                    return;
                }
            }
        };
        registerReceiver(mMediaReceiver, new IntentFilter(intentFilter));
    }

    public void updataAdapter() {
        LogUtil.LOG("Enter updataAdapter()");
        LOG("  updataAdapter(),   mLastPosition = " + mLastPosition);
        setVideoDisplayViewBackground();
        mGridView.setAdapter(mVideoListAdapter);
        // mGridView.setSelection(mLastPosition);
        mListView.setAdapter(mVideoListAdapter);
        // mListView.setSelection(mLastPosition);
//		 Log.v("~~~~~~~~~~~~~~~~~~~~", "~~~~~~~~~~~~~~~~~~~~mLastPosition:"+mLastPosition);
//		 mListView.setSelectionFromTop(5, mLastPosition);
    }

    public void setVideoDisplayViewBackground() {
        LOG("Enter setVideoDisplayViewBackground() ");

		/*if (mVideoCursor == null) {
            MainView.setBackgroundResource(R.drawable.novideofile);
			return;
		}

		if (mVideoCursor.moveToFirst()) {
			MainView.setBackgroundResource(R.color.black);
//			mGridView.setSelection(mLastPosition);
//			mListView.setSelection(mLastPosition);
		} else {
			MainView.setBackgroundResource(R.drawable.novideofile);
		}*/
    }

    @Override
    public void onPause() {
        super.onPause();
        //startActivityHandler.removeMessages(START_ACTIVITY_MSG);
        //mReScanHandler.removeCallbacksAndMessages(null);
        unregisterReceiver(mReceiver);
        /*if(mVideoListAdapter.getSelectUri() != null){
            ResetMediaPlayer();
			mVideoListAdapter.clearSelectUri();
		}*/
        dismissAllDialog();
        mVideoListAdapter.cleanCache();
    }

    @Override
    public void onDestroy() {
        LOG("Enter onDestroy()");
        unregisterReceiver(mMediaReceiver);
        mVideoListAdapter.decodeThumbThreadClear();
        mVideoListAdapter.cleanCache();
        super.onDestroy();
    }


    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        // TODO Auto-generated method stub
        LOG("<---------onConfigurationchaged---------->" + newConfig.orientation);

        super.onConfigurationChanged(newConfig);
    }

    private Cursor getCurWithId(long id) {
        String videoid = Long.valueOf(id).toString();
        mCurrentVideoUri = Uri.withAppendedPath(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, videoid);
        if (mCurrentVideoUri == null) {
            return null;
        }
        return DBUtils.getCurrentCursor(this, mCurrentVideoUri);
    }

    /*	private OnClickListener mOnClickListener = new OnClickListener(){
            public void onClick(View v) {
                switch(v.getId()){
                case R.id.displaymode:
                    displaymode = !displaymode;
                    VideoDisplayVisible(true);
                    if(mVideoListAdapter.getSelectUri() != null){
                        ResetMediaPlayer();
                        mVideoListAdapter.clearSelectUri();
                    }
                    break;
                case R.id.deleteimage:
                    isdelete = !isdelete;
                    if(isdelete){
                        if(mVideoListAdapter.getSelectUri() != null){
                            ResetMediaPlayer();
                            mVideoListAdapter.clearSelectUri();
                        }
                        deleteimage.setImageResource(R.drawable.del_on);
                    }else{
                        deleteimage.setImageResource(R.drawable.del_off);
                    }
                    mVideoListAdapter.notifyDataSetChanged();
                    break;
                }
            }
        };*/
    private OnItemClickListener mOnItemClickListener = new OnItemClickListener() {
        public void onItemClick(AdapterView<?> l, View v, int position, long id) {
            synchronized (this) {
                if (!isdelete) {/*
                     mItemClickPosition = id;
					 if(mGridPlayPosition == position && mVideoListAdapter.getSelectUri() != null){
						 ResetMediaPlayer();	
						 mVideoListAdapter.clearSelectUri();
						 mGridPlayPosition = -1;
						 needplayvideosmall = false;
					 }else if(needplayvideosmall){
						ResetMediaPlayer();	
						Uri tmpselecturi = mVideoListAdapter.getSelectUri();
						mVideoListAdapter.clearSelectUri();
						Uri tmpUri = Uri.withAppendedPath(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, Long.valueOf(id).toString());
						mVideoHandler.removeMessages(UIMSG_UPDATESELECT);
						if(tmpselecturi == null || (tmpselecturi != null && !tmpselecturi.equals(tmpUri)))
							mVideoHandler.sendMessageDelayed(mVideoHandler.obtainMessage(UIMSG_UPDATESELECT, (Object)tmpUri), 0);
						mGridPlayPosition = position;
					 }else*/
                    {
                        // ResetMediaPlayer();
                        // mVideoListAdapter.clearSelectUri();

                        String videoid = Long.valueOf(id).toString();
                        Uri uri = Uri.withAppendedPath(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, videoid);
                        Cursor cur = getCurWithId(id);
                        if (cur == null)
                            return;
                        boolean work = DBUtils.isSeviceWorked(mContext, "com.android.rk.mediafloat.MediaFloatService");
                        if (work) {
                            LOG("play in window");
                            Intent intent = new Intent("com.rk.app.mediafloat.CUSTOM_ACTION");
                            intent.setPackage("com.android.rk.mediafloat");
                            intent.setClassName("com.android.rk.mediafloat", "com.android.rk.mediafloat.MediaFloatService");
                            intent.putExtra("URI", uri.toString());
                            //intent.putExtra("POSITION", getCurrentPosition());
                            mContext.startService(intent);
                        } else {
                            LOG("play in activity");

                            String path = cur.getString(cur.getColumnIndex(Video.Media.DATA));
                            String tepMimetype = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.MIME_TYPE));
                            if (DBUtils.checkVideoAvailable(RockVideoPlayer.this, cur)) {
                                cur.close();

                                mLastPosition = mListView.getFirstVisiblePosition();
                                Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                                intent.setClass(RockVideoPlayer.this, VideoPlayActivity.class);
                                //intent.putExtra("mediaTypes", mTepMimetype);
                                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                startActivity(intent);

                            } else
                                (Toast.makeText(RockVideoPlayer.this, R.string.alert_checkfile, Toast.LENGTH_SHORT)).show();
                        }
                    }
                } else {/*
					 ImageView tmp = (ImageView)l.findViewById(R.id.video_image);
					 int left = v.getLeft() + tmp.getLeft();
					 int top = v.getTop() + tmp.getTop();
					 int targettop = 0;//((ViewGroup)((ViewGroup)MainView).getChildAt(0)).getChildAt(1).getTop() + deleteimage.getHeight() * 1/3;
					 int targetleft =0;// deleteimage.getLeft() + deleteimage.getWidth() * 1/3;
					 View tmp2 = v.findViewById(R.id.video_image);
					 View tmp3 = findViewById(R.id.main_sec_layout);
					 boolean willNotCache = tmp2.willNotCacheDrawing();
					 tmp2.setWillNotCacheDrawing(false);
					 tmp2.buildDrawingCache();
					 Bitmap bitmap = Bitmap.createBitmap(tmp2.getDrawingCache());
					 tmp2.destroyDrawingCache();
					 tmp2.setWillNotCacheDrawing(willNotCache);
					 willNotCache = tmp3.willNotCacheDrawing();
					 tmp3.setWillNotCacheDrawing(false);
					 tmp3.buildDrawingCache();
					 Bitmap bitmapbk = Bitmap.createBitmap(tmp3.getDrawingCache());
					 tmp3.destroyDrawingCache();
					 tmp3.setWillNotCacheDrawing(willNotCache);
					 mPlayer.playBegin(R.raw.glasscrash_two, false);
					 deleteframe.setMove(left, top, targetleft, targettop, bitmap, bitmapbk);
		 	    		
					 Cursor cur = getCurWithId(id);
					 if(cur != null){	 
			    		 mCurrentVideoFilename = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
			    		 cur.close();
			    		 mHandler.postDelayed(deleteCallback, 100);	//delete
					 }
				 */
                }
            }
        }
    };
    //private String mTepMimetype = null;

    public long cancelThumbnailId = Long.MIN_VALUE;//jyzheng add
    private static final int START_ACTIVITY_MSG = 0x1;
    /* private Handler startActivityHandler = new Handler() {
         @Override
         public void handleMessage(Message msg) {
			if (msg.what == START_ACTIVITY_MSG) {
				if (cancelThumbnailId == Long.MIN_VALUE) {
//					Bundle b = msg.getData();
//					if(b == null){
//						return;
//					}
//					Uri uri= Uri.parse(b.getString("uri"));
//					String tepMimetype = b.getString("tepMimetype");
					mVideoListAdapter.changeCursor(null);
					Intent intent = new Intent(Intent.ACTION_VIEW, mUri);
					intent.setClass(RockVideoPlayer.this,VideoPlayActivity.class);
					//intent.putExtra("mediaTypes", mTepMimetype);
					intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
					startActivity(intent);
//					mLastPosition = msg.arg1;
				} else {
					startActivityHandler.sendEmptyMessageDelayed(START_ACTIVITY_MSG, 500);
//					startActivityHandler.sendMessageDelayed(msg, 500);
				}
			}
         }
     };*/

    private boolean isclickplaypoint = false;
    private float old_x = 0.0f;
    private float old_y = 0.0f;
    /*
    private OnTouchListener mOnTouchListener = new OnTouchListener(){
        public boolean onTouch(View v, MotionEvent event) {
            if(isPortrait){
                needplayvideosmall = false;
                return false;
            }
            int position = 0;
            int left = 0, top = 0;
            switch(event.getAction()){
            case MotionEvent.ACTION_DOWN:
                isclickplaypoint = true;
                needplayvideosmall = false;
                old_x = event.getX();
                old_y = event.getY();
                break;
            case MotionEvent.ACTION_MOVE:
                if(Math.abs(event.getX() - old_x) > 5 || Math.abs(event.getY() - old_y) > 5){
                    isclickplaypoint = false;
                    needplayvideosmall = false;
                }
                break;
            case MotionEvent.ACTION_UP:
                if(isclickplaypoint && Math.abs(event.getX() - old_x) <= 5 && Math.abs(event.getY() - old_y) <= 5){
                    if(displaymode){
                        position = mGridView.pointToPosition((int)old_x, (int)old_y) - mGridFirstVisibleItem;
                        ViewGroup mg = (ViewGroup) mGridView.getChildAt(position);
                        if(mg == null)
                            return false;
                        ViewGroup mg1 = (ViewGroup) mg.getChildAt(0);
                        ImageView mg2 =  (ImageView) mg1.getChildAt(2);
                        left = mg.getLeft() + mg1.getLeft() + mg2.getLeft();
                        top = mg.getTop() + mg1.getTop() + mg2.getTop();
                        if(old_x > left && old_x < left + mg2.getWidth() && old_y > top && old_y < top + mg2.getHeight()){
                            needplayvideosmall = true;
                        }
                    }else{
                        position = mListView.pointToPosition((int)old_x, (int)old_y) - mListFirstVisibleItem;
                        ViewGroup mg = (ViewGroup) mListView.getChildAt(position);
                        if(mg == null)
                            return false;
                        ViewGroup mg1 = (ViewGroup) mg.getChildAt(1);
                        ViewGroup mg2 =  (ViewGroup) mg1.getChildAt(0);
                        ImageView mg3 = (ImageView) mg2.getChildAt(1);
                        left = mg.getLeft() + mg1.getLeft() + mg2.getLeft() + mg3.getLeft();
                        top = mg.getTop() + mg1.getTop() + mg2.getTop() + mg3.getTop();
                        if(old_x > left && old_x < left + mg3.getWidth() && old_y > top && old_y < top + mg3.getHeight()){
                            needplayvideosmall = true;
                        }
                    }
                }
                break;
            }
            return false;
        }
    };*/
	/*
	private OnTouchListener gridOnTouchListener = new OnTouchListener(){
		public boolean onTouch(View v, MotionEvent event) {
			int position = 0;
			int left = 0, top = 0;
			switch(event.getAction()){
			case MotionEvent.ACTION_DOWN:
				isclickplaypoint = true;
				needplayvideosmall = false;
				old_x = event.getX();
				old_y = event.getY();
				break;
			case MotionEvent.ACTION_MOVE:
				if(Math.abs(event.getX() - old_x) > 5 || Math.abs(event.getY() - old_y) > 5){		
					isclickplaypoint = false;
					needplayvideosmall = false;
				}
				break;
			case MotionEvent.ACTION_UP:
				if(isclickplaypoint && Math.abs(event.getX() - old_x) <= 5 && Math.abs(event.getY() - old_y) <= 5){
					position = mGridView.pointToPosition((int)old_x, (int)old_y) - mGridFirstVisibleItem;
					ViewGroup mg = (ViewGroup) mGridView.getChildAt(position);
					ViewGroup mg1 = (ViewGroup) mg.getChildAt(0);
					ImageView mg2 =  (ImageView) mg1.getChildAt(2);
					left = mg.getLeft() + mg1.getLeft() + mg2.getLeft(); 
					top = mg.getTop() + mg1.getTop() + mg2.getTop(); 
					if(old_x > left && old_x < left + mg2.getWidth() && old_y > top && old_y < top + mg2.getHeight()){
						mg2.setImageResource(R.drawable.play_normal);
						needplayvideosmall = true;
					}
				}
				break;
			}
			return false;
		}
	};
	*/
    private OnItemLongClickListener mOnItemLongClickListener = new AdapterView.OnItemLongClickListener() {
        // @Override
        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
            if (Build.VERSION.SDK_INT >= ConfigUtil.ANDROID_SDK_VERSION_R
                    && ActivityManager.isUserAMonkey()) {
                Log.w(TAG, "not to enable long del file fuction during monkey >= R");
                return true;
            }
            Cursor cur = getCurWithId(id);
            if (cur == null)
                return false;
            mCurrentVideoFilename = cur.getString(cur.getColumnIndexOrThrow(MediaStore.Video.Media.DATA));
            cur.close();
//    		 mHandler.post(deleteCallback); 
            showDialog(DIALOG_DELETE_CONFIRM);
            //showDialog();
            return true;
        }
    };
    OnKeyListener mOnKeyListener = new OnKeyListener() {
        //		@Override
        public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
            switch (keyCode) {
                case KeyEvent.KEYCODE_BACK:
                    dialog.dismiss();
                    break;
            }
            return false;
        }
    };

    void showDialog() {
        DialogFragment newFragment = MyAlertDialogFragment.newInstance(
                R.string.delete_confirm);
        newFragment.show(getFragmentManager(), "dialog");
    }

    public void doPositiveClick() {
        // Do stuff here.
        Log.i("FragmentAlertDialog", "Positive click!");
        mHandler.post(deleteCallback);
    }

    public void doNegativeClick() {
        // Do stuff here.
        Log.i("FragmentAlertDialog", "Negative click!");
    }


    public static class MyAlertDialogFragment extends DialogFragment {

        public static MyAlertDialogFragment newInstance(int title) {
            MyAlertDialogFragment frag = new MyAlertDialogFragment();
            Bundle args = new Bundle();
            args.putInt("title", title);
            frag.setArguments(args);
            return frag;
        }

        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            int title = getArguments().getInt("title");

            return new AlertDialog.Builder(getActivity())
                    .setIcon(R.drawable.alert_dialog_icon)
                    .setTitle(title)
                    .setPositiveButton(R.string.yes,
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    ((RockVideoPlayer) getActivity()).doPositiveClick();
                                }
                            }
                    )
                    .setNegativeButton(R.string.no,
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    ((RockVideoPlayer) getActivity()).doNegativeClick();
                                }
                            }
                    )
                    .create();
        }
    }

//	 @Override    
//	 protected Dialog onCreateDialog(int id) {
//		    switch(id) {
//		    case DIALOG_DELETE_CHOICE:
//		    	String str = RockVideoPlayer.this.getResources().getString(R.string.delete_delete);
//		    	String str2 = RockVideoPlayer.this.getResources().getString(R.string.delete_file_title);
//		    	final CharSequence[] items = {str};
//		    	Dialog tmpabccong = null;
//		    	tmpabccong.setOnKeyListener(mOnKeyListener);
//		    	return new AlertDialog.Builder(this)
//		    	.setTitle(str2)
//		    	.setItems(items, new DialogInterface.OnClickListener() {
//		    	    public void onClick(DialogInterface dialog, int item) {
//		    	        //Toast.makeText(getApplicationContext(), items[item], Toast.LENGTH_SHORT).show();
//		    	    	showDialog(DIALOG_DELETE_CONFIRM);
//		    	    }
//		    	})
//		    	.create();
//		    case DIALOG_DELETE_CONFIRM:
//		    	return new AlertDialog.Builder(this)
//		    	.setMessage(R.string.delete_confirm)
//		    	       .setCancelable(false)		         
//		    	       .setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
//		    	           public void onClick(DialogInterface dialog, int id) {
//		    	        	   if(DBUtils.isMediaScannerScanning(mContext)){
//		    	        		   Toast.makeText(mContext, R.string.toast_isScanning, Toast.LENGTH_SHORT).show();
//		    	        		   return;
//		    	        	   }
//		    	        	   else{
//		    	        		   mHandler.post(deleteCallback); 
//		    	        	   }
//		    	           }
//		    	       })
//		    	       .setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
//		    	           public void onClick(DialogInterface dialog, int id) {
//		    	                dialog.cancel();
//		    	           }
//		    	       })
//		    	.create();
//		    default:
//		        return null;
//		    }
//		}

    @Override
    protected Dialog onCreateDialog(int id) {
        switch (id) {
            case DIALOG_DELETE_CHOICE:
                String str = RockVideoPlayer.this.getResources().getString(R.string.delete_delete);
                String str2 = RockVideoPlayer.this.getResources().getString(R.string.delete_file_title);
                final CharSequence[] items = {str};
                return new AlertDialog.Builder(this)
                        .setTitle(str2)
                        .setItems(items, new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int item) {
                                //Toast.makeText(getApplicationContext(), items[item], Toast.LENGTH_SHORT).show();
                                showDialog(DIALOG_DELETE_CONFIRM);
                            }
                        })
                        .create();
            case DIALOG_DELETE_CONFIRM:
                return new AlertDialog.Builder(this)
                        .setMessage(R.string.delete_confirm)
                        // .setCancelable(false)
                        .setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int id) {
                                if (DBUtils.isMediaScannerScanning(mContext)) {
                                    Toast.makeText(mContext, R.string.toast_isScanning, Toast.LENGTH_SHORT).show();
                                    return;
                                } else {
                                    mHandler.post(deleteCallback);
                                }
                            }
                        })
                        .setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int id) {
                                dialog.cancel();
                            }
                        })
                        .create();
            default:
                return null;
        }
    }

    Handler mHandler = new Handler();
    Runnable deleteCallback = new Runnable() {
        public void run() {
            if (isSpecialMtpMode()) {
                DBUtils.deleteViedoFile(RockVideoPlayer.this, mCurrentVideoFilename);
                DBUtils.deleteCurrentVideo(RockVideoPlayer.this, mCurrentVideoUri);
                Intent intent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE,
                    Uri.parse("file://" + mCurrentVideoFilename));
                sendBroadcast(intent);
            } else {
                DBUtils.deleteCurrentVideo(RockVideoPlayer.this, mCurrentVideoUri);
                DBUtils.deleteViedoFile(RockVideoPlayer.this, mCurrentVideoFilename);
            }
            handler.removeMessages(UPDATE_MSG);
            handler.sendEmptyMessageDelayed(UPDATE_MSG, 200);
        	/* if(deleteframe.getVisibility() == View.GONE){
	        	 String videoPath = null;
	        	 if(ConfigUtil.IS_ENABLE_BOOKMARK_CAPTURE){
	        		 videoPath = DBUtils.getVideoPath(mContext, mCurrentVideoUri);
	 				 if(videoPath != null){
	 					File thumbFile = new File(ConfigUtil.CAPTURE_DIR + videoPath.hashCode() + ".jpg");
	 	            	 if(thumbFile.exists())
	 	            		 thumbFile.delete();
	 				 }
	        	 }
	        	 
	         	
	         	 //mVideoListAdapter.setDeleteVideoPath(videoPath);
	         	 mVideoListAdapter.notifyDataSetChanged();
        	 }else{
        		 mHandler.postDelayed(deleteCallback, 100);
        	 }*/
        }
    };

    private boolean isSpecialMtpMode() {
        if (Build.VERSION.SDK_INT == ConfigUtil.ANDROID_SDK_VERSION_R) {
            try{
                String usbConfig = SystemProperties.get("sys.usb.config", "");
                if (usbConfig.contains("mtp")) {
                    return true;
                }
            } catch (Exception e) {
                //e.printStackTrace();
            }
        }
        return false;
    }
    /* public Cursor getVideoCursor(AsyncQueryHandler async){
    	 LogUtil.LOG("Enter getVideoCursor()");
    	 Cursor ret = null;
    	 mSortOrder = MediaStore.Video.Media._ID;
	        StringBuilder where = new StringBuilder();
	        where.append(MediaStore.Video.Media._ID + " != ''");
	        where.append(" AND " + MediaStore.Video.Media.MIME_TYPE + " NOT LIKE 'audio%'");
    	 if (async != null) {
    		 LogUtil.LOG("getVideoCursor:startQuery()");
             async.startQuery(0, null,
            		 MediaStore.Video.Media.EXTERNAL_CONTENT_URI,
            		 mCols,
            		 where.toString(), null, mSortOrder);           
         } else {
             ret = DBUtils.query(this,
            		 MediaStore.Video.Media.EXTERNAL_CONTENT_URI, mCols,
            		 where.toString(), null,mSortOrder);
         }
    	 LogUtil.LOG("ret/async = " + ret + "/" + async);
    	 if (ret != null && async != null) {
    		 LogUtil.LOG("getVideoCursor:initVideoCursor()");
	        	initVideoCursor(ret);
	     }	
    	 if (pd != null){
			 pd.dismiss();
    	 }
    	 return ret;
 	}*/
    /* public void initVideoCursor(Cursor newCursor){
    	 LogUtil.LOG("Enter initVideoCursor() and newCursor = " + newCursor);
		mVideoListAdapter.changeCursor(newCursor);
		LogUtil.LOG("mVideoCursor = " + mVideoCursor + "newCursor = " + newCursor);
		if (mVideoCursor == null) {
			if (pd != null){
			    pd.dismiss();
			}
			VideoDisplayVInVisible();
			mReScanHandler.sendEmptyMessageDelayed(0, 1000);// 1000);
			return;
		}
		LogUtil.LOG("mVideoCursor.moveToFirst() = and mVideoCursor.getCount() = "
				+ mVideoCursor.moveToFirst() + mVideoCursor.getCount());
		if (mVideoCursor.moveToFirst() == false || mVideoCursor.getCount() == 0) {
			if (pd != null)
				pd.dismiss();
			VideoDisplayVInVisible();
			HintNoVideo();
		} else if (mVideoCursor.getCount() != 0) {
			if (pd != null)
				pd.dismiss();
			// MainView.setBackgroundResource(R.drawable.textlistbak);
			MainView.setBackgroundResource(R.color.black);
//			mGridView.setSelection(mLastPosition);
//			mListView.setSelection(mLastPosition);
		}
		pd.dismiss(); 
 	}*/

    public void HintNoVideo() {
        Toast.makeText(this, R.string.no_mediafiles, 2000).show();
    }

    /*  private Handler mReScanHandler = new Handler() {
          @Override
          public void handleMessage(Message msg) {
              LOG("mReScanHandler  mTrackCursor / mVideoListAdapter = " + mVideoCursor + " / " + mVideoListAdapter);
              getVideoCursor(mVideoListAdapter.getQueryHandler());
          }
      };*/
    @Override
    protected void onStop() {
        //mVideoListAdapter.changeCursor(null);
        LOG(" -----> onStop,   ");

        super.onStop();
    }

    public int getDisplayMode() {
        return mDisplayMode;
    }

    public boolean getDeletePoint() {
        return isdelete;
    }
	/*@Override
	public boolean dispatchKeyEvent(KeyEvent event) {
		switch(event.getKeyCode()){
		case KeyEvent.KEYCODE_BACK:
			if(isdelete){
				isdelete = !isdelete;
				//deleteimage.setImageResource(R.drawable.del_on);
				mVideoListAdapter.notifyDataSetChanged();
				return true;
			}else{
				if(mVideoListAdapter.getSelectUri() != null){
					ResetMediaPlayer();
					mVideoListAdapter.clearSelectUri();
					return true;
				}
			}
			break;
		}
		return super.dispatchKeyEvent(event);
	}*/

    private final static int UIMSG_UPDATESELECT = 1;
    private final static int UIMSG_PLAYVIDEO = 2;
    private final static int UIMSG_CHECTBOTTOM = 3;
    //private final static int UIMSG_CHECKSCROLLFINISH = 4;
    //private final static int UIMSG_3DANIMATION = 5;
    private int scrollrepeatnum = 0;
    private boolean needcheck = true;

    Handler mVideoHandler = new Handler() {/*
		public void dispatchMessage(Message msg) {
			switch(msg.what){			
    		case UIMSG_UPDATESELECT:
    			Uri tmpUri = (Uri)msg.obj;
    			boolean needplay = mVideoListAdapter.setSelectUri(tmpUri);
    			mVideoListAdapter.notifyDataSetChanged();
    			scrollrepeatnum = 0;
    			if(needplay){
    				mVideoHandler.sendMessageDelayed(mVideoHandler.obtainMessage(UIMSG_PLAYVIDEO, (Object)tmpUri), 10);
    			}
    			break;
    		case UIMSG_PLAYVIDEO:
    			int delaytime = 0;
    			int childcount = mGridView.getChildCount();
    			View bottomview = mGridView.getChildAt(childcount - 1);
    			View topview = mGridView.getChildAt(0);
    			if(mDisplayMode == LIST_MODE){
    				childcount = mListView.getChildCount();
    				bottomview = mListView.getChildAt(childcount - 1);
        			topview = mListView.getChildAt(0);
    			}
    			View bottomviewSurfaceView = bottomview.findViewById(R.id.video_image);
    			View topviewSurfaceView = topview.findViewById(R.id.video_image);
    			int surfaceheightselect = mVideoListAdapter.getsurfaceheightselect();
    			if(bottomviewSurfaceView.getHeight() == surfaceheightselect){
    				int dif =  bottomview.getBottom() - mGridView.getHeight();
    				if(mDisplayMode==LIST_MODE){
    					dif =  bottomview.getBottom() - mListView.getHeight();
    				}
    				if(dif > 0){
    					needcheck = false;
    	    			scrollrepeatnum = 0;
    	    			if(mDisplayMode==GRID_MODE){
    						dif -= 50;
    						if(dif < 0)
    							dif = 0;
//    	    				mGridView.smoothScrollBy(dif, 100);
    	    				mGridView.scrollBy(0, dif);
    	    			}else{
//    	    				mListView.smoothScrollBy(dif, 100);
    	    				mListView.scrollBy(0, dif);
    	    			}
    					delaytime = 150;
    				}
    			}else if(topviewSurfaceView.getHeight() == surfaceheightselect && topview.getTop() < 0){
    				int dif = topview.getTop();
    				LOG(" -> UIMSG_PLAYVIDEO,  topview.getTop() = " + topview.getTop() + "  dif = " + dif);
					needcheck = false;
	    			scrollrepeatnum = 0;
	    			if(mDisplayMode==GRID_MODE){
	    				dif += 50;
//	    				mGridView.smoothScrollBy(dif, 100);
	    				mGridView.scrollBy(0, dif);
	    			}else{
//	    				mListView.smoothScrollBy(dif, 100);
	    				mListView.scrollBy(0, dif);
	    			}
					delaytime = 150;
    			}
    			int lastchild = 4;
    			if((mDisplayMode==GRID_MODE) && childcount > lastchild){
    				boolean need_scantop = true;
    				for(int i = 0; i < lastchild - 1; i ++){
    					bottomview = mGridView.getChildAt(childcount - 2 - i);
    	    			if(mDisplayMode==LIST_MODE){
    	    				bottomview = mListView.getChildAt(childcount - 2 - i);
    	    			}
    	    			bottomviewSurfaceView = bottomview.findViewById(R.id.video_image);
    	    			if(bottomviewSurfaceView.getHeight() == surfaceheightselect){
    	    				need_scantop = false;
    	    				int dif =  bottomview.getBottom() - mGridView.getHeight();
    	    				if(mDisplayMode==LIST_MODE){
    	    					dif =  bottomview.getBottom() - mListView.getHeight();
    	    				}
    	    				if(dif > 0){
    	    					needcheck = false;
    	    	    			scrollrepeatnum = 0;
    	    	    			if(mDisplayMode==GRID_MODE){
    	    						dif -= 50;
    	    						if(dif < 0)
    	    							dif = 0;
//    	    	    				mGridView.smoothScrollBy(dif, 100);
    	    	    				mGridView.scrollBy(0, dif);
    	    	    			}else{
//    	    	    				mListView.smoothScrollBy(dif, 100);
    	    	    				mListView.scrollBy(0, dif);
    	    	    			}
    	    					delaytime = 150;
    	    				}
    	    				break;
    	    			}
    				}
    				if(need_scantop){
    					for(int i = 1; i < lastchild; i ++){
    		    			topview = mGridView.getChildAt(i);
    		    			if(mDisplayMode==LIST_MODE){
    		    				childcount = mListView.getChildCount();
    		        			topview = mListView.getChildAt(i);
    		    			}
    		    			bottomviewSurfaceView = bottomview.findViewById(R.id.video_image);
    		    			topviewSurfaceView = topview.findViewById(R.id.video_image);
    		    			if(topviewSurfaceView.getHeight() == surfaceheightselect && topview.getTop() < 0){
    		    				int dif = topview.getTop();
    							needcheck = false;
    			    			scrollrepeatnum = 0;
    			    			if(mDisplayMode==GRID_MODE){
    			    				dif += 50;
//    			    				mGridView.smoothScrollBy(dif, 100);
    			    				mGridView.scrollBy(0, dif);
    			    			}else{
//    			    				mListView.smoothScrollBy(dif, 100);
    			    				mListView.scrollBy(0, dif);
    			    			}
    							delaytime = 150;
        	    				break;
    		    			}
    					}
    				}
    			}
		    	sendMessageDelayed(obtainMessage(UIMSG_CHECTBOTTOM, msg.obj), delaytime);
		    	break;
    		case UIMSG_CHECTBOTTOM:
				try{
//		            mMediaPlayer.setDisplay(videoHolder);	//for test
					mMediaPlayer.setDisplay(mVideoListAdapter.getVideoHolder());
		            mMediaPlayer.setDataSource(RockVideoPlayer.this, (Uri)msg.obj);
		            mMediaPlayer.prepare();
		            mPlayTime = DBUtils.getBookmark(mContext, (Uri)msg.obj) + 1000;
		    	}catch(Exception e){
		    		e.printStackTrace();
		    	}
    			needcheck = true;
    			break;
    		case UIMSG_CHECKSCROLLFINISH:
    			synchronized (mobject) {			
    				mScrollState = 0;
    			}
    			break;
    			
    		case UIMSG_3DANIMATION:
    			synchronized (mobject) {			
    				mScrollState = 0;
    			}    			
    			break;
			}
		};
	*/
    };

    private void ResetMediaPlayer() {
        if (mMediaPlayer == null)
            return;
        if (mMediaPlayer.isPlaying()) {
            mMediaPlayer.stop();
            mMediaPlayer.reset();
            mMediaPlayer.setOnPreparedListener(mOnPreparedListener);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
        } else {
            mMediaPlayer.reset();
            mMediaPlayer.setOnPreparedListener(mOnPreparedListener);
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
        }
    }

    OnPreparedListener mOnPreparedListener = new OnPreparedListener() {
        public void onPrepared(MediaPlayer mp) {
            LOG(" onPrepared()  " + mp.getVideoWidth() + "   " + mp.getVideoHeight());
            if (mMediaPlayer != null) {
                mMediaPlayer.start();
                mMediaPlayer.seekTo(mPlayTime);
            }
        }
    };

    //private int mGridFirstVisibleItem = 0;
    // private int mListFirstVisibleItem = 0;
    // private int mGridPlayPosition = -1;
    // private int mListPlayPosition = -1;
    // private boolean needplayvideosmall = false;
   /* OnScrollListener mOnScrollListener = new OnScrollListener(){
		public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
			if(mDisplayMode==GRID_MODE)
				mGridFirstVisibleItem = firstVisibleItem;
			else
				mListFirstVisibleItem = firstVisibleItem;
			if(needcheck)
				scrollrepeatnum ++;
			if(mVideoListAdapter != null && mVideoListAdapter.getSelectUri() != null && scrollrepeatnum > 4 && needcheck){
				scrollrepeatnum = 0;
				ResetMediaPlayer();
				mVideoListAdapter.clearSelectUri();
			}
			if(mScrollState == 2){
				mVideoHandler.removeMessages(UIMSG_CHECKSCROLLFINISH);
				mVideoHandler.sendEmptyMessageDelayed(UIMSG_CHECKSCROLLFINISH, 500);
			}
		}
		public void onScrollStateChanged(AbsListView view, int scrollState) {
			mVideoHandler.removeMessages(UIMSG_CHECKSCROLLFINISH);
			synchronized (mobject) {				
				mScrollState = scrollState;
			}
			if(scrollState == 2){
				scrollrepeatnum = 0;
				ResetMediaPlayer();
				mVideoListAdapter.clearSelectUri();
			}
		}
    };*/
    // private int mScrollState = 0;
    // private boolean isPortrait = false;
 /*   @Override
    public void onConfigurationChanged(Configuration newConfig){
        super.onConfigurationChanged(newConfig);
        if (this.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
        	isPortrait = false;
        }else if (this.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
        	isPortrait = true;
        }
    }*/

	/*public boolean getIsPortrait(){
		return isPortrait;
	}*/
    //private Object mobject = new Object();
	/*public int getScrollState(){
		int state = 0;
		synchronized (mobject) {
			state = mScrollState;			
		}
		return state;
	}*/

    public void initLoader() {
        for (String permission : CheckPermissionActivity.REQUEST_PERMISSIONS) {
            if (PackageManager.PERMISSION_GRANTED != checkSelfPermission(permission)) {
                requestPermissions(CheckPermissionActivity.REQUEST_PERMISSIONS,
                        CheckPermissionActivity.REQUEST_CODE_ASK_PERMISSIONS);
                return;
            }
        }
        getLoaderManager().initLoader(0, null, this);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case CheckPermissionActivity.REQUEST_CODE_ASK_PERMISSIONS:
                if (null == grantResults || grantResults.length < 1) {//monkey will enter
                    String toast_text = getResources().getString(R.string.err_permission);
                    Toast.makeText(RockVideoPlayer.this, toast_text,
                            Toast.LENGTH_SHORT).show();
                    return;
                } else {
                    for (int result : grantResults) {
                        if (result != PackageManager.PERMISSION_GRANTED) {
                            // Permission Denied
                            String toast_text = getResources().getString(R.string.err_permission);
                            Toast.makeText(RockVideoPlayer.this, toast_text,
                                    Toast.LENGTH_SHORT).show();
                            return;
                        }
                    }
                }
                getLoaderManager().initLoader(0, null, this);
                break;
            default:
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @Override
    public Loader<Cursor> onCreateLoader(int arg0, Bundle arg1) {
        // TODO Auto-generated method stub
        LOG("<-------------- onCreateLoader-------------->");
        mSortOrder = MediaStore.Video.Media._ID;
        StringBuilder where = new StringBuilder();
        where.append(MediaStore.Video.Media._ID + " != ''");
        where.append(" AND " + MediaStore.Video.Media.MIME_TYPE + " NOT LIKE 'audio%'");
        return new CursorLoader(RockVideoPlayer.this, MediaStore.Video.Media.EXTERNAL_CONTENT_URI, PROJECT, where.toString(), null, mSortOrder);

    }

    @Override
    public void onLoadFinished(Loader<Cursor> arg0, Cursor arg1) {
        if (arg1 == null || arg1.getCount() == 0) {
            toastNoVideo();
        }
        if (arg1 != null) {
            cursorLoader = true;
            mVideoListAdapter.swapCursor(arg1);
        } else {
            cursorLoader = false;
        }
        //getLoaderManager().getLoader(0).stopLoading();

    }

    @Override
    public void onLoaderReset(Loader<Cursor> arg0) {
        mVideoListAdapter.swapCursor(null);

    }

    private void toastNoVideo() {
        StringBuilder where = new StringBuilder();
        where.append(MediaStore.Video.Media._ID + " != ''");
        where.append(" AND " + MediaStore.Video.Media.MIME_TYPE + " NOT LIKE 'audio%'");
        Cursor cursor = mContext.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, PROJECT, where.toString(), null, null);
        if ((cursor == null || cursor.getCount() == 0) && !isMediaScannerScanning(mContext.getContentResolver())) {
            Toast.makeText(mContext, R.string.no_mediafiles, Toast.LENGTH_SHORT).show();
        }
        if (cursor != null) {
            cursor.close();
            cursor = null;
        }
    }

    private static final boolean isMediaScannerScanning(final ContentResolver cr) {
        boolean result = false;
        Cursor cursor = query(cr, MediaStore.getMediaScannerUri(), new String[]{MediaStore.MEDIA_SCANNER_VOLUME}, null,
                null, null);
        if (cursor != null) {
            if (cursor.getCount() == 1) {
                cursor.moveToFirst();
                result = "external".equals(cursor.getString(0));
            }
            cursor.close();
            cursor = null;
        }
        return result;
    }

    private static final Cursor query(final ContentResolver resolver, final Uri uri, final String[] projection,
                                      final String selection, final String[] selectionArgs, final String sortOrder) {
        try {
            if (resolver == null) {
                return null;
            }
            return resolver.query(uri, projection, selection, selectionArgs, sortOrder);
        } catch (UnsupportedOperationException ex) {
            return null;
        }
    }
}
